/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.gson;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.github.jchanghong.gson.JacksonModel2;
import com.github.jchanghong.gson.Json2kotlinclass;
import com.github.jchanghong.gson.LocalDateDeserializer2;
import com.github.jchanghong.gson.LocalDateTimeDeserializer2;
import com.github.jchanghong.log.KStaticLogKt;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0006\u0010\f\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/github/jchanghong/gson/JsonHelper;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "configObjectMapper", "jsonToKotlinClass", "", "json", "", "newJacksonMapper", "kotlin-lib"})
public final class JsonHelper {
    @NotNull
    public static final JsonHelper INSTANCE = new JsonHelper();
    @NotNull
    private static final ObjectMapper objectMapper = INSTANCE.newJacksonMapper();

    private JsonHelper() {
    }

    @NotNull
    public final String jsonToKotlinClass(@NotNull List<String> json) {
        Intrinsics.checkNotNullParameter(json, (String)"json");
        return Json2kotlinclass.INSTANCE.jsonToKotlinClass(json);
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @NotNull
    public final ObjectMapper newJacksonMapper() {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
        return this.configObjectMapper(objectMapper);
    }

    @NotNull
    public final ObjectMapper configObjectMapper(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        objectMapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
        objectMapper.configure(JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        List findModules = ObjectMapper.findModules();
        for (Module module : findModules) {
            String string = module.getClass().getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.javaClass.canonicalName");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"JavaTimeModule", (boolean)false, (int)2, null)) continue;
            objectMapper.registerModule(module);
            KStaticLogKt.kInfo(Intrinsics.stringPlus((String)module.getClass().getCanonicalName(), (Object)":register"), new Object[0]);
        }
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DatePattern.NORM_DATETIME_FORMATTER));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DatePattern.NORM_DATE_FORMATTER));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer2(DatePattern.NORM_DATETIME_FORMATTER));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer2(DatePattern.NORM_DATE_FORMATTER));
        objectMapper.registerModule((Module)javaTimeModule);
        KStaticLogKt.kInfo(Intrinsics.stringPlus((String)javaTimeModule.getClass().getCanonicalName(), (Object)":register"), new Object[0]);
        objectMapper.registerModule((Module)new JacksonModel2());
        return objectMapper;
    }
}

