/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.kafka;

import cn.hutool.core.thread.ThreadUtil;
import com.github.jchanghong.kafka.SpringKafkaHelperKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.kafka.listener.MessageListener;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\"\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0003J\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cJ\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010\u0017\u001a\u00020\u0003J\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0016JR\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00052\u0018\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030'0&2\u0010\b\u0002\u0010(\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010&J\u0006\u0010)\u001a\u00020!R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/github/jchanghong/kafka/SpringKafkaHelper;", "", "ip", "", "port", "", "(Ljava/lang/String;I)V", "containerList", "", "Lorg/springframework/kafka/listener/KafkaMessageListenerContainer;", "getContainerList", "()Ljava/util/List;", "getIp", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "getPort", "()I", "consumerProps", "", "group", "createContainer", "containerProps", "Lorg/springframework/kafka/listener/ContainerProperties;", "createTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "kafkaListenerContainerFactory", "Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "senderProps", "startConsumerAsyn", "", "topic", "beanName", "concurrency", "consumer", "Ljava/util/function/Consumer;", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "config", "testAutoCommit", "kotlin-lib"})
public final class SpringKafkaHelper {
    @NotNull
    private final String ip;
    private final int port;
    private final Logger logger;
    @NotNull
    private final List<KafkaMessageListenerContainer<String, String>> containerList;

    public SpringKafkaHelper(@NotNull String ip, int port) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        this.ip = ip;
        this.port = port;
        this.logger = LoggerFactory.getLogger(SpringKafkaHelper.class);
        boolean bl = false;
        this.containerList = new ArrayList();
    }

    public /* synthetic */ SpringKafkaHelper(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 9092;
        }
        this(string, n);
    }

    @NotNull
    public final String getIp() {
        return this.ip;
    }

    public final int getPort() {
        return this.port;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final List<KafkaMessageListenerContainer<String, String>> getContainerList() {
        return this.containerList;
    }

    public final void startConsumerAsyn(@NotNull String topic, @NotNull String group, @NotNull String beanName, int concurrency, @NotNull Consumer<ConsumerRecord<String, String>> consumer, @Nullable Consumer<ContainerProperties> config) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object object = new String[]{topic};
        ContainerProperties containerProps = new ContainerProperties((String[])object);
        object = config;
        if (object != null) {
            object.accept(containerProps);
        }
        containerProps.setMessageListener((Object)new MessageListener<String, String>(consumer){
            final /* synthetic */ Consumer<ConsumerRecord<String, String>> $consumer;
            {
                this.$consumer = $consumer;
            }

            public void onMessage(@NotNull ConsumerRecord<String, String> message) {
                Intrinsics.checkNotNullParameter(message, (String)"message");
                this.$consumer.accept(message);
            }
        });
        int n = 1;
        if (n <= concurrency) {
            int i;
            do {
                i = n++;
                KafkaMessageListenerContainer<String, String> container = this.createContainer(containerProps, group);
                container.setBeanName(Intrinsics.stringPlus((String)beanName, (Object)i));
                this.containerList.add(container);
                container.start();
            } while (i != concurrency);
        }
    }

    public static /* synthetic */ void startConsumerAsyn$default(SpringKafkaHelper springKafkaHelper, String string, String string2, String string3, int n, Consumer consumer, Consumer consumer2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            consumer2 = null;
        }
        springKafkaHelper.startConsumerAsyn(string, string2, string3, n, consumer, consumer2);
    }

    public final void testAutoCommit() {
        KafkaTemplate<String, String> template = this.createTemplate();
        int n = 1;
        do {
            int i = n++;
            SpringKafkaHelperKt.sendAutoKey(template, "test1", String.valueOf(i));
            ThreadUtil.sleep((long)500L);
        } while (n <= 20);
    }

    @NotNull
    public final ConcurrentKafkaListenerContainerFactory<String, String> kafkaListenerContainerFactory(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(this.consumerProps(group)));
        return factory;
    }

    @NotNull
    public final KafkaMessageListenerContainer<String, String> createContainer(@NotNull ContainerProperties containerProps, @NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)containerProps, (String)"containerProps");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Map<String, Object> props = this.consumerProps(group);
        DefaultKafkaConsumerFactory cf = new DefaultKafkaConsumerFactory(props);
        KafkaMessageListenerContainer listenerContainer = new KafkaMessageListenerContainer((ConsumerFactory)cf, containerProps);
        return listenerContainer;
    }

    @NotNull
    public final KafkaTemplate<String, String> createTemplate() {
        Map<String, Object> senderProps = this.senderProps();
        DefaultKafkaProducerFactory pf = new DefaultKafkaProducerFactory(senderProps);
        return new KafkaTemplate((ProducerFactory)pf);
    }

    @NotNull
    public final Map<String, Object> consumerProps(@NotNull String group) {
        Map props;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Map map = props = (Map)new HashMap();
        String string = "bootstrap.servers";
        String string2 = this.ip + ':' + this.port;
        boolean bl = false;
        map.put(string, string2);
        map = props;
        string = "group.id";
        boolean bl2 = false;
        map.put(string, group);
        map = props;
        string = "enable.auto.commit";
        Class<StringDeserializer> clazz = true;
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "auto.commit.interval.ms";
        clazz = "100";
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "session.timeout.ms";
        clazz = "15000";
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "key.deserializer";
        clazz = StringDeserializer.class;
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "value.deserializer";
        clazz = StringDeserializer.class;
        bl = false;
        map.put(string, clazz);
        return props;
    }

    @NotNull
    public final Map<String, Object> senderProps() {
        Map props;
        Map map = props = (Map)new HashMap();
        String string = "bootstrap.servers";
        Class<StringSerializer> clazz = this.ip + ':' + this.port;
        boolean bl = false;
        map.put(string, clazz);
        map = props;
        string = "retries";
        clazz = 1;
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "batch.size";
        clazz = 16384;
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "linger.ms";
        clazz = 1;
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "buffer.memory";
        clazz = 0x2000000;
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "key.serializer";
        clazz = StringSerializer.class;
        bl = false;
        map.put(string, clazz);
        map = props;
        string = "value.serializer";
        clazz = StringSerializer.class;
        bl = false;
        map.put(string, clazz);
        return props;
    }
}

