package com.github.jchanghong.http

import cn.hutool.core.collection.ConcurrentHashSet
import cn.hutool.core.io.FileUtil
import cn.hutool.core.thread.ThreadUtil
import cn.hutool.core.util.CharsetUtil
import cn.hutool.crypto.SecureUtil
import cn.hutool.http.HttpUtil
import cn.hutool.json.JSONUtil
import cn.hutool.system.SystemUtil
import com.github.jchanghong.gson.jsonToObject
import com.github.jchanghong.gson.toJsonStr
import com.github.jchanghong.kotlin.isNotNUllOrBlank2
import com.google.common.net.HttpHeaders
import com.google.common.net.MediaType
import okhttp3.*
import okhttp3.HttpUrl.Companion.toHttpUrl
import okhttp3.MediaType.Companion.toMediaType
import okhttp3.RequestBody.Companion.asRequestBody
import okhttp3.RequestBody.Companion.toRequestBody
import java.io.File
import java.io.IOException
import java.security.SecureRandom
import java.security.cert.X509Certificate
import java.util.concurrent.*
import java.util.concurrent.atomic.AtomicBoolean
import javax.net.ssl.*

/** okhttp*/
object HttpHelper {
    var debug = false

    /** 单点登录url路径 ,比如/portal/cas/loginPage*/
    var pviaLoginUrlPath = "/portal/cas/loginPage"

    /** 运管登录路径，比如/center/login*/
    var pviaLoginUrlPathCenter = "/center/login"

    /** 比如https://1.1.1.2*/
    var pviaIpAndPort = "https://1.1.1.2"

    /** http://1.1.1.2:8001*/
    var pviaIpAndPortCenter = "http://1.1.1.2:8001"

    /** pvia 密码*/
    var pviaPassword = "123456"

    /** 运管密码*/
    var pviaCenterPassword = "123456"
    fun info(i: Any): Unit {
        if (debug) {
            println(i)
        }
    }

    private val client: OkHttpClient

    private val pviaisLogin = AtomicBoolean(false)
    private val pviaCenterisLogin = AtomicBoolean(false)

    private class TrustAllCerts : X509TrustManager {
        override fun checkClientTrusted(chain: Array<X509Certificate>, authType: String?) {
//            info(authType+chain.firstOrNull().toString())
        }

        override fun checkServerTrusted(chain: Array<X509Certificate>, authType: String?) {
//            info(authType+chain.firstOrNull().toString())
        }

        override fun getAcceptedIssuers(): Array<X509Certificate> {
            return arrayOf()
        }

    }

    private class TrustAllHostnameVerifier : HostnameVerifier {
        override fun verify(hostname: String?, session: SSLSession?): Boolean {
//            info(hostname + session.toString())
            return true
        }
    }

    private fun createSSLSocketFactory(): SSLSocketFactory {
        val sc: SSLContext = SSLContext.getInstance("TLS")
        sc.init(null, arrayOf<TrustManager>(TrustAllCerts()), SecureRandom())
        return sc.socketFactory
    }

    val cookieStore = ConcurrentHashMap<String, ConcurrentHashMap<String, Cookie>>()
    val cookieVoList = ConcurrentHashSet<SetCookieBO>()

    private var csrf_parameterName = ""
    private var csrf_headerName = ""
    private var csrf_token = ""
    private var cSRFRequestHeadXface = Pair<String, String>("", "")
    private var cSRFRequestHeadXcross = Pair<String, String>("", "")
    private var cSRFRequestHeadXbody = Pair<String, String>("", "")
    private var cSRFRequestHeadialarm = Pair<String, String>("", "")
    fun login(user: String, password: String): Boolean {
        val formBody = FormBody.Builder()
                .add("userName", "admin")
                .build()
        val response = client.newCall(
                Request.Builder().url("${pviaIpAndPort}/portal/login/ajax/postLoginData.do")
                        .post(formBody).build()
        ).execute()
        val message = response.bodyString()
        info(message)
        val parseObj1 = JSONUtil.parseObj(message)
        val parseObj = parseObj1.getJSONObject("data")
        val vcodestr = parseObj.getStr("vCode")
        val salt = parseObj.getStr("salt")
        val passtmp = SecureUtil.sha256(SecureUtil.sha256(password + salt) + vcodestr)
        val formBodyLogin = FormBody.Builder()
                .add("userName", user)
                .add("password", passtmp)
                .add("serviceUrl", """${pviaIpAndPort}/portal/cas/loginPage?service=${pviaIpAndPort}/portal""")
                .add("imageCode", "")
                .add("codeId", parseObj.getStr("codeId"))
                .add("userType", "0")
                .add("lang", "zh_CN")
                .build()
        val response1 = client.newCall(
                Request.Builder().url("${pviaIpAndPort}/portal/login/ajax/submit.do")
                        .post(formBodyLogin).build()
        ).execute()
        val loginMessage = response1.bodyString()
        info(loginMessage)
        val url2 = JSONUtil.parseObj(loginMessage).getStr("data") ?: ""
        return if ("http" in url2) {
            val response2 = client.newCall(Request.Builder().url(url2).build()).execute()
            response.close()
            response1.close()
            if (response2.code == 200) {
                println("登陆pvia成功 $response2")
                response2.close()
                true
            } else {
                response2.close()
                false
            }
        } else {
            println("登陆pvia失败")
            response.close()
            response1.close()
            false
        }

    }

    fun requestCSRFRequestHead(
            url: String,
            nameRegex: String = "_csrf_header",
            valueRegex: String = "_csrf"
    ): Pair<String, String> {
        val response = this.getAsyn(url).get()
        val execute4 = response.bodyString()
//        println(execute4)
//        <meta name="_csrf
//        _header" content="X-CSRF-TOKEN" />
//
//	<meta name="_csrf" content="6499598e-5027-44b3-a052-0f2f77dfe543" />
        val toRegex1 = """name="${valueRegex}"\s+content="(\S+)"""".toRegex()
        val toRegex2 = """name="${nameRegex}"\s+content="(\S+)"""".toRegex()
        val v = toRegex1.find(execute4)!!.groupValues[1]
        val k = toRegex2.find(execute4)!!.groupValues[1]
        info("add csrf header :$k  -> $v")
        response.close()
        return k to v
    }

    fun ialarmCSRFRequestHead(): Pair<String, String> {
        val response = client.newCall(Request.Builder()
                .url("${pviaIpAndPort}/ialarm-web/search.do")
                .build()).execute()
        val execute4 = response.bodyString()
//        info(execute4)
//    <!DOCTYPE html><html lang=en><head><meta charset=utf-8>
//    <meta name=_csrf content=5e387797-8928-4c7c-bc32-4dfb11b41d2f><meta name=_csrf_header content=X-CSRF-TOKEN><meta http-equiv=X-UA-Compatible content="IE=edge"><meta name=viewport content="width=device-width,initial-scale=1"><link rel=icon href=/ialarm-web/favicon.ico><title>缉查布控</title><link rel=stylesheet type=text/css href=/hgis-web/gisapi/theme/hgis.css><script src=/hgis-web/hgis.js></script><link href=/ialarm-web/css/chunk-039928f7.974de669.css rel=prefetch><link href=/ialarm-web/css/chunk-04acaf40.a5c5e3a5.css rel=prefetch><link href=/ialarm-web/css/chunk-058dd70a.c1494a51.css rel=prefetch><link href=/ialarm-web/css/chunk-05e3410a.2d40d7af.css rel=prefetch><link href=/ialarm-web/css/chunk-0709deea.687ae5eb.css rel=prefetch><link href=/ialarm-web/css/chunk-0a2641f5.dbfe8d85.css rel=prefetch><link href=/ialarm-web/css/chunk-173c2f22.dbe51d5e.css rel=prefetch><link href=/ialarm-web/css/chunk-1b907736.fa4d333d.css rel=prefetch><link href=/ialarm-web/css/chunk-1c415260.d1c45a52.css rel=prefetch><link href=/ialarm-web/css/chunk-20fa02b1.3a937d15.css rel=prefetch><link href=/ialarm-web/css/chunk-24c360f9.1955d0a3.css rel=prefetch><link href=/ialarm-web/css/chunk-24e4eb64.fa4d333d.css rel=prefetch><link href=/ialarm-web/css/chunk-2ddec39e.e059bddb.css rel=prefetch><link href=/ialarm-web/css/chunk-33e6e27e.61568f36.css rel=prefetch><link href=/ialarm-web/css/chunk-37111c28.ed9149cc.css rel=prefetch><link href=/ialarm-web/css/chunk-3deab755.20540872.css rel=prefetch><link href=/ialarm-web/css/chunk-411f4ae6.201051e7.css rel=prefetch><link href=/ialarm-web/css/chunk-4a500234.542eb0bb.css rel=prefetch><link href=/ialarm-web/css/chunk-4aafba56.452a1af6.css rel=prefetch><link href=/ialarm-web/css/chunk-4af3ef98.949f9ad2.css rel=prefetch><link href=/ialarm-web/css/chunk-4d9f4266.f81c5c6f.css rel=prefetch><link href=/ialarm-web/css/chunk-5856fb84.05a628b2.css rel=prefetch><link href=/ialarm-web/css/chunk-5f663dde.f235b0e8.css rel=prefetch><link href=/ialarm-web/css/chunk-6d73b9cb.1e7f0d26.css rel=prefetch><link href=/ialarm-web/css/chunk-6e43292c.3ae7f70f.css rel=prefetch><link href=/ialarm-web/css/chunk-771d4c1d.33cfa014.css rel=prefetch><link href=/ialarm-web/css/chunk-7cecfe64.ba75223e.css rel=prefetch><link href=/ialarm-web/css/chunk-7f5aee3b.4a57ab7d.css rel=prefetch><link href=/ialarm-web/css/chunk-825c9522.cede2e26.css rel=prefetch><link href=/ialarm-web/css/chunk-bb1c9d2c.d1c45a52.css rel=prefetch><link href=/ialarm-web/css/chunk-c985b706.70350df8.css rel=prefetch><link href=/ialarm-web/css/chunk-efffe4c8.ab594d7b.css rel=prefetch><link href=/ialarm-web/css/chunk-fe917eb2.c900de1f.css rel=prefetch><link href=/ialarm-web/js/chunk-039928f7.1b50ac61.js rel=prefetch><link href=/ialarm-web/js/chunk-04acaf40.1f0e94a5.js rel=prefetch><link href=/ialarm-web/js/chunk-058dd70a.a6637f72.js rel=prefetch><link href=/ialarm-web/js/chunk-05e3410a.1c50a6a7.js rel=prefetch><link href=/ialarm-web/js/chunk-0709deea.5a8d3998.js rel=prefetch><link href=/ialarm-web/js/chunk-0a2641f5.a918b592.js rel=prefetch><link href=/ialarm-web/js/chunk-173c2f22.83ee4e17.js rel=prefetch><link href=/ialarm-web/js/chunk-1b907736.8a58b542.js rel=prefetch><link href=/ialarm-web/js/chunk-1c415260.8959cc01.js rel=prefetch><link href=/ialarm-web/js/chunk-20fa02b1.131d9652.js rel=prefetch><link href=/ialarm-web/js/chunk-24c360f9.cf88b814.js rel=prefetch><link href=/ialarm-web/js/chunk-24e4eb64.c775eab5.js rel=prefetch><link href=/ialarm-web/js/chunk-2ddec39e.ff3c582b.js rel=prefetch><link href=/ialarm-web/js/chunk-33e6e27e.04ac41ff.js rel=prefetch><link href=/ialarm-web/js/chunk-37111c28.7ecc2530.js rel=prefetch><link href=/ialarm-web/js/chunk-3deab755.96b5f523.js rel=prefetch><link href=/ialarm-web/js/chunk-411f4ae6.a6877029.js rel=prefetch><link href=/ialarm-web/js/chunk-4a500234.724c0219.js rel=prefetch><link href=/ialarm-web/js/chunk-4aafba56.6472e2dc.js rel=prefetch><link href=/ialarm-web/js/chunk-4af3ef98.5700f2fc.js rel=prefetch><link href=/ialarm-web/js/chunk-4d9f4266.144e214d.js rel=prefetch><link href=/ialarm-web/js/chunk-5856fb84.14f22b8d.js rel=prefetch><link href=/ialarm-web/js/chunk-5f663dde.8c64a698.js rel=prefetch><link href=/ialarm-web/js/chunk-6d73b9cb.530c8f5f.js rel=prefetch><link href=/ialarm-web/js/chunk-6e43292c.a1e54c65.js rel=prefetch><link href=/ialarm-web/js/chunk-771d4c1d.c075ae96.js rel=prefetch><link href=/ialarm-web/js/chunk-7cecfe64.15c9a1fc.js rel=prefetch><link href=/ialarm-web/js/chunk-7f5aee3b.86c996d6.js rel=prefetch><link href=/ialarm-web/js/chunk-825c9522.7e6ccec4.js rel=prefetch><link href=/ialarm-web/js/chunk-bb1c9d2c.97f0e712.js rel=prefetch><link href=/ialarm-web/js/chunk-c985b706.ec039551.js rel=prefetch><link href=/ialarm-web/js/chunk-df3ee020.b57229b3.js rel=prefetch><link href=/ialarm-web/js/chunk-efffe4c8.172aa43c.js rel=prefetch><link href=/ialarm-web/js/chunk-fe917eb2.3b659c39.js rel=prefetch><link href=/ialarm-web/css/app.e9ce06b6.css rel=preload as=style><link href=/ialarm-web/css/chunk-vendors.155c066d.css rel=preload as=style><link href=/ialarm-web/js/app.1777874b.js rel=preload as=script><link href=/ialarm-web/js/chunk-vendors.c8c5dc27.js rel=preload as=script><meta name=_csrf content=5e387797-8928-4c7c-bc32-4dfb11b41d2f><meta name=_csrf_header content=X-CSRF-TOKEN><link href=/ialarm-web/css/chunk-vendors.155c066d.css rel=stylesheet><link href=/ialarm-web/css/app.e9ce06b6.css rel=stylesheet></head><body><noscript><strong>We're sorry but itim-frontend doesn't work properly without JavaScript enabled. Please enable it to continue.</strong></noscript><div id=app></div><script src=/ialarm-web/js/chunk-vendors.c8c5dc27.js
//    ></script><script src=/ialarm-web/js/app.1777874b.js></script></body></html>
        val toRegex1 = """name=_csrf\s+content=([^>]+)""".toRegex()
        val toRegex2 = """name=_csrf_header\s+content=([^>]+)""".toRegex()
        val v = toRegex1.find(execute4)!!.groupValues[1]
        val k = toRegex2.find(execute4)!!.groupValues[1]
        info("add ilarm csrf :$k  -> $v")
        response.close()
        return k to v
    }

    init {
        val cookieDirectory = File("okhttpCacheResponseTmp${System.getProperty(SystemUtil.FILE_SEPARATOR)}cookie.json")
        if (!cookieDirectory.exists()) {
            FileUtil.touch(cookieDirectory)
            println(cookieDirectory.absolutePath)
        } else {
            println(cookieDirectory.absolutePath)
            cookieVoList.addAll(cookieDirectory.readText().jsonToObject<HashSet<SetCookieBO>>() ?: emptySet())
            val map = cookieVoList.mapNotNull { Cookie.parse(it.url.toHttpUrl(), it.setCookie) }
                    .groupBy { it.domain }.mapValues { ConcurrentHashMap(it.value.associateBy { it.name }) }
            cookieStore.putAll(map)
            if (cookieVoList.isNotEmpty()) {
                val orNull = cookieVoList.firstOrNull { it.csrf_headerName.isNotBlank() }
                csrf_headerName = orNull?.csrf_headerName ?: ""
                csrf_token = orNull?.csrf_token ?: ""
                csrf_parameterName = orNull?.csrf_parameterName ?: ""
            }
            println("加载文件中cookie " + cookieVoList.toJsonStr())
        }
        val builder = OkHttpClient.Builder()
                .followRedirects(true)
                .followSslRedirects(true)
                .retryOnConnectionFailure(false)
                .addInterceptor { chain ->
                    val oldRequest = chain.request()
                    info("用户请求===========" + oldRequest)
                    if (cSRFRequestHeadXcross.first.isNotBlank() && oldRequest.needCarCsrf()) {
                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(cSRFRequestHeadXcross.first, cSRFRequestHeadXcross.second).build())
                        return@addInterceptor proceed
                    } else if (cSRFRequestHeadXface.first.isNotBlank() && oldRequest.needFaceCsrf()) {
                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(cSRFRequestHeadXface.first, cSRFRequestHeadXface.second).build())
                        return@addInterceptor proceed
                    } else if (cSRFRequestHeadXbody.first.isNotBlank() && oldRequest.needBodyCsrf()) {
                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(cSRFRequestHeadXbody.first, cSRFRequestHeadXbody.second).build())
                        return@addInterceptor proceed
                    } else if (cSRFRequestHeadialarm.first.isNotBlank() && oldRequest.needAlarmCsrf()) {
                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(cSRFRequestHeadialarm.first, cSRFRequestHeadialarm.second).build())
                        return@addInterceptor proceed
                    }
//
//                    if (cSRFRequestHeadXface.first.isBlank() && oldRequest.needFaceCsrf()) {
////                        xface自动增加csrf请求头
//                        val head = requestCSRFRequestHead("${pviaIpAndPort}/iface-web/index.do")
//                        cSRFRequestHeadXface=head
//                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(head.first, head.second).build())
//                       return@addInterceptor proceed
//                    } else if (cSRFRequestHeadXcross.first.isBlank() && oldRequest.needCarCsrf()) {
////                        xface自动增加csrf请求头
//                        val head = requestCSRFRequestHead("${pviaIpAndPort}/ivehicle-web/view/index.do")
//                        cSRFRequestHeadXcross=head
//                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(head.first, head.second).build())
//                       return@addInterceptor proceed
//                    } else if (cSRFRequestHeadXbody.first.isBlank() && oldRequest.needBodyCsrf()) {
////                        xface自动增加csrf请求头
//                        val head = requestCSRFRequestHead("https://${pviaIpAndPort}/ibody-web/web/statistic/jumpToStatisticPage.do")
//                        cSRFRequestHeadXbody=head
//                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(head.first, head.second).build())
//                       return@addInterceptor proceed
//                    } else if (cSRFRequestHeadialarm.first.isBlank() && oldRequest.needAlarmCsrf()) {
////                        xface自动增加csrf请求头
//                        val head = ialarmCSRFRequestHead()
//                        cSRFRequestHeadialarm=head
//                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(head.first, head.second).build())
//                       return@addInterceptor proceed
//                    }
//
                    val response = chain.proceed(oldRequest)
                    if (pviaLoginUrlPath in response.request.url.toString()) {
//                        跳到cas登录页面，需要登录
                        val body = response.bodyString()
                        val regex = """enableCsrf\s+\=\s+JSON.parse\('([^']+)'\)""".toRegex()
                        val get = regex.find(body)!!.groupValues!![1]
                        info(get)
//    {"token":"7Reae4fy-BTLJ_QoGKxkpykAyyus6E4aVA6U","parameterName":"_csrf","headerName":"X-CSRF-TOKEN"}
                        val jsonObject = JSONUtil.parseObj(get)
                        csrf_headerName = jsonObject.getStr("headerName")
                        csrf_parameterName = jsonObject.getStr("parameterName")
                        csrf_token = jsonObject.getStr("token")
                        login("admin", pviaPassword)
                        response.close()
                        chain.proceed(oldRequest)
                    } else if (pviaLoginUrlPathCenter in response.request.url.toString()) {
//                        跳到cas登录页面，需要登录
                        val body = response.bodyString()
                        val message = getAsyn("${pviaIpAndPortCenter}/center/api/session?userId=sysadmin").get().bodyString()
                        info("${pviaIpAndPortCenter}/center/api/session?userId=sysadmin " + message)
                        val jsonObject = JSONUtil.parseObj(message)
                        val password = SecureUtil.sha256(SecureUtil.sha256(pviaCenterPassword + jsonObject.getByPath("data.salt"))
                                + jsonObject.getByPath("data.challenge.code"))
                        val response1 = postJsonStringAsyn("${pviaIpAndPortCenter}/center/api/session", """
            {"user":{"id":"sysadmin"},"password":"${password}",
            "captcha":"","salt":"${jsonObject.getByPath("data.salt")}",
            "challenge":{"code":"${jsonObject.getByPath("data.challenge.code")}",
            "id":"${jsonObject.getByPath("data.challenge.id")}"}}
        """.trimIndent()).get()
                        val headers = response1.headers("refresh-url").firstOrNull() ?: ""
                        response1.close()
                        if (headers.isNotBlank()) {
                            val response2 = getAsyn(headers).get()
                            response2.close()
                            println("登录运管成功" + response2)
                        }
                        response.close()
                        chain.proceed(oldRequest)
                    } else if (response.code == 403 && oldRequest.needFaceCsrf()) {
//                        xface自动增加csrf请求头
                        val head = requestCSRFRequestHead("${pviaIpAndPort}/iface-web/index.do")
                        cSRFRequestHeadXface = head
                        response.bodyString()
                        response.close()
                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(head.first, head.second).build())
                        proceed
                    } else if (response.code == 403 && oldRequest.needCarCsrf()) {
//                        xface自动增加csrf请求头
                        val head = requestCSRFRequestHead("${pviaIpAndPort}/ivehicle-web/view/index.do")
                        cSRFRequestHeadXcross = head
                        response.bodyString()
                        response.close()
                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(head.first, head.second).build())
                        proceed
                    } else if (response.code == 403 && oldRequest.needBodyCsrf()) {
//                        xface自动增加csrf请求头
                        val head = requestCSRFRequestHead("${pviaIpAndPort}/ibody-web/web/statistic/jumpToStatisticPage.do")
                        cSRFRequestHeadXbody = head
                        response.bodyString()
                        response.close()
                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(head.first, head.second).build())
                        proceed
                    } else if (response.code == 403 && oldRequest.needAlarmCsrf()) {
//                        xface自动增加csrf请求头
                        val head = ialarmCSRFRequestHead()
                        cSRFRequestHeadialarm = head
                        response.bodyString()
                        response.close()
                        val proceed = chain.proceed(oldRequest.newBuilder().addHeader(head.first, head.second).build())
                        proceed
                    } else {
                        response
                    }
                }
                .addNetworkInterceptor { chain ->
                    val oldRequest = chain.request()
                    val names = oldRequest.headers.names()
                    val requestBuild = oldRequest.newBuilder()
                    if (csrf_headerName.isNotBlank() && csrf_token.isNotBlank() && csrf_headerName !in names) {
                        requestBuild.addHeader(csrf_headerName, csrf_token)
                    }
                    if (csrf_parameterName.isNotBlank() && csrf_token.isNotBlank() && csrf_parameterName !in names) {
                        requestBuild.addHeader(csrf_parameterName, csrf_token)
                    }
                    val request = requestBuild.build()
                    val response = chain.proceed(request)
                    if (response.header(HttpHeaders.SET_COOKIE, "").isNotNUllOrBlank2()) {
                        cookieVoList.add(SetCookieBO(request.url.toString(), response.header(HttpHeaders.SET_COOKIE, "").toString(), csrf_headerName, csrf_token, csrf_parameterName))
                    }
                    info("服务器返回：$response")
                    response
                }
                .cookieJar(object : CookieJar {
                    override fun saveFromResponse(url: HttpUrl, cookies: List<Cookie>) {
                        for (cookie in cookies) {
                            val hashMap = cookieStore.getOrPut(cookie.domain) { ConcurrentHashMap() }
                            hashMap[cookie.name] = cookie
                        }
//                        info("cookieJar saveFromResponse ${url.host}" + cookies.joinToString { it.name + it.value })
                        if (cookieDirectory.exists()) {
                            FileUtil.writeUtf8String(cookieVoList.toJsonStr(), cookieDirectory)
                        }
                    }

                    override fun loadForRequest(url: HttpUrl): List<Cookie> {
                        val hashMap = cookieStore.getOrPut(url.host) { ConcurrentHashMap() }
//                        info("cookieJar loadForRequest ${url.host}:${hashMap.values}")
                        return hashMap.values.toList()
                    }
                })
                .sslSocketFactory(createSSLSocketFactory(), TrustAllCerts())
                .hostnameVerifier(TrustAllHostnameVerifier())
                .dispatcher(Dispatcher(executorService = Executors.newFixedThreadPool(64, ThreadUtil.newNamedThreadFactory("OKHttpDispatcher", false))).apply {
                    this.maxRequests = 64
                    this.maxRequestsPerHost = 63
                })
                .connectTimeout(10, TimeUnit.SECONDS)
                .writeTimeout(0, TimeUnit.SECONDS)
                .readTimeout(0, TimeUnit.SECONDS)
                .callTimeout(0, TimeUnit.SECONDS)

        kotlin.runCatching {
            val cacheDirectory = File(".${System.getProperty(SystemUtil.FILE_SEPARATOR)}okhttpCacheResponseTmp")
            FileUtil.mkdir(cacheDirectory)
            builder.cache(Cache(
                    directory = cacheDirectory,
                    maxSize = 10L * 1024L * 1024L // 1 MiB
            ))
        }
        client = builder.build()
    }

    fun getAsyn(url: String, callback: Callback, headers: Map<String, String>? = null) {
        val request = Request.Builder()
                .url(url)
                .addHeaders(headers)
                .build()

        client.newCall(request).enqueue(callback)
    }

    fun getAsyn(url: String, headers: Map<String, String>? = null): CompletableFuture<Response> {
        val future = CompletableFuture<Response>()
        val request = Request.Builder()
                .url(url)
                .addHeaders(headers)
                .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                future.completeExceptionally(e)
            }

            override fun onResponse(call: Call, response: Response) {
                future.complete(response)
            }
        })
        return future
    }

    fun getAsynWithForm(url: String, form: Map<String, String>, headers: Map<String, String>? = null): CompletableFuture<Response> {
        val future = CompletableFuture<Response>()
        val request = Request.Builder()
                .url(HttpUtil.urlWithForm(url, form, CharsetUtil.CHARSET_UTF_8, true))
                .addHeaders(headers)
                .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                future.completeExceptionally(e)
            }

            override fun onResponse(call: Call, response: Response) {
                future.complete(response)
            }
        })
        return future
    }

//    fun getSyn(url: String, headers: Map<String, String>? = null): Response {
//        val request = Request.Builder()
//                .url(url)
//                .addHeaders(headers)
//                .build()
//        return client.newCall(request).execute()
//    }

    fun postFileAsyn(url: String, file: File, mediaType: MediaType? = null, headers: Map<String, String>? = null): CompletableFuture<Response> {
        val future = CompletableFuture<Response>()
        val request = Request.Builder()
                .url(url)
                .post(file.asRequestBody(mediaType?.toString()?.toMediaType()))
                .addHeaders(headers)
                .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                future.completeExceptionally(e)
            }

            override fun onResponse(call: Call, response: Response) {
                future.complete(response)
            }
        })
        return future
    }

    fun postFormAsyn(url: String, form: Map<String, String>, headers: Map<String, String>? = null): CompletableFuture<Response> {
        val future = CompletableFuture<Response>()
        val formbuilder = FormBody.Builder()
        for ((k, v) in form) {
            formbuilder.add(k, v)
        }
        val formBody = formbuilder.build()
        val request = Request.Builder()
                .url(url)
                .post(formBody)
                .addHeaders(headers)
                .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                future.completeExceptionally(e)
            }

            override fun onResponse(call: Call, response: Response) {
                future.complete(response)
            }
        })
        return future
    }

    fun postStringAsyn(url: String, postBody: String, mediaType: MediaType? = null, headers: Map<String, String>? = null): CompletableFuture<Response> {
        val future = CompletableFuture<Response>()

        val request = Request.Builder()
                .url(url)
                .post(postBody.toRequestBody((mediaType ?: MediaType.PLAIN_TEXT_UTF_8).toString().toMediaType()))
                .addHeaders(headers)
                .build()
        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                future.completeExceptionally(e)
            }

            override fun onResponse(call: Call, response: Response) {
                future.complete(response)
            }
        })
        return future
    }

    fun postJsonStringAsyn(url: String, jsonBody: String, headers: Map<String, String>? = null, form: Map<String, String>? = null): CompletableFuture<Response> {
        val future = CompletableFuture<Response>()
        val urls = if (form.isNullOrEmpty()) url else HttpUtil.urlWithForm(url, form, CharsetUtil.CHARSET_UTF_8, true)
        val request = Request.Builder()
                .url(urls)
                .post(jsonBody.toRequestBody(MediaType.JSON_UTF_8.toString().toMediaType()))
                .addHeaders(headers)
                .build()
        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                future.completeExceptionally(e)
            }

            override fun onResponse(call: Call, response: Response) {
                future.complete(response)
            }
        })
        return future
    }

    /** form 可以是string  和file类型*/
    fun postMultipartAsyn(url: String, form: Map<String, Any>, headers: Map<String, String>? = null): CompletableFuture<Response> {
//         val IMGUR_CLIENT_ID = "9199fdef135c122"
        val future = CompletableFuture<Response>()
        // Use the imgur image upload API as documented at https://api.imgur.com/endpoints/image
        val builder = MultipartBody.Builder()
                .setType(MultipartBody.FORM)
        for ((k, v) in form) {
            val file = v as? File
            if (file == null) {
                builder.addFormDataPart(k, v.toString())
            } else {
                builder.addFormDataPart(k, file.name, file.asRequestBody())
            }
        }
        val requestBody = builder
//                .addFormDataPart("title", "Square Logo")
//                .addFormDataPart("image", "logo-square.png",
//                        File("docs/images/logo-square.png").asRequestBody(PostMultipart.MEDIA_TYPE_PNG))
                .build()

        val request = Request.Builder()
//                .header("Authorization", "Client-ID ${PostMultipart.IMGUR_CLIENT_ID}")
                .url(url)
                .post(requestBody)
                .addHeaders(headers)
                .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                future.completeExceptionally(e)
            }

            override fun onResponse(call: Call, response: Response) {
                future.complete(response)
            }
        })
        return future
    }
}

fun Request.Builder.addHeaders(headers: Map<String, String>?): Request.Builder {
    headers ?: return this
    for ((k, v) in headers.entries) {
        this.addHeader(k, v)
    }
    return this
}

/** 调用close*/
fun Response.bodyString(): String {
    val s = this.body?.string() ?: ""
    this.close()
    return s
}

fun Request.needFaceCsrf(): Boolean {

    return ("/iface-web" in url.toString()) && ("iface-web/index.do" !in url.toString())
}

fun Request.needCarCsrf(): Boolean {
    return ("/ivehicle-web" in url.toString()) && ("/ivehicle-web/view/index.do" !in url.toString())
}

fun Request.needBodyCsrf(): Boolean {
    return ("/ibody-web" in url.toString()) && ("web/statistic/jumpToStatisticPage.do" !in url.toString())
}

fun Request.needAlarmCsrf(): Boolean {
    return ("/ialarm-we" in url.toString()) && ("ialarm-web/search.do" !in url.toString())
}

data class SetCookieBO(var url: String, var setCookie: String, var csrf_headerName: String, var csrf_token: String, var csrf_parameterName: String)

fun main() {
    println(HttpUtil.encodeParams(HttpUtil.urlWithForm("http://www.baidu.com/是", mapOf("ss" to "s飒飒 1"), CharsetUtil.CHARSET_UTF_8, true), CharsetUtil.CHARSET_UTF_8))

    println(HttpUtil.urlWithForm("http://www.baidu.com/是", mapOf("ss" to "s飒飒 1"), CharsetUtil.CHARSET_UTF_8, true))
}