package com.github.jchanghong.http

import cn.hutool.crypto.SecureUtil
import cn.hutool.json.JSONUtil
import com.github.jchanghong.log.kInfo
import okhttp3.*
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody.Companion.toRequestBody
import org.slf4j.LoggerFactory
import java.security.SecureRandom
import java.security.cert.X509Certificate
import java.util.*
import javax.net.ssl.*

object OkHttps {
    /** https://1.1.1.1:443*/
    var pviaURL: String = "https://1.1.1.1:443"
    val httpClient: OkHttpClient by lazy {
        kInfo("初始化Okhttp..............")
        val build = OkHttpClient.Builder()
                .followRedirects(true).followSslRedirects(true)
                .addInterceptor { chain ->
                    val request = chain.request()
                    logger.info(request.toString())
                    chain.proceed(request)
                }
                .cookieJar(object : CookieJar {
                    override fun saveFromResponse(url: HttpUrl, cookies: List<Cookie>) {
                        for (cookie in cookies) {
                            val hashMap = cookieStore.getOrPut(cookie.domain) { hashMapOf() }
                            hashMap[cookie.name] = cookie
                        }
                        logger.info("saveFromResponse ${url.host}" + cookies.joinToString { it.name + it.value })
                    }

                    override fun loadForRequest(url: HttpUrl): List<Cookie> {
                        val hashMap = cookieStore.getOrPut(url.host) { hashMapOf() }
                        logger.info("loadForRequest ${url.host}")
                        return hashMap.values.toList()
                    }
                })
                .sslSocketFactory(createSSLSocketFactory(), TrustAllCerts())
                .hostnameVerifier(TrustAllHostnameVerifier())
                .build()
        kInfo("初始化完成okhttp...........")
        build
    }
    private val logger = LoggerFactory.getLogger(OkHttps::class.java)

    private class TrustAllCerts : X509TrustManager {
        override fun checkClientTrusted(chain: Array<X509Certificate>, authType: String?) {
//            logger.info(authType+chain.firstOrNull().toString())
        }

        override fun checkServerTrusted(chain: Array<X509Certificate>, authType: String?) {
//            logger.info(authType+chain.firstOrNull().toString())
        }

        override fun getAcceptedIssuers(): Array<X509Certificate> {
            return arrayOf()
        }

    }

    private class TrustAllHostnameVerifier : HostnameVerifier {
        override fun verify(hostname: String?, session: SSLSession?): Boolean {
            logger.info(hostname + session.toString())
            return true
        }
    }

    private fun createSSLSocketFactory(): SSLSocketFactory {
        val sc: SSLContext = SSLContext.getInstance("TLS")
        sc.init(null, arrayOf<TrustManager>(TrustAllCerts()), SecureRandom())
        return sc.socketFactory
    }

    val cookieStore = HashMap<String, HashMap<String, Cookie>>()

    /** 保存最新请求的url。需要登陆的时候登陆后，重新请求*/
    var lasthttpRequest: Request? = null
}


val JSON_MEDIATYPE = "application/json;charset=utf-8".toMediaTypeOrNull()

fun main() {


}

@JvmOverloads
fun OkHttpClient.postJson(
        url: String,
        json: String,
        headers: Map<String, String>? = null,
        loginaction: (() -> Unit)? = null
): String {
    val toRequestBody = json.trimIndent().trim().toRequestBody(JSON_MEDIATYPE)
    val builder = Request.Builder()
    for ((k, v) in (headers ?: emptyMap())) {
        builder.header(k, v)
    }
    val execute7 = this.newCall(
            builder
                    .url(url)
                    .post(toRequestBody)
                    .build()
    ).executeFroUtf8()

    if (loginaction != null && execute7 == null) {
//        需要登陆
        loginaction.invoke()
        return this.newCall(
                builder
                        .url(url)
                        .post(toRequestBody)
                        .build()
        ).executeFroUtf8().toString()
    }
    return execute7.toString()
}
@JvmOverloads
fun OkHttpClient.putJson(
        url: String,
        json: String,
        headers: Map<String, String>? = null,
        loginaction: (() -> Unit)? = null
): String {
    val toRequestBody = json.trimIndent().trim().toRequestBody(JSON_MEDIATYPE)
    val builder = Request.Builder()
    for ((k, v) in (headers ?: emptyMap())) {
        builder.header(k, v)
    }
    val execute7 = this.newCall(
            builder
                    .url(url)
                    .put(toRequestBody)
                    .build()
    ).executeFroUtf8()

    if (loginaction != null && execute7 == null) {
//        需要登陆
        loginaction.invoke()
        return this.newCall(
                builder
                        .url(url)
                        .post(toRequestBody)
                        .build()
        ).executeFroUtf8().toString()
    }
    return execute7.toString()
}
@JvmOverloads
fun OkHttpClient.postFormAsyn(
        url: String,
        form: Map<String, String>? = null,
        headers: Map<String, String>? = null,
        loginaction: (() -> Unit)? = null
): String {
    val builder = Request.Builder()
    for ((k, v) in (headers ?: emptyMap())) {
        builder.header(k, v)
    }
    val body = FormBody.Builder()
    form?.forEach { k, v ->
        body.add(k, v)
    }
    val formBodyLogin = body.build()
    val toString = this.newCall(
            Request.Builder().url(url)
                    .post(formBodyLogin).build()
    ).executeFroUtf8()
    if (loginaction != null && toString == null) {
//        需要登陆
        loginaction.invoke()
        return this.newCall(
                Request.Builder().url(url)
                        .post(formBodyLogin).build()
        ).executeFroUtf8().toString()
    }
    return toString.toString()
}

@JvmOverloads
fun OkHttpClient.get(url: String, headers: Map<String, String>? = null, loginaction: (() -> Unit)? = null): String {
    val builder = Request.Builder()
    for ((k, v) in (headers ?: emptyMap())) {
        builder.header(k, v)
    }
    val execute7 = this.newCall(
            builder
                    .url(url)
                    .build()
    ).executeFroUtf8()
    if (loginaction != null && execute7 == null) {
//        需要登陆
        loginaction.invoke()
        return this.newCall(
                builder
                        .url(url)
                        .build()
        ).executeFroUtf8().toString()
    }
    return execute7.toString()
}

/** 返回null，就需要登陆*/
fun Call.executeFroUtf8(): String? {
    val execute = this.execute()
    if (execute.request.url.toString().contains("portal/cas/login")) return null
    if (execute.code == 403) return null
    val body = execute.body?.string().toString()
    return body
}