/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.elasticsearch;

import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.jchanghong.gson.JsonHelper;
import com.github.jchanghong.gson.JsonsKt;
import com.github.jchanghong.http.OkHttps;
import com.github.jchanghong.http.OkhttpsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.apache.http.HttpHost;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.GetSourceRequest;
import org.elasticsearch.client.core.GetSourceResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u000bJ\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u000bJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J$\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#J0\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010%0#J\u001e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010 \u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004J,\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020)0#J$\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00042\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007J\u000e\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u0006\u0010/\u001a\u00020\u0004J\u001e\u00100\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcom/github/jchanghong/elasticsearch/ElasticsearchHelper;", "", "ips", "", "", "(Ljava/util/List;)V", "client", "Lorg/elasticsearch/client/RestHighLevelClient;", "getClient", "()Lorg/elasticsearch/client/RestHighLevelClient;", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "serverUrl", "getServerUrl", "()Ljava/lang/String;", "setServerUrl", "(Ljava/lang/String;)V", "DESCRIBE", "table", "createIndex", "ik", "createIndexAsyoutype", "delete", "Lorg/elasticsearch/client/Cancellable;", "index", "id", "get", "consumer", "Ljava/util/function/Consumer;", "getSource", "", "", "data", "json", "Lorg/elasticsearch/action/index/IndexResponse;", "query", "field", "queryForJson", "sql", "queryForTxt", "showTables", "update", "kotlin-lib"})
public final class ElasticsearchHelper {
    @NotNull
    private String serverUrl;
    private final Logger logger;
    private boolean debug;
    @NotNull
    private final RestHighLevelClient client;

    /*
     * WARNING - void declaration
     */
    public ElasticsearchHelper(@NotNull List<String> ips) {
        Collection<HttpHost> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ips, (String)"ips");
        this.serverUrl = "http://" + (String)CollectionsKt.first(ips) + ":9200";
        this.logger = LoggerFactory.getLogger(ElasticsearchHelper.class);
        this.debug = true;
        HttpHost[] httpHostArray = (HttpHost[])ips;
        ElasticsearchHelper elasticsearchHelper = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            HttpHost httpHost = new HttpHost((String)it, 9200, "http");
            collection.add(httpHost);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        HttpHost[] httpHostArray2 = thisCollection$iv.toArray(new HttpHost[0]);
        if (httpHostArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        HttpHost[] httpHostArray3 = httpHostArray2;
        httpHostArray = new HttpHost[httpHostArray3.length];
        System.arraycopy(httpHostArray3, 0, httpHostArray, 0, httpHostArray3.length);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHostArray);
        elasticsearchHelper.client = new RestHighLevelClient(restClientBuilder);
    }

    @NotNull
    public final String getServerUrl() {
        return this.serverUrl;
    }

    public final void setServerUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serverUrl = string;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final RestHighLevelClient getClient() {
        return this.client;
    }

    @NotNull
    public final Cancellable index(@NotNull String index2, @NotNull String id, @NotNull String json, @NotNull Consumer<IndexResponse> consumer) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        IndexRequest indexRequest = new IndexRequest(index2);
        indexRequest.id(id);
        indexRequest.source(json, XContentType.JSON);
        Cancellable indexAsync2 = this.client.indexAsync(indexRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<IndexResponse>(this, consumer){
            final /* synthetic */ ElasticsearchHelper this$0;
            final /* synthetic */ Consumer<IndexResponse> $consumer;
            {
                this.this$0 = $receiver;
                this.$consumer = $consumer;
            }

            public void onResponse(@Nullable IndexResponse p0) {
                IndexResponse indexResponse;
                if (this.this$0.getDebug()) {
                    ElasticsearchHelper.access$getLogger$p(this.this$0).info(Intrinsics.stringPlus((String)((indexResponse = p0) == null ? null : indexResponse.getIndex()), (Object)" index ok"));
                }
                if ((indexResponse = p0) == null) {
                    return;
                }
                this.$consumer.accept(indexResponse);
            }

            public void onFailure(@Nullable Exception p0) {
                Exception exception;
                ElasticsearchHelper.access$getLogger$p(this.this$0).error((exception = p0) == null ? null : exception.getLocalizedMessage(), (Throwable)p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)indexAsync2, (String)"indexAsync");
        return indexAsync2;
    }

    @NotNull
    public final Cancellable get(@NotNull String index2, @NotNull String id, @NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        GetRequest indexRequest = new GetRequest(index2);
        indexRequest.id(id);
        Cancellable indexAsync2 = this.client.getAsync(indexRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<GetResponse>(this, consumer){
            final /* synthetic */ ElasticsearchHelper this$0;
            final /* synthetic */ Consumer<String> $consumer;
            {
                this.this$0 = $receiver;
                this.$consumer = $consumer;
            }

            public void onResponse(@NotNull GetResponse getResponse) {
                Intrinsics.checkNotNullParameter((Object)getResponse, (String)"getResponse");
                if (this.this$0.getDebug()) {
                    ElasticsearchHelper.access$getLogger$p(this.this$0).info(Intrinsics.stringPlus((String)getResponse.getSourceAsString(), (Object)" get ok"));
                }
                if (getResponse.isExists()) {
                    String string = getResponse.getSourceAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResponse.getSourceAsString()");
                    String sourceAsString = string;
                    this.$consumer.accept(sourceAsString);
                }
            }

            public void onFailure(@Nullable Exception p0) {
                Exception exception;
                ElasticsearchHelper.access$getLogger$p(this.this$0).error((exception = p0) == null ? null : exception.getLocalizedMessage(), (Throwable)p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)indexAsync2, (String)"indexAsync");
        return indexAsync2;
    }

    @NotNull
    public final Cancellable getSource(@NotNull String index2, @NotNull String id, @NotNull Consumer<Map<String, Object>> consumer) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        GetSourceRequest getSourceRequest = new GetSourceRequest(index2, id);
        Cancellable indexAsync2 = this.client.getSourceAsync(getSourceRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<GetSourceResponse>(this, consumer){
            final /* synthetic */ ElasticsearchHelper this$0;
            final /* synthetic */ Consumer<Map<String, Object>> $consumer;
            {
                this.this$0 = $receiver;
                this.$consumer = $consumer;
            }

            public void onResponse(@NotNull GetSourceResponse getResponse) {
                Intrinsics.checkNotNullParameter((Object)getResponse, (String)"getResponse");
                if (this.this$0.getDebug()) {
                    Logger logger = ElasticsearchHelper.access$getLogger$p(this.this$0);
                    StringBuilder stringBuilder = new StringBuilder();
                    Map map = getResponse.getSource();
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getResponse.source");
                    logger.info(stringBuilder.append(map).append("getsource ok").toString());
                }
                this.$consumer.accept(getResponse.getSource());
            }

            public void onFailure(@Nullable Exception p0) {
                Exception exception;
                ElasticsearchHelper.access$getLogger$p(this.this$0).error((exception = p0) == null ? null : exception.getLocalizedMessage(), (Throwable)p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)indexAsync2, (String)"indexAsync");
        return indexAsync2;
    }

    @NotNull
    public final Cancellable delete(@NotNull String index2, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DeleteRequest deleteRequest = new DeleteRequest(index2, id);
        Cancellable indexAsync2 = this.client.deleteAsync(deleteRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<DeleteResponse>(this){
            final /* synthetic */ ElasticsearchHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull DeleteResponse getResponse) {
                Intrinsics.checkNotNullParameter((Object)getResponse, (String)"getResponse");
                if (this.this$0.getDebug()) {
                    ElasticsearchHelper.access$getLogger$p(this.this$0).info(Intrinsics.stringPlus((String)getResponse.getId(), (Object)" delete ok"));
                }
            }

            public void onFailure(@Nullable Exception p0) {
                Exception exception;
                ElasticsearchHelper.access$getLogger$p(this.this$0).error((exception = p0) == null ? null : exception.getLocalizedMessage(), (Throwable)p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)indexAsync2, (String)"indexAsync");
        return indexAsync2;
    }

    @NotNull
    public final Cancellable update(@NotNull String index2, @NotNull String id, @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        UpdateRequest updateRequest = new UpdateRequest(index2, id);
        updateRequest.doc(json, XContentType.JSON);
        Cancellable indexAsync2 = this.client.updateAsync(updateRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<UpdateResponse>(this){
            final /* synthetic */ ElasticsearchHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull UpdateResponse getResponse) {
                Intrinsics.checkNotNullParameter((Object)getResponse, (String)"getResponse");
                if (this.this$0.getDebug()) {
                    ElasticsearchHelper.access$getLogger$p(this.this$0).info(Intrinsics.stringPlus((String)"update ok", (Object)getResponse.getId()));
                }
            }

            public void onFailure(@Nullable Exception p0) {
                Exception exception;
                ElasticsearchHelper.access$getLogger$p(this.this$0).error((exception = p0) == null ? null : exception.getLocalizedMessage(), (Throwable)p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)indexAsync2, (String)"indexAsync");
        return indexAsync2;
    }

    @NotNull
    public final String showTables() {
        String postJson = OkhttpsKt.postJson$default(OkHttps.INSTANCE.getHttpClient(), Intrinsics.stringPlus((String)this.serverUrl, (Object)"/_sql?format=txt&pretty"), "{\n  \"query\": \"show tables\"\n}", null, null, 12, null);
        return postJson;
    }

    @NotNull
    public final String DESCRIBE(@NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        String postJson = OkhttpsKt.postJson$default(OkHttps.INSTANCE.getHttpClient(), Intrinsics.stringPlus((String)this.serverUrl, (Object)"/_sql?format=txt&pretty"), StringsKt.trimIndent((String)("\n        {\n          \"query\": \"DESCRIBE " + table + "\"\n        }\n    ")), null, null, 12, null);
        return postJson;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String queryForJson(@NotNull String sql) {
        List list;
        boolean bl;
        Iterable $this$mapNotNull$iv;
        List list2;
        Map jsonToObject2;
        String string;
        String postJson;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        String $this$jsonToObject$iv = postJson = OkhttpsKt.postJson$default(OkHttps.INSTANCE.getHttpClient(), Intrinsics.stringPlus((String)this.serverUrl, (Object)"/_sql?format=json&pretty"), StringsKt.trimIndent((String)("\n        {\n          \"query\": \"" + sql + "\"\n        }\n    ")), null, null, 12, null);
        boolean $i$f$jsonToObject = false;
        Object object = $this$jsonToObject$iv;
        if (object == null) {
            string = null;
        } else {
            try {
                object = JsonHelper.INSTANCE.getObjectMapper().readValue($this$jsonToObject$iv, (TypeReference)new TypeReference<Map<String, ? extends List<? extends Object>>>(){});
            }
            catch (Exception e$iv) {
                JsonsKt.getLogger().error(e$iv.getLocalizedMessage());
                object = null;
            }
            string = object;
        }
        Map e$iv = jsonToObject2 = (Map)((Object)string);
        object = e$iv == null ? null : (List)e$iv.get("columns");
        Object object2 = $i$f$jsonToObject = object instanceof List ? object : null;
        if ($i$f$jsonToObject == null) {
            list2 = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            $this$mapNotNull$iv = (Iterable)$i$f$jsonToObject;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Map it = (Map)element$iv$iv;
                boolean bl3 = false;
                if ((String)it.get("name") == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                String it$iv$iv2 = string2;
                bl = false;
                destination$iv$iv.add(it$iv$iv2);
            }
            list2 = (List)destination$iv$iv;
        }
        List keys = list2;
        Object $i$f$mapNotNull = jsonToObject2;
        Iterable iterable = $this$mapNotNull$iv = $i$f$mapNotNull == null ? null : (List)$i$f$mapNotNull.get("rows");
        if ($this$mapNotNull$iv == null) {
            list = null;
        } else {
            Iterable it$iv$iv;
            Object it;
            boolean bl6;
            Object element$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv2 = $this$mapNotNull$iv;
            boolean $i$f$mapNotNull2 = false;
            Iterable $i$f$mapNotNullTo = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                List list3;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl6 = false;
                it = element$iv$iv;
                boolean bl7 = false;
                if ((it instanceof List ? (List)it : null) == null) continue;
                list3 = list3;
                boolean it$iv$iv2 = false;
                bl = false;
                it$iv$iv = list3;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $i$f$mapNotNull = (List)destination$iv$iv;
            $this$mapNotNull$iv2 = (Iterable)$i$f$mapNotNull;
            $i$f$mapNotNull2 = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv2;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo2 = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Map map;
                Map toMap;
                Map map2;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl6 = false;
                it = (List)element$iv$iv;
                boolean bl8 = false;
                List list4 = keys;
                if (list4 == null) {
                    map2 = null;
                } else {
                    void $this$mapIndexedTo$iv$iv;
                    Iterable $this$mapIndexed$iv = list4;
                    boolean $i$f$mapIndexed = false;
                    it$iv$iv = $this$mapIndexed$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void index2;
                        void s2;
                        int n = index$iv$iv++;
                        boolean bl9 = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string3 = (String)item$iv$iv;
                        int n2 = n;
                        Collection collection = destination$iv$iv2;
                        boolean bl10 = false;
                        Pair pair = TuplesKt.to((Object)s2, it.get((int)index2));
                        collection.add(pair);
                    }
                    List list5 = (List)destination$iv$iv2;
                    map2 = toMap = MapsKt.toMap((Iterable)list5);
                }
                if (toMap == null) continue;
                boolean bl11 = false;
                boolean bl12 = false;
                Map it$iv$iv3 = map;
                boolean bl13 = false;
                destination$iv$iv.add(it$iv$iv3);
            }
            list = (List)destination$iv$iv;
        }
        List list6 = list;
        String toString = String.valueOf(JsonsKt.toJsonStr(list6));
        String message = JSONUtil.formatJsonStr((String)toString);
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        return message;
    }

    @NotNull
    public final String queryForTxt(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        String postJson = OkhttpsKt.postJson$default(OkHttps.INSTANCE.getHttpClient(), Intrinsics.stringPlus((String)this.serverUrl, (Object)"/_sql?format=txt&pretty"), StringsKt.trimIndent((String)("\n        {\n          \"query\": \"" + sql + "\"\n        }\n    ")), null, null, 12, null);
        return postJson;
    }

    @NotNull
    public final String index(@NotNull String table, long id, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String postJson = OkhttpsKt.postJson$default(OkHttps.INSTANCE.getHttpClient(), this.serverUrl + '/' + table + "/_doc/" + id, data, null, null, 12, null);
        return postJson;
    }

    @NotNull
    public final String createIndex(@NotNull String table, boolean ik) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        String postJson = OkhttpsKt.putJson$default(OkHttps.INSTANCE.getHttpClient(), this.serverUrl + '/' + table, StringsKt.trimIndent((String)("\n            {\n              \"mappings\": {\n                 \"properties\": {\n                        \"content\": {\n                            \"type\": \"text\"\n                            " + (ik ? "\",analyzer\": \"ik_max_word\",\n                            \"search_analyzer\": \"ik_smart\"" : "") + "\n                        }\n                    }\n              }\n            }\n        ")), null, null, 12, null);
        return postJson;
    }

    public static /* synthetic */ String createIndex$default(ElasticsearchHelper elasticsearchHelper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return elasticsearchHelper.createIndex(string, bl);
    }

    @NotNull
    public final String createIndexAsyoutype(@NotNull String table, boolean ik) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        String postJson = OkhttpsKt.putJson$default(OkHttps.INSTANCE.getHttpClient(), this.serverUrl + '/' + table, "{\n  \"mappings\": {\n     \"properties\": {\n            \"content\": {\n                \"type\": \"search_as_you_type\"\n            }\n        }\n  }\n}", null, null, 12, null);
        return postJson;
    }

    public static /* synthetic */ String createIndexAsyoutype$default(ElasticsearchHelper elasticsearchHelper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return elasticsearchHelper.createIndexAsyoutype(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String query(@NotNull String field, @NotNull String query, @Nullable String table) {
        List list;
        List jsonToObject2;
        String string;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String body = StringsKt.trimIndent((String)("\n            {\n\n              \"query\": {\n\n                \"match\": { \"" + field + "\": \"" + query + "\" }\n\n              },\n\n              \"highlight\": {\n\n                \"fields\": {\n\n                  \"" + field + "\": {}\n\n                }\n\n              }\n\n            }\n        "));
        String s2 = table != null ? Intrinsics.stringPlus((String)table, (Object)"/") : "";
        String postJson = OkhttpsKt.postJson$default(OkHttps.INSTANCE.getHttpClient(), this.serverUrl + '/' + s2 + "_search?pretty", body, null, null, 12, null);
        String $this$jsonToObject$iv = JsonsKt.jsonByPath(postJson, "hits.hits");
        boolean $i$f$jsonToObject22 = false;
        Object object = $this$jsonToObject$iv;
        if (object == null) {
            string = null;
        } else {
            try {
                object = JsonHelper.INSTANCE.getObjectMapper().readValue($this$jsonToObject$iv, (TypeReference)new TypeReference<List<? extends Map<String, ? extends Object>>>(){});
            }
            catch (Exception e$iv) {
                JsonsKt.getLogger().error(e$iv.getLocalizedMessage());
                object = null;
            }
            string = object;
        }
        List $i$f$jsonToObject22 = jsonToObject2 = (List)((Object)string);
        if ($i$f$jsonToObject22 == null) {
            list = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $i$f$jsonToObject22;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Map map;
                Map any;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map it = (Map)element$iv$iv;
                boolean bl2 = false;
                Object v = it.get("_source");
                Map map2 = any = TypeIntrinsics.isMutableMap(v) ? (Map)v : null;
                if (any != null) {
                    Object object2 = it.get("highlight");
                    Map map3 = object2 instanceof Map ? (Map)object2 : null;
                    Object get2 = map3 == null ? null : map3.get(field);
                    map3 = any;
                    object2 = "highlight";
                    List list2 = get2 instanceof List ? (List)get2 : null;
                    list2 = list2 == null ? null : (String)list2.get(0);
                    boolean bl3 = false;
                    map3.put(object2, list2);
                }
                if (any == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                Map it$iv$iv = map;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List mapNotNull = list;
        String toString = String.valueOf(JsonsKt.toJsonStr(mapNotNull));
        object = JSONUtil.formatJsonStr((String)toString);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"formatJsonStr(toString)");
        return object;
    }

    public static /* synthetic */ String query$default(ElasticsearchHelper elasticsearchHelper, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return elasticsearchHelper.query(string, string2, string3);
    }

    @JvmOverloads
    @NotNull
    public final String query(@NotNull String field, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return ElasticsearchHelper.query$default(this, field, query, null, 4, null);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ElasticsearchHelper $this) {
        return $this.logger;
    }
}

