/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.gson;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import com.github.jchanghong.kotlin.DatesKt;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0003B\u0011\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bB\u001b\b\u0014\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\u001b\b\u0014\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0018"}, d2={"Lcom/github/jchanghong/gson/LocalDateDeserializer2;", "Lcom/fasterxml/jackson/datatype/jsr310/deser/JSR310DateTimeDeserializerBase;", "Ljava/time/LocalDate;", "()V", "dtf", "Ljava/time/format/DateTimeFormatter;", "(Ljava/time/format/DateTimeFormatter;)V", "base", "(Lcom/github/jchanghong/gson/LocalDateDeserializer2;Ljava/time/format/DateTimeFormatter;)V", "leniency", "", "(Lcom/github/jchanghong/gson/LocalDateDeserializer2;Ljava/lang/Boolean;)V", "shape", "Lcom/fasterxml/jackson/annotation/JsonFormat$Shape;", "(Lcom/github/jchanghong/gson/LocalDateDeserializer2;Lcom/fasterxml/jackson/annotation/JsonFormat$Shape;)V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "withDateFormat", "withLeniency", "withShape", "Companion", "kotlin-lib"})
public final class LocalDateDeserializer2
extends JSR310DateTimeDeserializerBase<LocalDate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    @NotNull
    private static final LocalDateDeserializer2 INSTANCE = new LocalDateDeserializer2();

    protected LocalDateDeserializer2() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateDeserializer2(@Nullable DateTimeFormatter dtf) {
        super(LocalDate.class, dtf);
    }

    public LocalDateDeserializer2(@Nullable LocalDateDeserializer2 base, @Nullable DateTimeFormatter dtf) {
        super((JSR310DateTimeDeserializerBase)base, dtf);
    }

    protected LocalDateDeserializer2(@Nullable LocalDateDeserializer2 base, @Nullable Boolean leniency) {
        super((JSR310DateTimeDeserializerBase)base, leniency);
    }

    protected LocalDateDeserializer2(@Nullable LocalDateDeserializer2 base, @Nullable JsonFormat.Shape shape) {
        super((JSR310DateTimeDeserializerBase)base, shape);
    }

    @NotNull
    protected LocalDateDeserializer2 withDateFormat(@NotNull DateTimeFormatter dtf) {
        Intrinsics.checkNotNullParameter((Object)dtf, (String)"dtf");
        return new LocalDateDeserializer2(this, dtf);
    }

    @NotNull
    protected LocalDateDeserializer2 withLeniency(boolean leniency) {
        return new LocalDateDeserializer2(this, leniency);
    }

    @NotNull
    protected LocalDateDeserializer2 withShape(@NotNull JsonFormat.Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return new LocalDateDeserializer2(this, shape);
    }

    @Nullable
    public LocalDate deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) throws IOException {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            LocalDateTime localDateTime = DatesKt.toLocalDateTime(new Date(parser.getLongValue()));
            return localDateTime == null ? null : localDateTime.toLocalDate();
        }
        String toString = parser.getValueAsString();
        LocalDate toLocalDateTime = DatesKt.toLocalDateOrNull(toString);
        if (toLocalDateTime != null) {
            return toLocalDateTime;
        }
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            LocalDate $i$f$trim2;
            String string;
            String string2 = parser.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text");
            Object $this$trim$iv = string2;
            boolean $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim3 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if ((string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                Object object3;
                if (!this.isLenient()) {
                    $this$trim$iv = (LocalDate)this._failForNotLenient(parser, context, JsonToken.VALUE_STRING);
                    Intrinsics.checkNotNull((Object)$this$trim$iv);
                    object3 = $this$trim$iv;
                } else {
                    object3 = null;
                }
                return object3;
            }
            DateTimeFormatter format = this._formatter;
            try {
                if (Intrinsics.areEqual((Object)format, (Object)DEFAULT_FORMATTER) && string.length() > 10 && string.charAt(10) == 'T') {
                    return StringsKt.endsWith$default((String)string, (String)"Z", (boolean)false, (int)2, null) ? LocalDateTime.ofInstant(Instant.parse(string), ZoneOffset.UTC).toLocalDate() : LocalDate.parse(string, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                }
                $i$f$trim2 = LocalDate.parse(string, format);
            }
            catch (DateTimeException e) {
                $i$f$trim2 = (LocalDate)this._handleDateTimeException(context, e, string);
            }
            return $i$f$trim2;
        }
        if (parser.isExpectedStartArrayToken()) {
            JsonToken t = parser.nextToken();
            if (t == JsonToken.END_ARRAY) {
                return null;
            }
            if (context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS) && (t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT)) {
                LocalDate parsed = this.deserialize(parser, context);
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser, context);
                }
                return parsed;
            }
            if (t == JsonToken.VALUE_NUMBER_INT) {
                int year = parser.getIntValue();
                int month = parser.nextIntValue(-1);
                int day = parser.nextIntValue(-1);
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    JsonMappingException jsonMappingException = context.wrongTokenException(parser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonMappingException, (String)"context.wrongTokenException(\n                            parser, handledType(), JsonToken.END_ARRAY,\n                            \"Expected array to end\"\n                    )");
                    throw (Throwable)jsonMappingException;
                }
                return LocalDate.of(year, month, day);
            }
            Object[] objectArray = new Object[]{t};
            context.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", objectArray);
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            object2 = parser.getEmbeddedObject();
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.time.LocalDate");
            }
            return (LocalDate)object2;
        }
        if (parser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT || this.isLenient()) {
                object = LocalDate.ofEpochDay(parser.getLongValue());
            } else {
                object2 = (LocalDate)this._failForNotLenient(parser, context, JsonToken.VALUE_STRING);
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
            }
        } else {
            object = (LocalDate)this._handleUnexpectedToken(context, parser, "Expected array or string.", new Object[0]);
        }
        return object;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/jchanghong/gson/LocalDateDeserializer2$Companion;", "", "()V", "DEFAULT_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "INSTANCE", "Lcom/github/jchanghong/gson/LocalDateDeserializer2;", "getINSTANCE", "()Lcom/github/jchanghong/gson/LocalDateDeserializer2;", "serialVersionUID", "", "kotlin-lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalDateDeserializer2 getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

