/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.kafka;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.RandomUtil;
import com.github.jchanghong.kafka.OffsetReset;
import com.github.jchanghong.log.KStaticLogKt;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012&\b\u0002\u0010\u0007\u001a \u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ$\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\u00032\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204H\u0007J\u000e\u00105\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0003J\u001c\u00106\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u00107\u001a\u0004\u0018\u0001082\u0006\u00100\u001a\u00020\u0003J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00030:J\"\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u0003J\u0006\u0010?\u001a\u00020\nR/\u0010\u0007\u001a \u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R'\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001b\u0010\u001cR'\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0015\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0015\u001a\u0004\b%\u0010&R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\n ,*\u0004\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006@"}, d2={"Lcom/github/jchanghong/kafka/KafkaHelper;", "", "bootstrap", "", "groupId", "topics", "", "action", "Ljava/util/function/Function;", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "", "offsetReset", "Lcom/github/jchanghong/kafka/OffsetReset;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/function/Function;Lcom/github/jchanghong/kafka/OffsetReset;)V", "getAction", "()Ljava/util/function/Function;", "adminClient", "Lorg/apache/kafka/clients/admin/AdminClient;", "getAdminClient", "()Lorg/apache/kafka/clients/admin/AdminClient;", "adminClient$delegate", "Lkotlin/Lazy;", "getBootstrap", "()Ljava/lang/String;", "getGroupId", "mConsumer", "Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "getMConsumer", "()Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "mConsumer$delegate", "mProducer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "getMProducer", "()Lorg/apache/kafka/clients/producer/KafkaProducer;", "mProducer$delegate", "mProps", "Ljava/util/Properties;", "getMProps", "()Ljava/util/Properties;", "mProps$delegate", "getOffsetReset", "()Lcom/github/jchanghong/kafka/OffsetReset;", "singleThreadExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getTopics", "()Ljava/util/List;", "createTopic", "name", "p", "", "r", "", "deleteTopic", "getAndSetProps", "getTopic", "Lorg/apache/kafka/clients/admin/TopicDescription;", "listAllTopic", "", "produce", "topic", "value", "key", "startConsumer", "kotlin-lib"})
public final class KafkaHelper {
    @NotNull
    private final String bootstrap;
    @NotNull
    private final String groupId;
    @Nullable
    private final List<String> topics;
    @Nullable
    private final Function<ConsumerRecord<String, String>, Unit> action;
    @NotNull
    private final OffsetReset offsetReset;
    private final ExecutorService singleThreadExecutor;
    @NotNull
    private final Lazy mProps$delegate;
    @NotNull
    private final Lazy mProducer$delegate;
    @NotNull
    private final Lazy mConsumer$delegate;
    @NotNull
    private final Lazy adminClient$delegate;

    public KafkaHelper(@NotNull String bootstrap, @NotNull String groupId, @Nullable List<String> topics, @Nullable Function<ConsumerRecord<String, String>, Unit> action, @NotNull OffsetReset offsetReset) {
        Intrinsics.checkNotNullParameter((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)((Object)offsetReset), (String)"offsetReset");
        this.bootstrap = bootstrap;
        this.groupId = groupId;
        this.topics = topics;
        this.action = action;
        this.offsetReset = offsetReset;
        this.singleThreadExecutor = Executors.newSingleThreadExecutor();
        this.mProps$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Properties>(this){
            final /* synthetic */ KafkaHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Properties invoke() {
                return KafkaHelper.access$getAndSetProps(this.this$0, this.this$0.getBootstrap(), this.this$0.getGroupId());
            }
        }));
        this.mProducer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KafkaProducer<String, String>>(this){
            final /* synthetic */ KafkaHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KafkaProducer<String, String> invoke() {
                return new KafkaProducer(KafkaHelper.access$getMProps(this.this$0));
            }
        }));
        this.mConsumer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KafkaConsumer<String, String>>(this){
            final /* synthetic */ KafkaHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KafkaConsumer<String, String> invoke() {
                return new KafkaConsumer(KafkaHelper.access$getMProps(this.this$0));
            }
        }));
        this.adminClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AdminClient>(this){
            final /* synthetic */ KafkaHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AdminClient invoke() {
                return KafkaAdminClient.create((Properties)KafkaHelper.access$getMProps(this.this$0));
            }
        }));
    }

    public /* synthetic */ KafkaHelper(String string, String string2, List list, Function function, OffsetReset offsetReset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            function = null;
        }
        if ((n & 0x10) != 0) {
            offsetReset = OffsetReset.latest;
        }
        this(string, string2, list, function, offsetReset);
    }

    @NotNull
    public final String getBootstrap() {
        return this.bootstrap;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public final List<String> getTopics() {
        return this.topics;
    }

    @Nullable
    public final Function<ConsumerRecord<String, String>, Unit> getAction() {
        return this.action;
    }

    @NotNull
    public final OffsetReset getOffsetReset() {
        return this.offsetReset;
    }

    private final Properties getMProps() {
        Lazy lazy = this.mProps$delegate;
        boolean bl = false;
        return (Properties)lazy.getValue();
    }

    private final KafkaProducer<String, String> getMProducer() {
        Lazy lazy = this.mProducer$delegate;
        boolean bl = false;
        return (KafkaProducer)lazy.getValue();
    }

    private final KafkaConsumer<String, String> getMConsumer() {
        Lazy lazy = this.mConsumer$delegate;
        boolean bl = false;
        return (KafkaConsumer)lazy.getValue();
    }

    private final AdminClient getAdminClient() {
        Lazy lazy = this.adminClient$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"com.github.jchanghong.kafka\n\nimport cn.hutool.core.date.DateUtil\nimport cn.hutool.core.thread.ThreadUtil\nimport cn.hutool.core.util.ClassUtil\nimport cn.hutool.core.util.RandomUtil\nimport com.github.jchanghong.kotlin.toStrOrNow\nimport com.github.jchanghong.log.kError\nimport com.github.jchanghong.log.kInfo\nimport org.apache.kafka.clients.admin.*\nimport org.apache.kafka.clients.consumer.ConsumerRecord\nimport org.apache.kafka.clients.consumer.ConsumerRecords\nimport org.apache.kafka.clients.consumer.KafkaConsumer\nimport org.apache.kafka.clients.producer.KafkaProducer\nimport org.apache.kafka.clients.producer.ProducerRecord\nimport org.apache.kafka.common.KafkaFuture\nimport java.time.Duration\nimport java.util.*\nimport java.util.concurrent.ExecutionException\nimport java.util.concurrent.Executors\nimport java.util.function.Function\nenum class OffsetReset{\n    earliest,\n    latest\n}\n/** \u4e00\u4e2a\u5bf9\u8c61\u4e00\u5957kafka\u914d\u7f6e\uff0c\u591a\u4e2akafka\uff0c\u9700\u8981\u5efa\u7acb\u591a\u4e2a\u5bf9\u8c61,earliest,latest*/\nclass KafkaHelper(\n        val bootstrap: String,\n        val groupId: String,\n        val topics: List<String>? = null,\n        val action: Function<ConsumerRecord<String?, String?>, Unit>? = null,\n        val offsetReset: OffsetReset = OffsetReset.latest\n) {\n    private val singleThreadExecutor = Executors.newSingleThreadExecutor()\n    private val mProps: Properties by lazy { getAndSetProps(bootstrap, groupId) }\n    private val mProducer: KafkaProducer<String, String> by lazy { KafkaProducer<String, String>(mProps) }\n    private val mConsumer: KafkaConsumer<String, String> by lazy { KafkaConsumer<String, String>(mProps) }\n    private val adminClient: AdminClient by lazy { KafkaAdminClient.create(mProps) }");
        return (AdminClient)object;
    }

    private final Properties getAndSetProps(String bootstrap, String groupId) {
        Properties props = new Properties();
        Object object = props;
        String string = "bootstrap.servers";
        boolean bl = false;
        object.put(string, bootstrap);
        props.put("batch.size", (Object)16384);
        props.put("acks", "1");
        object = groupId;
        boolean bl2 = false;
        bl = false;
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            props.setProperty("group.id", groupId);
        }
        props.setProperty("enable.auto.commit", "true");
        props.setProperty("auto.offset.reset", this.offsetReset.name());
        props.setProperty("auto.commit.interval.ms", "1000");
        props.setProperty("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.setProperty("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        object = props;
        String string2 = "key.serializer";
        String string3 = "org.apache.kafka.common.serialization.StringSerializer";
        boolean bl3 = false;
        object.put(string2, string3);
        object = props;
        string2 = "value.serializer";
        string3 = "org.apache.kafka.common.serialization.StringSerializer";
        bl3 = false;
        object.put(string2, string3);
        return props;
    }

    static /* synthetic */ Properties getAndSetProps$default(KafkaHelper kafkaHelper2, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return kafkaHelper2.getAndSetProps(string, string2);
    }

    @JvmOverloads
    public final void createTopic(@NotNull String name, int p, short r) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NewTopic newTopic = new NewTopic(name, p, r);
        Collection newTopicList = new ArrayList();
        newTopicList.add(newTopic);
        CreateTopicsResult createTopicsResult = this.getAdminClient().createTopics(newTopicList);
        Map map = createTopicsResult.values();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createTopicsResult.values()");
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            try {
                ((KafkaFuture)entry.getValue()).get();
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                KStaticLogKt.kError(e.getMessage(), e, new Object[0]);
            }
            KStaticLogKt.kInfo(Intrinsics.stringPlus((String)"createTopic ", entry.getKey()), new Object[0]);
        }
    }

    public static /* synthetic */ void createTopic$default(KafkaHelper kafkaHelper2, String string, int n, short s2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8;
        }
        if ((n2 & 4) != 0) {
            s2 = 1;
        }
        kafkaHelper2.createTopic(string, n, s2);
    }

    public final void deleteTopic(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = new String[]{name};
        DeleteTopicsResult deleteTopicsResult = this.getAdminClient().deleteTopics((Collection)Arrays.asList(object));
        Object object2 = deleteTopicsResult.values();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"deleteTopicsResult.values()");
        boolean bl = false;
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            Object object3 = object2 = (Map.Entry)object.next();
            boolean bl2 = false;
            String k = (String)object3.getKey();
            Object object4 = object2;
            boolean bl3 = false;
            KafkaFuture v = (KafkaFuture)object4.getValue();
            try {
                v.get();
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                KStaticLogKt.kError(e.getMessage(), e, new Object[0]);
            }
            KStaticLogKt.kInfo(Intrinsics.stringPlus((String)"deleteTopic ", (Object)k), new Object[0]);
        }
    }

    @NotNull
    public final Set<String> listAllTopic() {
        ListTopicsResult listTopicsResult = this.getAdminClient().listTopics();
        Intrinsics.checkNotNullExpressionValue((Object)listTopicsResult, (String)"adminClient.listTopics()");
        ListTopicsResult result = listTopicsResult;
        KafkaFuture names = result.names();
        try {
            Object object = names.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"names.get()");
            return (Set)object;
        }
        catch (InterruptedException e) {
            KStaticLogKt.kError(e.getMessage(), e, new Object[0]);
        }
        catch (ExecutionException e) {
            KStaticLogKt.kError(e.getMessage(), e, new Object[0]);
        }
        return SetsKt.emptySet();
    }

    @Nullable
    public final TopicDescription getTopic(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = new String[]{name};
        DescribeTopicsResult describeTopicsResult = this.getAdminClient().describeTopics((Collection)Arrays.asList(object));
        Intrinsics.checkNotNullExpressionValue((Object)describeTopicsResult, (String)"adminClient.describeTopics(Arrays.asList(name))");
        DescribeTopicsResult describeTopics = describeTopicsResult;
        Collection values = describeTopics.values().values();
        if (values.isEmpty()) {
            KStaticLogKt.kInfo("\u627e\u4e0d\u5230\u63cf\u8ff0\u4fe1\u606f", new Object[0]);
        } else {
            object = values.iterator();
            if (object.hasNext()) {
                KafkaFuture value = (KafkaFuture)object.next();
                return (TopicDescription)value.get();
            }
        }
        return null;
    }

    public final void produce(@NotNull String topic, @NotNull String value, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = key;
        this.getMProducer().send(new ProducerRecord(topic, (Object)(string == null ? System.nanoTime() + RandomUtil.randomString((int)20) : string), (Object)value));
    }

    public static /* synthetic */ void produce$default(KafkaHelper kafkaHelper2, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        kafkaHelper2.produce(string, string2, string3);
    }

    public final void startConsumer() {
        Object object = this.topics;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        object = this.action;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (object == null) {
            boolean bl5 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Class[] classArray = new Class[]{List.class};
        Method method = ClassUtil.getDeclaredMethod(KafkaConsumer.class, (String)"subscribe", (Class[])classArray);
        Object[] objectArray = new Class[]{Duration.class};
        Method pollMethod = ClassUtil.getDeclaredMethod(KafkaConsumer.class, (String)"poll", (Class[])objectArray);
        if (method != null) {
            objectArray = new Object[]{this.topics};
            method.invoke(this.getMConsumer(), objectArray);
            this.singleThreadExecutor.execute(new Runnable(pollMethod, this){
                final /* synthetic */ Method $pollMethod;
                final /* synthetic */ KafkaHelper this$0;
                {
                    this.$pollMethod = $pollMethod;
                    this.this$0 = $receiver;
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void run() {
                    block0: while (true) {
                        if ((var3_3 /* !! */  = (poll = this.$pollMethod != null ? KafkaHelper.access$getMConsumer(this.this$0).poll(Duration.ofMillis(100L)) : KafkaHelper.access$getMConsumer(this.this$0).poll(0L))) == null) {
                            continue;
                        }
                        records = var3_3 /* !! */ ;
                        var3_3 /* !! */  = (Iterable)records;
                        var4_4 = this.this$0;
                        $i$f$forEach = false;
                        var6_6 = $this$forEach$iv.iterator();
                        while (true) {
                            if (var6_6.hasNext()) ** break;
                            continue block0;
                            element$iv = var6_6.next();
                            it = (ConsumerRecord)element$iv;
                            $i$a$-forEach-KafkaHelper$startConsumer$1$1 = false;
                            var4_4.getAction().apply((ConsumerRecord<String, String>)it);
                        }
                        break;
                    }
                }
            });
        }
    }

    @JvmOverloads
    public final void createTopic(@NotNull String name, int p) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        KafkaHelper.createTopic$default(this, name, p, (short)0, 4, null);
    }

    @JvmOverloads
    public final void createTopic(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        KafkaHelper.createTopic$default(this, name, 0, (short)0, 6, null);
    }

    public static final /* synthetic */ KafkaConsumer access$getMConsumer(KafkaHelper $this) {
        return $this.getMConsumer();
    }

    public static final /* synthetic */ Properties access$getAndSetProps(KafkaHelper $this, String bootstrap, String groupId) {
        return $this.getAndSetProps(bootstrap, groupId);
    }

    public static final /* synthetic */ Properties access$getMProps(KafkaHelper $this) {
        return $this.getMProps();
    }
}

