/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.cef;

import com.github.jcustenborder.cef.CEFParser;
import com.github.jcustenborder.cef.Message;
import com.github.jcustenborder.cef.MessageFactory;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CEFParserImpl
implements CEFParser {
    static final TimeZone TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final Logger log = LoggerFactory.getLogger(CEFParserImpl.class);
    private static final Pattern PATTERN_CEF_PREFIX = Pattern.compile("^((?<timestamp>.+)\\s+(?<host>\\S+)\\s+)(?<cs0>CEF:\\d+)|^(?<cs1>CEF:\\d+)");
    private static final Pattern PATTERN_CEF_MAIN = Pattern.compile("(?<!\\\\)\\|");
    private static final Pattern PATTERN_EXTENSION = Pattern.compile("(\\w+)=");
    private static final List<String> DATE_FORMATS = Arrays.asList("MMM dd yyyy HH:mm:ss.SSS zzz", "MMM dd yyyy HH:mm:ss.SSS", "MMM dd yyyy HH:mm:ss zzz", "MMM dd yyyy HH:mm:ss", "MMM dd HH:mm:ss.SSS zzz", "MMM dd HH:mm:ss.SSS", "MMM dd HH:mm:ss zzz", "MMM dd HH:mm:ss");
    final MessageFactory messageFactory;

    public CEFParserImpl(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public Message parse(String event) throws IOException {
        int cefstartIndex;
        log.trace("parse('{}')", (Object)event);
        Matcher prefixMatcher = PATTERN_CEF_PREFIX.matcher(event);
        Preconditions.checkState((boolean)prefixMatcher.find(), (String)"event must match regex. %s", (Object[])new Object[]{PATTERN_CEF_PREFIX.pattern()});
        String timestampText = prefixMatcher.group("timestamp");
        String host = prefixMatcher.group("host");
        log.trace("parse() - timestampText = '{}' host='{}'", (Object)timestampText, (Object)host);
        Message.Builder builder = this.messageFactory.newBuilder();
        if (!Strings.isNullOrEmpty((String)timestampText) && !Strings.isNullOrEmpty((String)host)) {
            Long longTimestamp = Longs.tryParse((String)timestampText);
            Date timestamp = null;
            if (null != longTimestamp) {
                log.trace("parse() - Detected timestamp is stored as a long.");
                timestamp = new Date(longTimestamp);
            } else {
                log.trace("parse() - Trying to parse the timestamp.");
                for (String string : DATE_FORMATS) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(string);
                    dateFormat.setTimeZone(TIME_ZONE);
                    try {
                        boolean alterYear;
                        log.trace("parse() - Trying to parse '{}' with format '{}'", (Object)timestampText, (Object)string);
                        timestamp = dateFormat.parse(timestampText);
                        boolean bl = alterYear = !string.contains("yyyy");
                        if (!alterYear) break;
                        log.trace("parse() - date format '{}' does not specify the year. Might need to alter the year.", (Object)string);
                        Calendar calendar = Calendar.getInstance(TIME_ZONE);
                        int thisYear = calendar.get(1);
                        calendar.setTime(timestamp);
                        int year = calendar.get(1);
                        if (1970 != year) break;
                        log.trace("parse() - altering year from {} to {}", (Object)year, (Object)thisYear);
                        calendar.set(1, thisYear);
                        timestamp = calendar.getTime();
                        break;
                    }
                    catch (ParseException e) {
                        log.trace("parse() - Could not parse '{}' with '{}'.", (Object)timestampText, (Object)string);
                    }
                }
                Preconditions.checkState((null != timestamp ? 1 : 0) != 0, (String)"Could not parse timestamp. '{}'", (Object[])new Object[]{timestampText});
            }
            log.trace("parse() - timestamp = {}, {}", (Object)timestamp.getTime(), (Object)timestamp);
            builder.timestamp(timestamp);
            builder.host(host);
            cefstartIndex = prefixMatcher.start("cs0");
        } else {
            cefstartIndex = prefixMatcher.start("cs1");
        }
        log.trace("parse() - cefstartIndex = {}", (Object)cefstartIndex);
        String eventBody = event.substring(cefstartIndex);
        List parts = Splitter.on((Pattern)PATTERN_CEF_MAIN).splitToList((CharSequence)eventBody);
        if (log.isTraceEnabled()) {
            int i = 0;
            for (String part : parts) {
                log.trace("parse() - parts[{}] = '{}'", (Object)i, (Object)part);
                ++i;
            }
        }
        int index = 0;
        for (String token : parts) {
            token = token.replace("\\|", "|");
            log.trace("parse() - index={}, token='{}'", (Object)index, (Object)token);
            switch (index) {
                case 0: {
                    assert (token.startsWith("CEF:"));
                    builder.cefVersion(Integer.parseInt(token.substring(4)));
                    break;
                }
                case 1: {
                    builder.deviceVendor(token);
                    break;
                }
                case 2: {
                    builder.deviceProduct(token);
                    break;
                }
                case 3: {
                    builder.deviceVersion(token);
                    break;
                }
                case 4: {
                    builder.deviceEventClassId(token);
                    break;
                }
                case 5: {
                    builder.name(token);
                    break;
                }
                case 6: {
                    builder.severity(token);
                    break;
                }
            }
            ++index;
        }
        if (parts.size() == 7) {
            return builder.build();
        }
        List list = parts.subList(7, parts.size());
        String extension = Joiner.on((char)'|').join(list).replace("\\n", "\n").replace("\\=", "=");
        log.trace("parse() - extension = '{}'", (Object)extension);
        LinkedHashMap<String, String> extensions = new LinkedHashMap<String, String>(100);
        Matcher matcher = PATTERN_EXTENSION.matcher(extension);
        String key = null;
        String value = null;
        int lastEnd = -1;
        int lastStart = -1;
        while (matcher.find()) {
            log.trace("parse() - matcher.start() = {}, matcher.end() = {}", (Object)matcher.start(), (Object)matcher.end());
            if (lastEnd > -1) {
                value = extension.substring(lastEnd, matcher.start()).trim();
                extensions.put(key, value);
                log.trace("parse() - key='{}' value='{}'", (Object)key, (Object)value);
            }
            key = matcher.group(1);
            lastStart = matcher.start();
            lastEnd = matcher.end();
        }
        if (lastStart > -1 && !extensions.containsKey(key)) {
            value = extension.substring(lastEnd).trim();
            extensions.put(key, value);
            log.trace("parse() - key='{}' value='{}'", (Object)key, (Object)value);
        }
        builder.extensions(extensions);
        return builder.build();
    }
}

