/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.cef;

import java.util.HashMap;
import java.util.Map;

public enum Severity {
    Unknown,
    Low,
    Medium,
    High,
    VeryHigh;

    private static final Map<String, Severity> LOOKUP;

    public static Severity parse(String text) {
        return LOOKUP.getOrDefault(text, Unknown);
    }

    static {
        HashMap<String, Severity> lookup = new HashMap<String, Severity>();
        lookup.put("0", Low);
        lookup.put("1", Low);
        lookup.put("2", Low);
        lookup.put("3", Low);
        lookup.put("4", Medium);
        lookup.put("5", Medium);
        lookup.put("6", Medium);
        lookup.put("7", High);
        lookup.put("8", High);
        lookup.put("9", VeryHigh);
        lookup.put("10", VeryHigh);
        lookup.put("Low", Low);
        lookup.put("Medium", Medium);
        lookup.put("High", High);
        lookup.put("VeryHigh", VeryHigh);
        LOOKUP = lookup;
    }
}

