/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.docker.junit5;

import com.github.jcustenborder.docker.junit5.CleanupMode;
import com.github.jcustenborder.docker.junit5.Compose;
import com.github.jcustenborder.docker.junit5.DockerCluster;
import com.github.jcustenborder.docker.junit5.DockerContainer;
import com.github.jcustenborder.docker.junit5.FormatString;
import com.github.jcustenborder.docker.junit5.Host;
import com.github.jcustenborder.docker.junit5.Port;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.palantir.docker.compose.configuration.DockerComposeFiles;
import com.palantir.docker.compose.configuration.ShutdownStrategy;
import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.Container;
import com.palantir.docker.compose.connection.ContainerCache;
import com.palantir.docker.compose.connection.DockerMachine;
import com.palantir.docker.compose.connection.DockerPort;
import com.palantir.docker.compose.connection.ImmutableCluster;
import com.palantir.docker.compose.connection.waiting.ClusterHealthCheck;
import com.palantir.docker.compose.connection.waiting.ClusterWait;
import com.palantir.docker.compose.execution.DefaultDockerCompose;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.DockerComposeExecutable;
import com.palantir.docker.compose.execution.DockerConfiguration;
import com.palantir.docker.compose.execution.DockerExecutable;
import com.palantir.docker.compose.execution.RetryingDockerCompose;
import com.palantir.docker.compose.logging.FileLogCollector;
import com.palantir.docker.compose.logging.LogCollector;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback,
ParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(DockerExtension.class);
    static final List<Class<? extends Annotation>> ANNOTATIONS = Arrays.asList(FormatString.class, DockerContainer.class, Port.class, Host.class, DockerCluster.class);

    private static Compose findDockerComposeAnnotation(ExtensionContext extensionContext) {
        Class testClass = (Class)extensionContext.getTestClass().get();
        log.trace("Looking for Compose extension on {}", (Object)testClass.getName());
        Compose compose = testClass.getAnnotation(Compose.class);
        Preconditions.checkNotNull((Object)compose, (String)"Compose annotation not found on %s", (Object)testClass.getName());
        Preconditions.checkState((!Strings.isNullOrEmpty((String)compose.dockerComposePath()) ? 1 : 0) != 0, (Object)"compose.dockerComposePath() cannot be null or empty.");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)compose.logRootPath()) ? 1 : 0) != 0, (Object)"compose.logRootPath() cannot be null or empty.");
        return compose;
    }

    private static ExtensionContext.Namespace namespace(ExtensionContext extensionContext) {
        Class testClass = (Class)extensionContext.getTestClass().get();
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{testClass.getName(), "docker", "compose"});
        log.trace("Created namespace {}", (Object)namespace);
        return namespace;
    }

    static <T> T getOrBuild(Class<T> cls, ExtensionContext.Store store, Compose compose, Supplier<T> supplier) {
        String key = cls.getSimpleName();
        Object result = store.get((Object)key, cls);
        if (null == result) {
            result = supplier.get();
            store.put((Object)key, result);
        }
        return (T)result;
    }

    private DockerMachine dockerMachine(ExtensionContext.Store store, Compose compose) {
        return DockerExtension.getOrBuild(DockerMachine.class, store, compose, () -> DockerMachine.localMachine().build());
    }

    private DockerComposeExecutable dockerComposeExecutable(ExtensionContext.Store store, Compose compose) {
        return DockerExtension.getOrBuild(DockerComposeExecutable.class, store, compose, () -> {
            DockerMachine dockerMachine = this.dockerMachine(store, compose);
            return DockerComposeExecutable.builder().dockerConfiguration((DockerConfiguration)dockerMachine).dockerComposeFiles(DockerComposeFiles.from((String[])new String[]{compose.dockerComposePath()})).build();
        });
    }

    private DockerCompose dockerCompose(ExtensionContext.Store store, Compose compose) {
        return DockerExtension.getOrBuild(DockerCompose.class, store, compose, () -> {
            DockerMachine dockerMachine = this.dockerMachine(store, compose);
            DockerComposeExecutable dockerComposeExecutable = this.dockerComposeExecutable(store, compose);
            DefaultDockerCompose dockerCompose = new DefaultDockerCompose(dockerComposeExecutable, dockerMachine);
            return new RetryingDockerCompose(compose.retryAttempts(), (DockerCompose)dockerCompose);
        });
    }

    private LogCollector logCollector(ExtensionContext extensionContext, Class<?> testClass, ExtensionContext.Store store, Compose compose) {
        return DockerExtension.getOrBuild(LogCollector.class, store, compose, () -> {
            File logPathRoot = new File(compose.logRootPath());
            File testClassLogPath = new File(logPathRoot, testClass.getName());
            File testOutputPath = CleanupMode.AfterEach == compose.cleanupMode() ? new File(testClassLogPath, extensionContext.getDisplayName()) : testClassLogPath;
            return FileLogCollector.fromPath((String)testOutputPath.getAbsolutePath());
        });
    }

    private Cluster cluster(ExtensionContext.Store store, Compose compose) {
        return DockerExtension.getOrBuild(Cluster.class, store, compose, () -> {
            DockerMachine machine = this.dockerMachine(store, compose);
            Docker docker = this.docker(store, compose);
            DockerCompose dockerCompose = this.dockerCompose(store, compose);
            return ImmutableCluster.builder().ip(machine.getIp()).containerCache(new ContainerCache(docker, dockerCompose)).build();
        });
    }

    private DockerExecutable dockerExecutable(ExtensionContext.Store store, Compose compose) {
        return DockerExtension.getOrBuild(DockerExecutable.class, store, compose, () -> {
            DockerMachine machine = this.dockerMachine(store, compose);
            return DockerExecutable.builder().dockerConfiguration((DockerConfiguration)machine).build();
        });
    }

    private Docker docker(ExtensionContext.Store store, Compose compose) {
        return DockerExtension.getOrBuild(Docker.class, store, compose, () -> {
            DockerExecutable dockerExecutable = this.dockerExecutable(store, compose);
            return new Docker(dockerExecutable);
        });
    }

    ClusterWait healthCheck(Compose compose) throws IllegalAccessException, InstantiationException {
        ClusterHealthCheck result;
        try {
            result = compose.clusterHealthCheck().newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Could not create instance of health check '%s'", compose.clusterHealthCheck().getName()), ex);
        }
        return new ClusterWait(result, (ReadableDuration)Duration.standardSeconds((long)compose.clusterHealthCheckTimeout()));
    }

    void before(ExtensionContext extensionContext, Class<?> testClass, Compose compose) throws Exception {
        ExtensionContext.Namespace namespace = DockerExtension.namespace(extensionContext);
        ExtensionContext.Store store = extensionContext.getStore(namespace);
        DockerCompose dockerCompose = this.dockerCompose(store, compose);
        LogCollector logCollector = this.logCollector(extensionContext, testClass, store, compose);
        dockerCompose.build();
        dockerCompose.up();
        logCollector.collectLogs(dockerCompose);
        Cluster cluster = this.cluster(store, compose);
        log.debug("Waiting for services");
        ArrayList<ClusterWait> clusterWaits = new ArrayList<ClusterWait>();
        clusterWaits.add(new ClusterWait(ClusterHealthCheck.nativeHealthChecks(), (ReadableDuration)Duration.standardSeconds((long)compose.clusterHealthCheckTimeout())));
        clusterWaits.add(this.healthCheck(compose));
        clusterWaits.forEach(clusterWait -> clusterWait.waitUntilReady(cluster));
        log.debug("docker-compose cluster started");
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        Class testClass = (Class)extensionContext.getTestClass().get();
        Compose compose = DockerExtension.findDockerComposeAnnotation(extensionContext);
        if (CleanupMode.AfterAll == compose.cleanupMode()) {
            this.before(extensionContext, testClass, compose);
        }
    }

    void after(ExtensionContext extensionContext, Class<?> testClass, Compose compose) throws Exception {
        ExtensionContext.Namespace namespace = DockerExtension.namespace(extensionContext);
        ExtensionContext.Store store = extensionContext.getStore(namespace);
        DockerCompose dockerCompose = this.dockerCompose(store, compose);
        Docker docker = this.docker(store, compose);
        LogCollector collector = this.logCollector(extensionContext, testClass, store, compose);
        try {
            ShutdownStrategy.KILL_DOWN.shutdown(dockerCompose, docker);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Error cleaning up docker compose cluster", e);
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        Class testClass = (Class)extensionContext.getTestClass().get();
        Compose compose = DockerExtension.findDockerComposeAnnotation(extensionContext);
        if (CleanupMode.AfterAll == compose.cleanupMode()) {
            this.after(extensionContext, testClass, compose);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Class testClass = (Class)extensionContext.getTestClass().get();
        Compose compose = DockerExtension.findDockerComposeAnnotation(extensionContext);
        if (CleanupMode.AfterEach == compose.cleanupMode()) {
            this.before(extensionContext, testClass, compose);
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        Class testClass = (Class)extensionContext.getTestClass().get();
        Compose compose = DockerExtension.findDockerComposeAnnotation(extensionContext);
        if (CleanupMode.AfterEach == compose.cleanupMode()) {
            this.after(extensionContext, testClass, compose);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        for (Class<? extends Annotation> a : ANNOTATIONS) {
            if (!parameterContext.isAnnotated(a)) continue;
            return true;
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ExtensionContext.Namespace namespace = DockerExtension.namespace(extensionContext);
        ExtensionContext.Store store = extensionContext.getStore(namespace);
        Compose compose = DockerExtension.findDockerComposeAnnotation(extensionContext);
        Class<?> parameterType = parameterContext.getParameter().getType();
        DockerMachine dockerMachine = this.dockerMachine(store, compose);
        Cluster cluster = this.cluster(store, compose);
        Host host = parameterContext.getParameter().getAnnotation(Host.class);
        if (null != host) {
            return this.dockerHost(parameterType, dockerMachine, host);
        }
        Port port = parameterContext.getParameter().getAnnotation(Port.class);
        if (null != port) {
            return this.dockerPort(parameterType, cluster, port);
        }
        DockerContainer container = parameterContext.getParameter().getAnnotation(DockerContainer.class);
        if (null != container) {
            return this.dockerContainer(parameterType, cluster, container);
        }
        FormatString formatString = parameterContext.getParameter().getAnnotation(FormatString.class);
        if (null != formatString) {
            return this.dockerFormatString(parameterType, cluster, formatString);
        }
        DockerCluster dockerCluster = parameterContext.getParameter().getAnnotation(DockerCluster.class);
        if (null != dockerCluster) {
            return this.dockerCluster(parameterType, cluster);
        }
        return null;
    }

    private Object dockerCluster(Class<?> parameterType, Cluster cluster) {
        return cluster;
    }

    private Object dockerHost(Class<?> parameterType, DockerMachine dockerMachine, Host host) {
        if (String.class == parameterType) {
            return dockerMachine.getIp();
        }
        if (InetAddress.class.isAssignableFrom(parameterType)) {
            try {
                return InetAddress.getByName(dockerMachine.getIp());
            }
            catch (UnknownHostException e) {
                throw new ParameterResolutionException("Could not resolve ip", (Throwable)e);
            }
        }
        return null;
    }

    private Object dockerPort(Class<?> parameterContext, Cluster cluster, Port port) {
        Container container = cluster.container(port.container());
        Preconditions.checkNotNull((Object)container, (String)"Could not find container '%s'", (Object)port.container());
        DockerPort dockerPort = container.port(port.internalPort());
        Preconditions.checkNotNull((Object)container, (String)"Could not find internalPort '%s' for container '%s'", (int)port.internalPort(), (Object)port.container());
        if (InetSocketAddress.class.isAssignableFrom(parameterContext)) {
            try {
                InetAddress address = InetAddress.getByName(cluster.ip());
                return new InetSocketAddress(address, dockerPort.getExternalPort());
            }
            catch (UnknownHostException e) {
                throw new ParameterResolutionException("Could not resolve ip", (Throwable)e);
            }
        }
        if (Integer.class.equals(parameterContext)) {
            return dockerPort.getExternalPort();
        }
        if (Integer.TYPE.equals(parameterContext)) {
            return dockerPort.getExternalPort();
        }
        return null;
    }

    private Object dockerContainer(Class<?> parameterContext, Cluster cluster, DockerContainer dockerContainer) {
        Container container = cluster.container(dockerContainer.container());
        Preconditions.checkNotNull((Object)container, (String)"Could not find container '%s'", (Object)dockerContainer.container());
        return container;
    }

    private Object dockerFormatString(Class<?> parameterContext, Cluster cluster, FormatString formatString) {
        Container container = cluster.container(formatString.container());
        Preconditions.checkNotNull((Object)container, (String)"Could not find container '%s'", (Object)formatString.container());
        DockerPort port = container.port(formatString.internalPort());
        Preconditions.checkNotNull((Object)container, (String)"Could not find internalPort '%s' for container '%s'", (int)formatString.internalPort(), (Object)formatString.container());
        String format = port.inFormat(formatString.format());
        if (String.class.equals(parameterContext)) {
            return format;
        }
        if (URI.class.equals(parameterContext)) {
            return URI.create(format);
        }
        if (URL.class.equals(parameterContext)) {
            try {
                return new URL(format);
            }
            catch (MalformedURLException e) {
                throw new ParameterResolutionException("Could not create URL", (Throwable)e);
            }
        }
        return null;
    }
}

