package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.Configuration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfiguration.builder()}.
 */
@Generated(from = "Plugin.Configuration", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConfiguration
    implements Plugin.Configuration {
  private final ImmutableList<Plugin.Group> groups;
  private final ImmutableList<Plugin.Item> requiredConfigs;

  private ImmutableConfiguration(
      ImmutableList<Plugin.Group> groups,
      ImmutableList<Plugin.Item> requiredConfigs) {
    this.groups = groups;
    this.requiredConfigs = requiredConfigs;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @Override
  public ImmutableList<Plugin.Group> getGroups() {
    return groups;
  }

  /**
   * @return The value of the {@code requiredConfigs} attribute
   */
  @Override
  public ImmutableList<Plugin.Item> getRequiredConfigs() {
    return requiredConfigs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.Configuration#getGroups() groups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfiguration withGroups(Plugin.Group... elements) {
    ImmutableList<Plugin.Group> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfiguration(newValue, this.requiredConfigs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.Configuration#getGroups() groups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groups elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfiguration withGroups(Iterable<? extends Plugin.Group> elements) {
    if (this.groups == elements) return this;
    ImmutableList<Plugin.Group> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfiguration(newValue, this.requiredConfigs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.Configuration#getRequiredConfigs() requiredConfigs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfiguration withRequiredConfigs(Plugin.Item... elements) {
    ImmutableList<Plugin.Item> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfiguration(this.groups, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.Configuration#getRequiredConfigs() requiredConfigs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of requiredConfigs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfiguration withRequiredConfigs(Iterable<? extends Plugin.Item> elements) {
    if (this.requiredConfigs == elements) return this;
    ImmutableList<Plugin.Item> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfiguration(this.groups, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfiguration
        && equalTo((ImmutableConfiguration) another);
  }

  private boolean equalTo(ImmutableConfiguration another) {
    return groups.equals(another.groups)
        && requiredConfigs.equals(another.requiredConfigs);
  }

  /**
   * Computes a hash code from attributes: {@code groups}, {@code requiredConfigs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + groups.hashCode();
    h += (h << 5) + requiredConfigs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Configuration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Configuration")
        .omitNullValues()
        .add("groups", groups)
        .add("requiredConfigs", requiredConfigs)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.Configuration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Configuration instance
   */
  public static ImmutableConfiguration copyOf(Plugin.Configuration instance) {
    if (instance instanceof ImmutableConfiguration) {
      return (ImmutableConfiguration) instance;
    }
    return ImmutableConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfiguration ImmutableConfiguration}.
   * <pre>
   * ImmutableConfiguration.builder()
   *    .addGroups|addAllGroups(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.Group) // {@link Plugin.Configuration#getGroups() groups} elements
   *    .addRequiredConfigs|addAllRequiredConfigs(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.Item) // {@link Plugin.Configuration#getRequiredConfigs() requiredConfigs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableConfiguration builder
   */
  public static ImmutableConfiguration.Builder builder() {
    return new ImmutableConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConfiguration ImmutableConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.Configuration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Plugin.Group> groups = ImmutableList.builder();
    private ImmutableList.Builder<Plugin.Item> requiredConfigs = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Configuration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.Configuration instance) {
      Objects.requireNonNull(instance, "instance");
      addAllGroups(instance.getGroups());
      addAllRequiredConfigs(instance.getRequiredConfigs());
      return this;
    }

    /**
     * Adds one element to {@link Plugin.Configuration#getGroups() groups} list.
     * @param element A groups element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGroups(Plugin.Group element) {
      this.groups.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin.Configuration#getGroups() groups} list.
     * @param elements An array of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGroups(Plugin.Group... elements) {
      this.groups.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin.Configuration#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder groups(Iterable<? extends Plugin.Group> elements) {
      this.groups = ImmutableList.builder();
      return addAllGroups(elements);
    }

    /**
     * Adds elements to {@link Plugin.Configuration#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGroups(Iterable<? extends Plugin.Group> elements) {
      this.groups.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Plugin.Configuration#getRequiredConfigs() requiredConfigs} list.
     * @param element A requiredConfigs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequiredConfigs(Plugin.Item element) {
      this.requiredConfigs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin.Configuration#getRequiredConfigs() requiredConfigs} list.
     * @param elements An array of requiredConfigs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequiredConfigs(Plugin.Item... elements) {
      this.requiredConfigs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin.Configuration#getRequiredConfigs() requiredConfigs} list.
     * @param elements An iterable of requiredConfigs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder requiredConfigs(Iterable<? extends Plugin.Item> elements) {
      this.requiredConfigs = ImmutableList.builder();
      return addAllRequiredConfigs(elements);
    }

    /**
     * Adds elements to {@link Plugin.Configuration#getRequiredConfigs() requiredConfigs} list.
     * @param elements An iterable of requiredConfigs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRequiredConfigs(Iterable<? extends Plugin.Item> elements) {
      this.requiredConfigs.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfiguration ImmutableConfiguration}.
     * @return An immutable instance of Configuration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfiguration build() {
      return new ImmutableConfiguration(groups.build(), requiredConfigs.build());
    }
  }
}
