package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.Converter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConverter.builder()}.
 */
@Generated(from = "Plugin.Converter", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConverter
    implements Plugin.Converter {
  private final @Nullable String warning;
  private final @Nullable String tip;
  private final @Nullable String important;
  private final @Nullable String danger;
  private final @Nullable String note;
  private final @Nullable String title;
  private final @Nullable String description;
  private final @Nullable String icon;
  private final @Nullable String introduction;
  private final Class cls;

  private ImmutableConverter(
      @Nullable String warning,
      @Nullable String tip,
      @Nullable String important,
      @Nullable String danger,
      @Nullable String note,
      @Nullable String title,
      @Nullable String description,
      @Nullable String icon,
      @Nullable String introduction,
      Class cls) {
    this.warning = warning;
    this.tip = tip;
    this.important = important;
    this.danger = danger;
    this.note = note;
    this.title = title;
    this.description = description;
    this.icon = icon;
    this.introduction = introduction;
    this.cls = cls;
  }

  /**
   * @return The value of the {@code warning} attribute
   */
  @Override
  public @Nullable String getWarning() {
    return warning;
  }

  /**
   * @return The value of the {@code tip} attribute
   */
  @Override
  public @Nullable String getTip() {
    return tip;
  }

  /**
   * @return The value of the {@code important} attribute
   */
  @Override
  public @Nullable String getImportant() {
    return important;
  }

  /**
   * @return The value of the {@code danger} attribute
   */
  @Override
  public @Nullable String getDanger() {
    return danger;
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @Override
  public @Nullable String getNote() {
    return note;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public @Nullable String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public @Nullable String getIcon() {
    return icon;
  }

  /**
   * @return The value of the {@code introduction} attribute
   */
  @Override
  public @Nullable String getIntroduction() {
    return introduction;
  }

  /**
   * @return The value of the {@code cls} attribute
   */
  @Override
  public Class getCls() {
    return cls;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getWarning() warning} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for warning (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withWarning(@Nullable String value) {
    if (Objects.equals(this.warning, value)) return this;
    return new ImmutableConverter(
        value,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getTip() tip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withTip(@Nullable String value) {
    if (Objects.equals(this.tip, value)) return this;
    return new ImmutableConverter(
        this.warning,
        value,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getImportant() important} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for important (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withImportant(@Nullable String value) {
    if (Objects.equals(this.important, value)) return this;
    return new ImmutableConverter(
        this.warning,
        this.tip,
        value,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getDanger() danger} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for danger (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withDanger(@Nullable String value) {
    if (Objects.equals(this.danger, value)) return this;
    return new ImmutableConverter(
        this.warning,
        this.tip,
        this.important,
        value,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getNote() note} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for note (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withNote(@Nullable String value) {
    if (Objects.equals(this.note, value)) return this;
    return new ImmutableConverter(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        value,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutableConverter(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        value,
        this.description,
        this.icon,
        this.introduction,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableConverter(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        value,
        this.icon,
        this.introduction,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getIcon() icon} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withIcon(@Nullable String value) {
    if (Objects.equals(this.icon, value)) return this;
    return new ImmutableConverter(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        value,
        this.introduction,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getIntroduction() introduction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for introduction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withIntroduction(@Nullable String value) {
    if (Objects.equals(this.introduction, value)) return this;
    return new ImmutableConverter(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        value,
        this.cls);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Converter#getCls() cls} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cls
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConverter withCls(Class value) {
    if (this.cls == value) return this;
    Class newValue = Objects.requireNonNull(value, "cls");
    return new ImmutableConverter(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConverter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConverter
        && equalTo((ImmutableConverter) another);
  }

  private boolean equalTo(ImmutableConverter another) {
    return Objects.equals(warning, another.warning)
        && Objects.equals(tip, another.tip)
        && Objects.equals(important, another.important)
        && Objects.equals(danger, another.danger)
        && Objects.equals(note, another.note)
        && Objects.equals(title, another.title)
        && Objects.equals(description, another.description)
        && Objects.equals(icon, another.icon)
        && Objects.equals(introduction, another.introduction)
        && cls.equals(another.cls);
  }

  /**
   * Computes a hash code from attributes: {@code warning}, {@code tip}, {@code important}, {@code danger}, {@code note}, {@code title}, {@code description}, {@code icon}, {@code introduction}, {@code cls}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(warning);
    h += (h << 5) + Objects.hashCode(tip);
    h += (h << 5) + Objects.hashCode(important);
    h += (h << 5) + Objects.hashCode(danger);
    h += (h << 5) + Objects.hashCode(note);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + Objects.hashCode(introduction);
    h += (h << 5) + cls.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Converter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Converter")
        .omitNullValues()
        .add("warning", warning)
        .add("tip", tip)
        .add("important", important)
        .add("danger", danger)
        .add("note", note)
        .add("title", title)
        .add("description", description)
        .add("icon", icon)
        .add("introduction", introduction)
        .add("cls", cls)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.Converter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Converter instance
   */
  public static ImmutableConverter copyOf(Plugin.Converter instance) {
    if (instance instanceof ImmutableConverter) {
      return (ImmutableConverter) instance;
    }
    return ImmutableConverter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConverter ImmutableConverter}.
   * <pre>
   * ImmutableConverter.builder()
   *    .warning(String | null) // nullable {@link Plugin.Converter#getWarning() warning}
   *    .tip(String | null) // nullable {@link Plugin.Converter#getTip() tip}
   *    .important(String | null) // nullable {@link Plugin.Converter#getImportant() important}
   *    .danger(String | null) // nullable {@link Plugin.Converter#getDanger() danger}
   *    .note(String | null) // nullable {@link Plugin.Converter#getNote() note}
   *    .title(String | null) // nullable {@link Plugin.Converter#getTitle() title}
   *    .description(String | null) // nullable {@link Plugin.Converter#getDescription() description}
   *    .icon(String | null) // nullable {@link Plugin.Converter#getIcon() icon}
   *    .introduction(String | null) // nullable {@link Plugin.Converter#getIntroduction() introduction}
   *    .cls(Class) // required {@link Plugin.Converter#getCls() cls}
   *    .build();
   * </pre>
   * @return A new ImmutableConverter builder
   */
  public static ImmutableConverter.Builder builder() {
    return new ImmutableConverter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConverter ImmutableConverter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.Converter", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLS = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String warning;
    private @Nullable String tip;
    private @Nullable String important;
    private @Nullable String danger;
    private @Nullable String note;
    private @Nullable String title;
    private @Nullable String description;
    private @Nullable String icon;
    private @Nullable String introduction;
    private @Nullable Class cls;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Notes} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Notes instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Plugin.Converter} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.Converter instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Notes) {
        Notes instance = (Notes) object;
        @Nullable String importantValue = instance.getImportant();
        if (importantValue != null) {
          important(importantValue);
        }
        @Nullable String noteValue = instance.getNote();
        if (noteValue != null) {
          note(noteValue);
        }
        @Nullable String iconValue = instance.getIcon();
        if (iconValue != null) {
          icon(iconValue);
        }
        @Nullable String warningValue = instance.getWarning();
        if (warningValue != null) {
          warning(warningValue);
        }
        @Nullable String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String tipValue = instance.getTip();
        if (tipValue != null) {
          tip(tipValue);
        }
        @Nullable String dangerValue = instance.getDanger();
        if (dangerValue != null) {
          danger(dangerValue);
        }
        @Nullable String titleValue = instance.getTitle();
        if (titleValue != null) {
          title(titleValue);
        }
        @Nullable String introductionValue = instance.getIntroduction();
        if (introductionValue != null) {
          introduction(introductionValue);
        }
      }
      if (object instanceof Plugin.Converter) {
        Plugin.Converter instance = (Plugin.Converter) object;
        cls(instance.getCls());
      }
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getWarning() warning} attribute.
     * @param warning The value for warning (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder warning(@Nullable String warning) {
      this.warning = warning;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getTip() tip} attribute.
     * @param tip The value for tip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tip(@Nullable String tip) {
      this.tip = tip;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getImportant() important} attribute.
     * @param important The value for important (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder important(@Nullable String important) {
      this.important = important;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getDanger() danger} attribute.
     * @param danger The value for danger (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder danger(@Nullable String danger) {
      this.danger = danger;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getNote() note} attribute.
     * @param note The value for note (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder note(@Nullable String note) {
      this.note = note;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getTitle() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getIcon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder icon(@Nullable String icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getIntroduction() introduction} attribute.
     * @param introduction The value for introduction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder introduction(@Nullable String introduction) {
      this.introduction = introduction;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Converter#getCls() cls} attribute.
     * @param cls The value for cls 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cls(Class cls) {
      this.cls = Objects.requireNonNull(cls, "cls");
      initBits &= ~INIT_BIT_CLS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConverter ImmutableConverter}.
     * @return An immutable instance of Converter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConverter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConverter(warning, tip, important, danger, note, title, description, icon, introduction, cls);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLS) != 0) attributes.add("cls");
      return "Cannot build Converter, some of required attributes are not set " + attributes;
    }
  }
}
