package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Notes.Copy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCopy.builder()}.
 */
@Generated(from = "Notes.Copy", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCopy implements Notes.Copy {
  private final @Nullable String warning;
  private final @Nullable String tip;
  private final @Nullable String important;
  private final @Nullable String danger;
  private final @Nullable String note;
  private final @Nullable String title;
  private final @Nullable String description;
  private final @Nullable String icon;
  private final @Nullable String introduction;

  private ImmutableCopy(
      @Nullable String warning,
      @Nullable String tip,
      @Nullable String important,
      @Nullable String danger,
      @Nullable String note,
      @Nullable String title,
      @Nullable String description,
      @Nullable String icon,
      @Nullable String introduction) {
    this.warning = warning;
    this.tip = tip;
    this.important = important;
    this.danger = danger;
    this.note = note;
    this.title = title;
    this.description = description;
    this.icon = icon;
    this.introduction = introduction;
  }

  /**
   * @return The value of the {@code warning} attribute
   */
  @Override
  public @Nullable String getWarning() {
    return warning;
  }

  /**
   * @return The value of the {@code tip} attribute
   */
  @Override
  public @Nullable String getTip() {
    return tip;
  }

  /**
   * @return The value of the {@code important} attribute
   */
  @Override
  public @Nullable String getImportant() {
    return important;
  }

  /**
   * @return The value of the {@code danger} attribute
   */
  @Override
  public @Nullable String getDanger() {
    return danger;
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @Override
  public @Nullable String getNote() {
    return note;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public @Nullable String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public @Nullable String getIcon() {
    return icon;
  }

  /**
   * @return The value of the {@code introduction} attribute
   */
  @Override
  public @Nullable String getIntroduction() {
    return introduction;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getWarning() warning} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for warning (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withWarning(@Nullable String value) {
    if (Objects.equals(this.warning, value)) return this;
    return new ImmutableCopy(
        value,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getTip() tip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withTip(@Nullable String value) {
    if (Objects.equals(this.tip, value)) return this;
    return new ImmutableCopy(
        this.warning,
        value,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getImportant() important} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for important (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withImportant(@Nullable String value) {
    if (Objects.equals(this.important, value)) return this;
    return new ImmutableCopy(
        this.warning,
        this.tip,
        value,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getDanger() danger} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for danger (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withDanger(@Nullable String value) {
    if (Objects.equals(this.danger, value)) return this;
    return new ImmutableCopy(
        this.warning,
        this.tip,
        this.important,
        value,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getNote() note} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for note (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withNote(@Nullable String value) {
    if (Objects.equals(this.note, value)) return this;
    return new ImmutableCopy(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        value,
        this.title,
        this.description,
        this.icon,
        this.introduction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutableCopy(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        value,
        this.description,
        this.icon,
        this.introduction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableCopy(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        value,
        this.icon,
        this.introduction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getIcon() icon} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withIcon(@Nullable String value) {
    if (Objects.equals(this.icon, value)) return this;
    return new ImmutableCopy(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        value,
        this.introduction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Notes.Copy#getIntroduction() introduction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for introduction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCopy withIntroduction(@Nullable String value) {
    if (Objects.equals(this.introduction, value)) return this;
    return new ImmutableCopy(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCopy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCopy
        && equalTo((ImmutableCopy) another);
  }

  private boolean equalTo(ImmutableCopy another) {
    return Objects.equals(warning, another.warning)
        && Objects.equals(tip, another.tip)
        && Objects.equals(important, another.important)
        && Objects.equals(danger, another.danger)
        && Objects.equals(note, another.note)
        && Objects.equals(title, another.title)
        && Objects.equals(description, another.description)
        && Objects.equals(icon, another.icon)
        && Objects.equals(introduction, another.introduction);
  }

  /**
   * Computes a hash code from attributes: {@code warning}, {@code tip}, {@code important}, {@code danger}, {@code note}, {@code title}, {@code description}, {@code icon}, {@code introduction}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(warning);
    h += (h << 5) + Objects.hashCode(tip);
    h += (h << 5) + Objects.hashCode(important);
    h += (h << 5) + Objects.hashCode(danger);
    h += (h << 5) + Objects.hashCode(note);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + Objects.hashCode(introduction);
    return h;
  }

  /**
   * Prints the immutable value {@code Copy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Copy")
        .omitNullValues()
        .add("warning", warning)
        .add("tip", tip)
        .add("important", important)
        .add("danger", danger)
        .add("note", note)
        .add("title", title)
        .add("description", description)
        .add("icon", icon)
        .add("introduction", introduction)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Notes.Copy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Copy instance
   */
  public static ImmutableCopy copyOf(Notes.Copy instance) {
    if (instance instanceof ImmutableCopy) {
      return (ImmutableCopy) instance;
    }
    return ImmutableCopy.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCopy ImmutableCopy}.
   * <pre>
   * ImmutableCopy.builder()
   *    .warning(String | null) // nullable {@link Notes.Copy#getWarning() warning}
   *    .tip(String | null) // nullable {@link Notes.Copy#getTip() tip}
   *    .important(String | null) // nullable {@link Notes.Copy#getImportant() important}
   *    .danger(String | null) // nullable {@link Notes.Copy#getDanger() danger}
   *    .note(String | null) // nullable {@link Notes.Copy#getNote() note}
   *    .title(String | null) // nullable {@link Notes.Copy#getTitle() title}
   *    .description(String | null) // nullable {@link Notes.Copy#getDescription() description}
   *    .icon(String | null) // nullable {@link Notes.Copy#getIcon() icon}
   *    .introduction(String | null) // nullable {@link Notes.Copy#getIntroduction() introduction}
   *    .build();
   * </pre>
   * @return A new ImmutableCopy builder
   */
  public static ImmutableCopy.Builder builder() {
    return new ImmutableCopy.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCopy ImmutableCopy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Notes.Copy", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String warning;
    private @Nullable String tip;
    private @Nullable String important;
    private @Nullable String danger;
    private @Nullable String note;
    private @Nullable String title;
    private @Nullable String description;
    private @Nullable String icon;
    private @Nullable String introduction;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Notes} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Notes instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Notes.Copy} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Notes.Copy instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Notes) {
        Notes instance = (Notes) object;
        @Nullable String importantValue = instance.getImportant();
        if (importantValue != null) {
          important(importantValue);
        }
        @Nullable String noteValue = instance.getNote();
        if (noteValue != null) {
          note(noteValue);
        }
        @Nullable String iconValue = instance.getIcon();
        if (iconValue != null) {
          icon(iconValue);
        }
        @Nullable String warningValue = instance.getWarning();
        if (warningValue != null) {
          warning(warningValue);
        }
        @Nullable String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String tipValue = instance.getTip();
        if (tipValue != null) {
          tip(tipValue);
        }
        @Nullable String dangerValue = instance.getDanger();
        if (dangerValue != null) {
          danger(dangerValue);
        }
        @Nullable String titleValue = instance.getTitle();
        if (titleValue != null) {
          title(titleValue);
        }
        @Nullable String introductionValue = instance.getIntroduction();
        if (introductionValue != null) {
          introduction(introductionValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getWarning() warning} attribute.
     * @param warning The value for warning (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder warning(@Nullable String warning) {
      this.warning = warning;
      return this;
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getTip() tip} attribute.
     * @param tip The value for tip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tip(@Nullable String tip) {
      this.tip = tip;
      return this;
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getImportant() important} attribute.
     * @param important The value for important (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder important(@Nullable String important) {
      this.important = important;
      return this;
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getDanger() danger} attribute.
     * @param danger The value for danger (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder danger(@Nullable String danger) {
      this.danger = danger;
      return this;
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getNote() note} attribute.
     * @param note The value for note (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder note(@Nullable String note) {
      this.note = note;
      return this;
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getTitle() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getIcon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder icon(@Nullable String icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Initializes the value for the {@link Notes.Copy#getIntroduction() introduction} attribute.
     * @param introduction The value for introduction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder introduction(@Nullable String introduction) {
      this.introduction = introduction;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCopy ImmutableCopy}.
     * @return An immutable instance of Copy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCopy build() {
      return new ImmutableCopy(warning, tip, important, danger, note, title, description, icon, introduction);
    }
  }
}
