package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.common.config.ConfigDef;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.Item}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItem.builder()}.
 */
@Generated(from = "Plugin.Item", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItem implements Plugin.Item {
  private final String name;
  private final ConfigDef.Importance importance;
  private final String doc;
  private final @Nullable Object defaultValue;
  private final @Nullable ConfigDef.Validator validator;
  private final ConfigDef.Type type;
  private final String group;
  private final boolean isRequired;

  private ImmutableItem(
      String name,
      ConfigDef.Importance importance,
      String doc,
      @Nullable Object defaultValue,
      @Nullable ConfigDef.Validator validator,
      ConfigDef.Type type,
      String group,
      boolean isRequired) {
    this.name = name;
    this.importance = importance;
    this.doc = doc;
    this.defaultValue = defaultValue;
    this.validator = validator;
    this.type = type;
    this.group = group;
    this.isRequired = isRequired;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code importance} attribute
   */
  @Override
  public ConfigDef.Importance getImportance() {
    return importance;
  }

  /**
   * @return The value of the {@code doc} attribute
   */
  @Override
  public String getDoc() {
    return doc;
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @Override
  public @Nullable Object getDefaultValue() {
    return defaultValue;
  }

  /**
   * @return The value of the {@code validator} attribute
   */
  @Override
  public @Nullable ConfigDef.Validator getValidator() {
    return validator;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public ConfigDef.Type getType() {
    return type;
  }

  /**
   * @return The value of the {@code group} attribute
   */
  @Override
  public String getGroup() {
    return group;
  }

  /**
   * @return The value of the {@code isRequired} attribute
   */
  @Override
  public boolean isRequired() {
    return isRequired;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Item#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableItem(
        newValue,
        this.importance,
        this.doc,
        this.defaultValue,
        this.validator,
        this.type,
        this.group,
        this.isRequired);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Item#getImportance() importance} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for importance
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withImportance(ConfigDef.Importance value) {
    if (this.importance == value) return this;
    ConfigDef.Importance newValue = Objects.requireNonNull(value, "importance");
    if (this.importance.equals(newValue)) return this;
    return new ImmutableItem(
        this.name,
        newValue,
        this.doc,
        this.defaultValue,
        this.validator,
        this.type,
        this.group,
        this.isRequired);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Item#getDoc() doc} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for doc
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withDoc(String value) {
    String newValue = Objects.requireNonNull(value, "doc");
    if (this.doc.equals(newValue)) return this;
    return new ImmutableItem(
        this.name,
        this.importance,
        newValue,
        this.defaultValue,
        this.validator,
        this.type,
        this.group,
        this.isRequired);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Item#getDefaultValue() defaultValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withDefaultValue(@Nullable Object value) {
    if (this.defaultValue == value) return this;
    return new ImmutableItem(
        this.name,
        this.importance,
        this.doc,
        value,
        this.validator,
        this.type,
        this.group,
        this.isRequired);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Item#getValidator() validator} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withValidator(@Nullable ConfigDef.Validator value) {
    if (this.validator == value) return this;
    return new ImmutableItem(
        this.name,
        this.importance,
        this.doc,
        this.defaultValue,
        value,
        this.type,
        this.group,
        this.isRequired);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Item#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withType(ConfigDef.Type value) {
    if (this.type == value) return this;
    ConfigDef.Type newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableItem(
        this.name,
        this.importance,
        this.doc,
        this.defaultValue,
        this.validator,
        newValue,
        this.group,
        this.isRequired);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Item#getGroup() group} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for group
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withGroup(String value) {
    String newValue = Objects.requireNonNull(value, "group");
    if (this.group.equals(newValue)) return this;
    return new ImmutableItem(
        this.name,
        this.importance,
        this.doc,
        this.defaultValue,
        this.validator,
        this.type,
        newValue,
        this.isRequired);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.Item#isRequired() isRequired} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isRequired
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withIsRequired(boolean value) {
    if (this.isRequired == value) return this;
    return new ImmutableItem(
        this.name,
        this.importance,
        this.doc,
        this.defaultValue,
        this.validator,
        this.type,
        this.group,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItem
        && equalTo((ImmutableItem) another);
  }

  private boolean equalTo(ImmutableItem another) {
    return name.equals(another.name)
        && importance.equals(another.importance)
        && doc.equals(another.doc)
        && Objects.equals(defaultValue, another.defaultValue)
        && Objects.equals(validator, another.validator)
        && type.equals(another.type)
        && group.equals(another.group)
        && isRequired == another.isRequired;
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code importance}, {@code doc}, {@code defaultValue}, {@code validator}, {@code type}, {@code group}, {@code isRequired}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + importance.hashCode();
    h += (h << 5) + doc.hashCode();
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + Objects.hashCode(validator);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + group.hashCode();
    h += (h << 5) + Booleans.hashCode(isRequired);
    return h;
  }

  /**
   * Prints the immutable value {@code Item} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Item")
        .omitNullValues()
        .add("name", name)
        .add("importance", importance)
        .add("doc", doc)
        .add("defaultValue", defaultValue)
        .add("validator", validator)
        .add("type", type)
        .add("group", group)
        .add("isRequired", isRequired)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.Item} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Item instance
   */
  public static ImmutableItem copyOf(Plugin.Item instance) {
    if (instance instanceof ImmutableItem) {
      return (ImmutableItem) instance;
    }
    return ImmutableItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItem ImmutableItem}.
   * <pre>
   * ImmutableItem.builder()
   *    .name(String) // required {@link Plugin.Item#getName() name}
   *    .importance(org.apache.kafka.common.config.ConfigDef.Importance) // required {@link Plugin.Item#getImportance() importance}
   *    .doc(String) // required {@link Plugin.Item#getDoc() doc}
   *    .defaultValue(Object | null) // nullable {@link Plugin.Item#getDefaultValue() defaultValue}
   *    .validator(org.apache.kafka.common.config.ConfigDef.Validator | null) // nullable {@link Plugin.Item#getValidator() validator}
   *    .type(org.apache.kafka.common.config.ConfigDef.Type) // required {@link Plugin.Item#getType() type}
   *    .group(String) // required {@link Plugin.Item#getGroup() group}
   *    .isRequired(boolean) // required {@link Plugin.Item#isRequired() isRequired}
   *    .build();
   * </pre>
   * @return A new ImmutableItem builder
   */
  public static ImmutableItem.Builder builder() {
    return new ImmutableItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItem ImmutableItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.Item", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_IMPORTANCE = 0x2L;
    private static final long INIT_BIT_DOC = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private static final long INIT_BIT_GROUP = 0x10L;
    private static final long INIT_BIT_IS_REQUIRED = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String name;
    private @Nullable ConfigDef.Importance importance;
    private @Nullable String doc;
    private @Nullable Object defaultValue;
    private @Nullable ConfigDef.Validator validator;
    private @Nullable ConfigDef.Type type;
    private @Nullable String group;
    private boolean isRequired;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Item} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.Item instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      importance(instance.getImportance());
      doc(instance.getDoc());
      @Nullable Object defaultValueValue = instance.getDefaultValue();
      if (defaultValueValue != null) {
        defaultValue(defaultValueValue);
      }
      @Nullable ConfigDef.Validator validatorValue = instance.getValidator();
      if (validatorValue != null) {
        validator(validatorValue);
      }
      type(instance.getType());
      group(instance.getGroup());
      isRequired(instance.isRequired());
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Item#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Item#getImportance() importance} attribute.
     * @param importance The value for importance 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder importance(ConfigDef.Importance importance) {
      this.importance = Objects.requireNonNull(importance, "importance");
      initBits &= ~INIT_BIT_IMPORTANCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Item#getDoc() doc} attribute.
     * @param doc The value for doc 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder doc(String doc) {
      this.doc = Objects.requireNonNull(doc, "doc");
      initBits &= ~INIT_BIT_DOC;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Item#getDefaultValue() defaultValue} attribute.
     * @param defaultValue The value for defaultValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultValue(@Nullable Object defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Item#getValidator() validator} attribute.
     * @param validator The value for validator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder validator(@Nullable ConfigDef.Validator validator) {
      this.validator = validator;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Item#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(ConfigDef.Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Item#getGroup() group} attribute.
     * @param group The value for group 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder group(String group) {
      this.group = Objects.requireNonNull(group, "group");
      initBits &= ~INIT_BIT_GROUP;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.Item#isRequired() isRequired} attribute.
     * @param isRequired The value for isRequired 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isRequired(boolean isRequired) {
      this.isRequired = isRequired;
      initBits &= ~INIT_BIT_IS_REQUIRED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItem ImmutableItem}.
     * @return An immutable instance of Item
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItem(name, importance, doc, defaultValue, validator, type, group, isRequired);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_IMPORTANCE) != 0) attributes.add("importance");
      if ((initBits & INIT_BIT_DOC) != 0) attributes.add("doc");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_GROUP) != 0) attributes.add("group");
      if ((initBits & INIT_BIT_IS_REQUIRED) != 0) attributes.add("isRequired");
      return "Cannot build Item, some of required attributes are not set " + attributes;
    }
  }
}
