package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePlugin.builder()}.
 */
@Generated(from = "Plugin", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePlugin implements Plugin {
  private final @Nullable String warning;
  private final @Nullable String tip;
  private final @Nullable String important;
  private final @Nullable String danger;
  private final @Nullable String note;
  private final @Nullable String title;
  private final @Nullable String description;
  private final @Nullable String icon;
  private final String introduction;
  private final String pluginName;
  private final String pluginOwner;
  private final ImmutableList<Plugin.Transformation> transformations;
  private final ImmutableList<Plugin.SinkConnector> sinkConnectors;
  private final ImmutableList<Plugin.SourceConnector> sourceConnectors;
  private final ImmutableList<Plugin.Converter> converters;

  private ImmutablePlugin(
      @Nullable String warning,
      @Nullable String tip,
      @Nullable String important,
      @Nullable String danger,
      @Nullable String note,
      @Nullable String title,
      @Nullable String description,
      @Nullable String icon,
      String introduction,
      String pluginName,
      String pluginOwner,
      ImmutableList<Plugin.Transformation> transformations,
      ImmutableList<Plugin.SinkConnector> sinkConnectors,
      ImmutableList<Plugin.SourceConnector> sourceConnectors,
      ImmutableList<Plugin.Converter> converters) {
    this.warning = warning;
    this.tip = tip;
    this.important = important;
    this.danger = danger;
    this.note = note;
    this.title = title;
    this.description = description;
    this.icon = icon;
    this.introduction = introduction;
    this.pluginName = pluginName;
    this.pluginOwner = pluginOwner;
    this.transformations = transformations;
    this.sinkConnectors = sinkConnectors;
    this.sourceConnectors = sourceConnectors;
    this.converters = converters;
  }

  /**
   * @return The value of the {@code warning} attribute
   */
  @Override
  public @Nullable String getWarning() {
    return warning;
  }

  /**
   * @return The value of the {@code tip} attribute
   */
  @Override
  public @Nullable String getTip() {
    return tip;
  }

  /**
   * @return The value of the {@code important} attribute
   */
  @Override
  public @Nullable String getImportant() {
    return important;
  }

  /**
   * @return The value of the {@code danger} attribute
   */
  @Override
  public @Nullable String getDanger() {
    return danger;
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @Override
  public @Nullable String getNote() {
    return note;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public @Nullable String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public @Nullable String getIcon() {
    return icon;
  }

  /**
   * @return The value of the {@code introduction} attribute
   */
  @Override
  public String getIntroduction() {
    return introduction;
  }

  /**
   * @return The value of the {@code pluginName} attribute
   */
  @Override
  public String getPluginName() {
    return pluginName;
  }

  /**
   * @return The value of the {@code pluginOwner} attribute
   */
  @Override
  public String getPluginOwner() {
    return pluginOwner;
  }

  /**
   * @return The value of the {@code transformations} attribute
   */
  @Override
  public ImmutableList<Plugin.Transformation> getTransformations() {
    return transformations;
  }

  /**
   * @return The value of the {@code sinkConnectors} attribute
   */
  @Override
  public ImmutableList<Plugin.SinkConnector> getSinkConnectors() {
    return sinkConnectors;
  }

  /**
   * @return The value of the {@code sourceConnectors} attribute
   */
  @Override
  public ImmutableList<Plugin.SourceConnector> getSourceConnectors() {
    return sourceConnectors;
  }

  /**
   * @return The value of the {@code converters} attribute
   */
  @Override
  public ImmutableList<Plugin.Converter> getConverters() {
    return converters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getWarning() warning} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for warning (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withWarning(@Nullable String value) {
    if (Objects.equals(this.warning, value)) return this;
    return new ImmutablePlugin(
        value,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getTip() tip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withTip(@Nullable String value) {
    if (Objects.equals(this.tip, value)) return this;
    return new ImmutablePlugin(
        this.warning,
        value,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getImportant() important} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for important (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withImportant(@Nullable String value) {
    if (Objects.equals(this.important, value)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        value,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getDanger() danger} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for danger (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withDanger(@Nullable String value) {
    if (Objects.equals(this.danger, value)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        value,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getNote() note} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for note (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withNote(@Nullable String value) {
    if (Objects.equals(this.note, value)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        value,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        value,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        value,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getIcon() icon} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withIcon(@Nullable String value) {
    if (Objects.equals(this.icon, value)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        value,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getIntroduction() introduction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for introduction
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withIntroduction(String value) {
    String newValue = Objects.requireNonNull(value, "introduction");
    if (this.introduction.equals(newValue)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        newValue,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getPluginName() pluginName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pluginName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withPluginName(String value) {
    String newValue = Objects.requireNonNull(value, "pluginName");
    if (this.pluginName.equals(newValue)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        newValue,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin#getPluginOwner() pluginOwner} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pluginOwner
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlugin withPluginOwner(String value) {
    String newValue = Objects.requireNonNull(value, "pluginOwner");
    if (this.pluginOwner.equals(newValue)) return this;
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        newValue,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin#getTransformations() transformations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlugin withTransformations(Plugin.Transformation... elements) {
    ImmutableList<Plugin.Transformation> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        newValue,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin#getTransformations() transformations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of transformations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlugin withTransformations(Iterable<? extends Plugin.Transformation> elements) {
    if (this.transformations == elements) return this;
    ImmutableList<Plugin.Transformation> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        newValue,
        this.sinkConnectors,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin#getSinkConnectors() sinkConnectors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlugin withSinkConnectors(Plugin.SinkConnector... elements) {
    ImmutableList<Plugin.SinkConnector> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        newValue,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin#getSinkConnectors() sinkConnectors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sinkConnectors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlugin withSinkConnectors(Iterable<? extends Plugin.SinkConnector> elements) {
    if (this.sinkConnectors == elements) return this;
    ImmutableList<Plugin.SinkConnector> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        newValue,
        this.sourceConnectors,
        this.converters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin#getSourceConnectors() sourceConnectors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlugin withSourceConnectors(Plugin.SourceConnector... elements) {
    ImmutableList<Plugin.SourceConnector> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        newValue,
        this.converters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin#getSourceConnectors() sourceConnectors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sourceConnectors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlugin withSourceConnectors(Iterable<? extends Plugin.SourceConnector> elements) {
    if (this.sourceConnectors == elements) return this;
    ImmutableList<Plugin.SourceConnector> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        newValue,
        this.converters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin#getConverters() converters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlugin withConverters(Plugin.Converter... elements) {
    ImmutableList<Plugin.Converter> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin#getConverters() converters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of converters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlugin withConverters(Iterable<? extends Plugin.Converter> elements) {
    if (this.converters == elements) return this;
    ImmutableList<Plugin.Converter> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePlugin(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.pluginName,
        this.pluginOwner,
        this.transformations,
        this.sinkConnectors,
        this.sourceConnectors,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePlugin} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePlugin
        && equalTo((ImmutablePlugin) another);
  }

  private boolean equalTo(ImmutablePlugin another) {
    return Objects.equals(warning, another.warning)
        && Objects.equals(tip, another.tip)
        && Objects.equals(important, another.important)
        && Objects.equals(danger, another.danger)
        && Objects.equals(note, another.note)
        && Objects.equals(title, another.title)
        && Objects.equals(description, another.description)
        && Objects.equals(icon, another.icon)
        && introduction.equals(another.introduction)
        && pluginName.equals(another.pluginName)
        && pluginOwner.equals(another.pluginOwner)
        && transformations.equals(another.transformations)
        && sinkConnectors.equals(another.sinkConnectors)
        && sourceConnectors.equals(another.sourceConnectors)
        && converters.equals(another.converters);
  }

  /**
   * Computes a hash code from attributes: {@code warning}, {@code tip}, {@code important}, {@code danger}, {@code note}, {@code title}, {@code description}, {@code icon}, {@code introduction}, {@code pluginName}, {@code pluginOwner}, {@code transformations}, {@code sinkConnectors}, {@code sourceConnectors}, {@code converters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(warning);
    h += (h << 5) + Objects.hashCode(tip);
    h += (h << 5) + Objects.hashCode(important);
    h += (h << 5) + Objects.hashCode(danger);
    h += (h << 5) + Objects.hashCode(note);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + introduction.hashCode();
    h += (h << 5) + pluginName.hashCode();
    h += (h << 5) + pluginOwner.hashCode();
    h += (h << 5) + transformations.hashCode();
    h += (h << 5) + sinkConnectors.hashCode();
    h += (h << 5) + sourceConnectors.hashCode();
    h += (h << 5) + converters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Plugin} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Plugin")
        .omitNullValues()
        .add("warning", warning)
        .add("tip", tip)
        .add("important", important)
        .add("danger", danger)
        .add("note", note)
        .add("title", title)
        .add("description", description)
        .add("icon", icon)
        .add("introduction", introduction)
        .add("pluginName", pluginName)
        .add("pluginOwner", pluginOwner)
        .add("transformations", transformations)
        .add("sinkConnectors", sinkConnectors)
        .add("sourceConnectors", sourceConnectors)
        .add("converters", converters)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Plugin instance
   */
  public static ImmutablePlugin copyOf(Plugin instance) {
    if (instance instanceof ImmutablePlugin) {
      return (ImmutablePlugin) instance;
    }
    return ImmutablePlugin.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePlugin ImmutablePlugin}.
   * <pre>
   * ImmutablePlugin.builder()
   *    .warning(String | null) // nullable {@link Plugin#getWarning() warning}
   *    .tip(String | null) // nullable {@link Plugin#getTip() tip}
   *    .important(String | null) // nullable {@link Plugin#getImportant() important}
   *    .danger(String | null) // nullable {@link Plugin#getDanger() danger}
   *    .note(String | null) // nullable {@link Plugin#getNote() note}
   *    .title(String | null) // nullable {@link Plugin#getTitle() title}
   *    .description(String | null) // nullable {@link Plugin#getDescription() description}
   *    .icon(String | null) // nullable {@link Plugin#getIcon() icon}
   *    .introduction(String) // required {@link Plugin#getIntroduction() introduction}
   *    .pluginName(String) // required {@link Plugin#getPluginName() pluginName}
   *    .pluginOwner(String) // required {@link Plugin#getPluginOwner() pluginOwner}
   *    .addTransformations|addAllTransformations(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.Transformation) // {@link Plugin#getTransformations() transformations} elements
   *    .addSinkConnectors|addAllSinkConnectors(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SinkConnector) // {@link Plugin#getSinkConnectors() sinkConnectors} elements
   *    .addSourceConnectors|addAllSourceConnectors(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SourceConnector) // {@link Plugin#getSourceConnectors() sourceConnectors} elements
   *    .addConverters|addAllConverters(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.Converter) // {@link Plugin#getConverters() converters} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePlugin builder
   */
  public static ImmutablePlugin.Builder builder() {
    return new ImmutablePlugin.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePlugin ImmutablePlugin}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_INTRODUCTION = 0x1L;
    private static final long INIT_BIT_PLUGIN_NAME = 0x2L;
    private static final long INIT_BIT_PLUGIN_OWNER = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String warning;
    private @Nullable String tip;
    private @Nullable String important;
    private @Nullable String danger;
    private @Nullable String note;
    private @Nullable String title;
    private @Nullable String description;
    private @Nullable String icon;
    private @Nullable String introduction;
    private @Nullable String pluginName;
    private @Nullable String pluginOwner;
    private ImmutableList.Builder<Plugin.Transformation> transformations = ImmutableList.builder();
    private ImmutableList.Builder<Plugin.SinkConnector> sinkConnectors = ImmutableList.builder();
    private ImmutableList.Builder<Plugin.SourceConnector> sourceConnectors = ImmutableList.builder();
    private ImmutableList.Builder<Plugin.Converter> converters = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Notes} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Notes instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Plugin} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Notes) {
        Notes instance = (Notes) object;
        @Nullable String importantValue = instance.getImportant();
        if (importantValue != null) {
          important(importantValue);
        }
        @Nullable String noteValue = instance.getNote();
        if (noteValue != null) {
          note(noteValue);
        }
        @Nullable String iconValue = instance.getIcon();
        if (iconValue != null) {
          icon(iconValue);
        }
        @Nullable String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String warningValue = instance.getWarning();
        if (warningValue != null) {
          warning(warningValue);
        }
        @Nullable String tipValue = instance.getTip();
        if (tipValue != null) {
          tip(tipValue);
        }
        @Nullable String dangerValue = instance.getDanger();
        if (dangerValue != null) {
          danger(dangerValue);
        }
        @Nullable String titleValue = instance.getTitle();
        if (titleValue != null) {
          title(titleValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String introductionValue = instance.getIntroduction();
          if (introductionValue != null) {
            introduction(introductionValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof Plugin) {
        Plugin instance = (Plugin) object;
        addAllSourceConnectors(instance.getSourceConnectors());
        pluginName(instance.getPluginName());
        addAllTransformations(instance.getTransformations());
        addAllSinkConnectors(instance.getSinkConnectors());
        addAllConverters(instance.getConverters());
        if ((bits & 0x1L) == 0) {
          @Nullable String introductionValue = instance.getIntroduction();
          if (introductionValue != null) {
            introduction(introductionValue);
          }
          bits |= 0x1L;
        }
        pluginOwner(instance.getPluginOwner());
      }
    }

    /**
     * Initializes the value for the {@link Plugin#getWarning() warning} attribute.
     * @param warning The value for warning (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder warning(@Nullable String warning) {
      this.warning = warning;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getTip() tip} attribute.
     * @param tip The value for tip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tip(@Nullable String tip) {
      this.tip = tip;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getImportant() important} attribute.
     * @param important The value for important (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder important(@Nullable String important) {
      this.important = important;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getDanger() danger} attribute.
     * @param danger The value for danger (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder danger(@Nullable String danger) {
      this.danger = danger;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getNote() note} attribute.
     * @param note The value for note (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder note(@Nullable String note) {
      this.note = note;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getTitle() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getIcon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder icon(@Nullable String icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getIntroduction() introduction} attribute.
     * @param introduction The value for introduction 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder introduction(String introduction) {
      this.introduction = Objects.requireNonNull(introduction, "introduction");
      initBits &= ~INIT_BIT_INTRODUCTION;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getPluginName() pluginName} attribute.
     * @param pluginName The value for pluginName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pluginName(String pluginName) {
      this.pluginName = Objects.requireNonNull(pluginName, "pluginName");
      initBits &= ~INIT_BIT_PLUGIN_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin#getPluginOwner() pluginOwner} attribute.
     * @param pluginOwner The value for pluginOwner 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pluginOwner(String pluginOwner) {
      this.pluginOwner = Objects.requireNonNull(pluginOwner, "pluginOwner");
      initBits &= ~INIT_BIT_PLUGIN_OWNER;
      return this;
    }

    /**
     * Adds one element to {@link Plugin#getTransformations() transformations} list.
     * @param element A transformations element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTransformations(Plugin.Transformation element) {
      this.transformations.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin#getTransformations() transformations} list.
     * @param elements An array of transformations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTransformations(Plugin.Transformation... elements) {
      this.transformations.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin#getTransformations() transformations} list.
     * @param elements An iterable of transformations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder transformations(Iterable<? extends Plugin.Transformation> elements) {
      this.transformations = ImmutableList.builder();
      return addAllTransformations(elements);
    }

    /**
     * Adds elements to {@link Plugin#getTransformations() transformations} list.
     * @param elements An iterable of transformations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTransformations(Iterable<? extends Plugin.Transformation> elements) {
      this.transformations.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Plugin#getSinkConnectors() sinkConnectors} list.
     * @param element A sinkConnectors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSinkConnectors(Plugin.SinkConnector element) {
      this.sinkConnectors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin#getSinkConnectors() sinkConnectors} list.
     * @param elements An array of sinkConnectors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSinkConnectors(Plugin.SinkConnector... elements) {
      this.sinkConnectors.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin#getSinkConnectors() sinkConnectors} list.
     * @param elements An iterable of sinkConnectors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sinkConnectors(Iterable<? extends Plugin.SinkConnector> elements) {
      this.sinkConnectors = ImmutableList.builder();
      return addAllSinkConnectors(elements);
    }

    /**
     * Adds elements to {@link Plugin#getSinkConnectors() sinkConnectors} list.
     * @param elements An iterable of sinkConnectors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSinkConnectors(Iterable<? extends Plugin.SinkConnector> elements) {
      this.sinkConnectors.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Plugin#getSourceConnectors() sourceConnectors} list.
     * @param element A sourceConnectors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSourceConnectors(Plugin.SourceConnector element) {
      this.sourceConnectors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin#getSourceConnectors() sourceConnectors} list.
     * @param elements An array of sourceConnectors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSourceConnectors(Plugin.SourceConnector... elements) {
      this.sourceConnectors.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin#getSourceConnectors() sourceConnectors} list.
     * @param elements An iterable of sourceConnectors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sourceConnectors(Iterable<? extends Plugin.SourceConnector> elements) {
      this.sourceConnectors = ImmutableList.builder();
      return addAllSourceConnectors(elements);
    }

    /**
     * Adds elements to {@link Plugin#getSourceConnectors() sourceConnectors} list.
     * @param elements An iterable of sourceConnectors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSourceConnectors(Iterable<? extends Plugin.SourceConnector> elements) {
      this.sourceConnectors.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Plugin#getConverters() converters} list.
     * @param element A converters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addConverters(Plugin.Converter element) {
      this.converters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin#getConverters() converters} list.
     * @param elements An array of converters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addConverters(Plugin.Converter... elements) {
      this.converters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin#getConverters() converters} list.
     * @param elements An iterable of converters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder converters(Iterable<? extends Plugin.Converter> elements) {
      this.converters = ImmutableList.builder();
      return addAllConverters(elements);
    }

    /**
     * Adds elements to {@link Plugin#getConverters() converters} list.
     * @param elements An iterable of converters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllConverters(Iterable<? extends Plugin.Converter> elements) {
      this.converters.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePlugin ImmutablePlugin}.
     * @return An immutable instance of Plugin
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePlugin build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePlugin(
          warning,
          tip,
          important,
          danger,
          note,
          title,
          description,
          icon,
          introduction,
          pluginName,
          pluginOwner,
          transformations.build(),
          sinkConnectors.build(),
          sourceConnectors.build(),
          converters.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INTRODUCTION) != 0) attributes.add("introduction");
      if ((initBits & INIT_BIT_PLUGIN_NAME) != 0) attributes.add("pluginName");
      if ((initBits & INIT_BIT_PLUGIN_OWNER) != 0) attributes.add("pluginOwner");
      return "Cannot build Plugin, some of required attributes are not set " + attributes;
    }
  }
}
