package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.connect.data.Schema;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.SchemaInput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSchemaInput.builder()}.
 */
@Generated(from = "Plugin.SchemaInput", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSchemaInput
    implements Plugin.SchemaInput {
  private final @Nullable String name;
  private transient final @Nullable String schemaLink;
  private transient final @Nullable String shortName;
  private final @Nullable String doc;
  private final boolean isOptional;
  private final Schema.Type type;
  private final @Nullable String fieldName;
  private final @Nullable ImmutableList<Plugin.SchemaInput> fields;
  private final @Nullable Plugin.SchemaInput key;
  private final @Nullable Plugin.SchemaInput value;
  private transient final String refLink;
  private transient final String table;

  private ImmutableSchemaInput(
      @Nullable String name,
      @Nullable String doc,
      boolean isOptional,
      Schema.Type type,
      @Nullable String fieldName,
      @Nullable ImmutableList<Plugin.SchemaInput> fields,
      @Nullable Plugin.SchemaInput key,
      @Nullable Plugin.SchemaInput value) {
    this.name = name;
    this.doc = doc;
    this.isOptional = isOptional;
    this.type = type;
    this.fieldName = fieldName;
    this.fields = fields;
    this.key = key;
    this.value = value;
    this.schemaLink = initShim.getSchemaLink();
    this.shortName = initShim.getShortName();
    this.refLink = initShim.getRefLink();
    this.table = initShim.getTable();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Plugin.SchemaInput", generator = "Immutables")
  private final class InitShim {
    private byte schemaLinkBuildStage = STAGE_UNINITIALIZED;
    private String schemaLink;

    String getSchemaLink() {
      if (schemaLinkBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemaLinkBuildStage == STAGE_UNINITIALIZED) {
        schemaLinkBuildStage = STAGE_INITIALIZING;
        this.schemaLink = getSchemaLinkInitialize();
        schemaLinkBuildStage = STAGE_INITIALIZED;
      }
      return this.schemaLink;
    }

    private byte shortNameBuildStage = STAGE_UNINITIALIZED;
    private String shortName;

    String getShortName() {
      if (shortNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (shortNameBuildStage == STAGE_UNINITIALIZED) {
        shortNameBuildStage = STAGE_INITIALIZING;
        this.shortName = getShortNameInitialize();
        shortNameBuildStage = STAGE_INITIALIZED;
      }
      return this.shortName;
    }

    private byte refLinkBuildStage = STAGE_UNINITIALIZED;
    private String refLink;

    String getRefLink() {
      if (refLinkBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (refLinkBuildStage == STAGE_UNINITIALIZED) {
        refLinkBuildStage = STAGE_INITIALIZING;
        this.refLink = Objects.requireNonNull(getRefLinkInitialize(), "refLink");
        refLinkBuildStage = STAGE_INITIALIZED;
      }
      return this.refLink;
    }

    private byte tableBuildStage = STAGE_UNINITIALIZED;
    private String table;

    String getTable() {
      if (tableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tableBuildStage == STAGE_UNINITIALIZED) {
        tableBuildStage = STAGE_INITIALIZING;
        this.table = Objects.requireNonNull(getTableInitialize(), "table");
        tableBuildStage = STAGE_INITIALIZED;
      }
      return this.table;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (schemaLinkBuildStage == STAGE_INITIALIZING) attributes.add("schemaLink");
      if (shortNameBuildStage == STAGE_INITIALIZING) attributes.add("shortName");
      if (refLinkBuildStage == STAGE_INITIALIZING) attributes.add("refLink");
      if (tableBuildStage == STAGE_INITIALIZING) attributes.add("table");
      return "Cannot build SchemaInput, attribute initializers form cycle " + attributes;
    }
  }

  private @Nullable String getSchemaLinkInitialize() {
    return Plugin.SchemaInput.super.getSchemaLink();
  }

  private @Nullable String getShortNameInitialize() {
    return Plugin.SchemaInput.super.getShortName();
  }

  private String getRefLinkInitialize() {
    return Plugin.SchemaInput.super.getRefLink();
  }

  private String getTableInitialize() {
    return Plugin.SchemaInput.super.getTable();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The computed-at-construction value of the {@code schemaLink} attribute
   */
  @Override
  public @Nullable String getSchemaLink() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSchemaLink()
        : this.schemaLink;
  }

  /**
   * @return The computed-at-construction value of the {@code shortName} attribute
   */
  @Override
  public @Nullable String getShortName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getShortName()
        : this.shortName;
  }

  /**
   * @return The value of the {@code doc} attribute
   */
  @Override
  public @Nullable String getDoc() {
    return doc;
  }

  /**
   * @return The value of the {@code isOptional} attribute
   */
  @Override
  public boolean isOptional() {
    return isOptional;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public Schema.Type getType() {
    return type;
  }

  /**
   * @return The value of the {@code fieldName} attribute
   */
  @Override
  public @Nullable String getFieldName() {
    return fieldName;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @Override
  public @Nullable ImmutableList<Plugin.SchemaInput> getFields() {
    return fields;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public @Nullable Plugin.SchemaInput key() {
    return key;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable Plugin.SchemaInput value() {
    return value;
  }

  /**
   * @return The computed-at-construction value of the {@code refLink} attribute
   */
  @Override
  public String getRefLink() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRefLink()
        : this.refLink;
  }

  /**
   * @return The computed-at-construction value of the {@code table} attribute
   */
  @Override
  public String getTable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTable()
        : this.table;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SchemaInput#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchemaInput withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableSchemaInput(value, this.doc, this.isOptional, this.type, this.fieldName, this.fields, this.key, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SchemaInput#getDoc() doc} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for doc (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchemaInput withDoc(@Nullable String value) {
    if (Objects.equals(this.doc, value)) return this;
    return new ImmutableSchemaInput(this.name, value, this.isOptional, this.type, this.fieldName, this.fields, this.key, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SchemaInput#isOptional() isOptional} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isOptional
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchemaInput withIsOptional(boolean value) {
    if (this.isOptional == value) return this;
    return new ImmutableSchemaInput(this.name, this.doc, value, this.type, this.fieldName, this.fields, this.key, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SchemaInput#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchemaInput withType(Schema.Type value) {
    if (this.type == value) return this;
    Schema.Type newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableSchemaInput(
        this.name,
        this.doc,
        this.isOptional,
        newValue,
        this.fieldName,
        this.fields,
        this.key,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SchemaInput#getFieldName() fieldName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchemaInput withFieldName(@Nullable String value) {
    if (Objects.equals(this.fieldName, value)) return this;
    return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, value, this.fields, this.key, this.value);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.SchemaInput#getFields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSchemaInput withFields(@Nullable Plugin.SchemaInput... elements) {
    if (elements == null) {
      return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, null, this.key, this.value);
    }
    @Nullable ImmutableList<Plugin.SchemaInput> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, newValue, this.key, this.value);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.SchemaInput#getFields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSchemaInput withFields(@Nullable Iterable<? extends Plugin.SchemaInput> elements) {
    if (this.fields == elements) return this;
    @Nullable ImmutableList<Plugin.SchemaInput> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, newValue, this.key, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SchemaInput#key() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchemaInput withKey(@Nullable Plugin.SchemaInput value) {
    if (this.key == value) return this;
    return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, this.fields, value, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SchemaInput#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchemaInput withValue(@Nullable Plugin.SchemaInput value) {
    if (this.value == value) return this;
    return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, this.fields, this.key, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSchemaInput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSchemaInput
        && equalTo((ImmutableSchemaInput) another);
  }

  private boolean equalTo(ImmutableSchemaInput another) {
    return Objects.equals(name, another.name)
        && Objects.equals(schemaLink, another.schemaLink)
        && Objects.equals(shortName, another.shortName)
        && Objects.equals(doc, another.doc)
        && isOptional == another.isOptional
        && type.equals(another.type)
        && Objects.equals(fieldName, another.fieldName)
        && Objects.equals(fields, another.fields)
        && Objects.equals(key, another.key)
        && Objects.equals(value, another.value)
        && refLink.equals(another.refLink)
        && table.equals(another.table);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code schemaLink}, {@code shortName}, {@code doc}, {@code isOptional}, {@code type}, {@code fieldName}, {@code fields}, {@code key}, {@code value}, {@code refLink}, {@code table}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(schemaLink);
    h += (h << 5) + Objects.hashCode(shortName);
    h += (h << 5) + Objects.hashCode(doc);
    h += (h << 5) + Booleans.hashCode(isOptional);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(fieldName);
    h += (h << 5) + Objects.hashCode(fields);
    h += (h << 5) + Objects.hashCode(key);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + refLink.hashCode();
    h += (h << 5) + table.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SchemaInput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SchemaInput")
        .omitNullValues()
        .add("name", name)
        .add("schemaLink", schemaLink)
        .add("shortName", shortName)
        .add("doc", doc)
        .add("isOptional", isOptional)
        .add("type", type)
        .add("fieldName", fieldName)
        .add("fields", fields)
        .add("key", key)
        .add("value", value)
        .add("refLink", refLink)
        .add("table", table)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.SchemaInput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SchemaInput instance
   */
  public static ImmutableSchemaInput copyOf(Plugin.SchemaInput instance) {
    if (instance instanceof ImmutableSchemaInput) {
      return (ImmutableSchemaInput) instance;
    }
    return ImmutableSchemaInput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSchemaInput ImmutableSchemaInput}.
   * <pre>
   * ImmutableSchemaInput.builder()
   *    .name(String | null) // nullable {@link Plugin.SchemaInput#getName() name}
   *    .doc(String | null) // nullable {@link Plugin.SchemaInput#getDoc() doc}
   *    .isOptional(boolean) // required {@link Plugin.SchemaInput#isOptional() isOptional}
   *    .type(org.apache.kafka.connect.data.Schema.Type) // required {@link Plugin.SchemaInput#getType() type}
   *    .fieldName(String | null) // nullable {@link Plugin.SchemaInput#getFieldName() fieldName}
   *    .fields(List&amp;lt;com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SchemaInput&amp;gt; | null) // nullable {@link Plugin.SchemaInput#getFields() fields}
   *    .key(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SchemaInput | null) // nullable {@link Plugin.SchemaInput#key() key}
   *    .value(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SchemaInput | null) // nullable {@link Plugin.SchemaInput#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableSchemaInput builder
   */
  public static ImmutableSchemaInput.Builder builder() {
    return new ImmutableSchemaInput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSchemaInput ImmutableSchemaInput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.SchemaInput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IS_OPTIONAL = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String doc;
    private boolean isOptional;
    private @Nullable Schema.Type type;
    private @Nullable String fieldName;
    private ImmutableList.Builder<Plugin.SchemaInput> fields = null;
    private @Nullable Plugin.SchemaInput key;
    private @Nullable Plugin.SchemaInput value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SchemaInput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.SchemaInput instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String docValue = instance.getDoc();
      if (docValue != null) {
        doc(docValue);
      }
      isOptional(instance.isOptional());
      type(instance.getType());
      @Nullable String fieldNameValue = instance.getFieldName();
      if (fieldNameValue != null) {
        fieldName(fieldNameValue);
      }
      @Nullable List<Plugin.SchemaInput> fieldsValue = instance.getFields();
      if (fieldsValue != null) {
        addAllFields(fieldsValue);
      }
      @Nullable Plugin.SchemaInput keyValue = instance.key();
      if (keyValue != null) {
        key(keyValue);
      }
      @Nullable Plugin.SchemaInput valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SchemaInput#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SchemaInput#getDoc() doc} attribute.
     * @param doc The value for doc (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder doc(@Nullable String doc) {
      this.doc = doc;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SchemaInput#isOptional() isOptional} attribute.
     * @param isOptional The value for isOptional 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isOptional(boolean isOptional) {
      this.isOptional = isOptional;
      initBits &= ~INIT_BIT_IS_OPTIONAL;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SchemaInput#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(Schema.Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SchemaInput#getFieldName() fieldName} attribute.
     * @param fieldName The value for fieldName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fieldName(@Nullable String fieldName) {
      this.fieldName = fieldName;
      return this;
    }

    /**
     * Adds one element to {@link Plugin.SchemaInput#getFields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFields(Plugin.SchemaInput element) {
      if (this.fields == null) {
        this.fields = ImmutableList.builder();
      }
      this.fields.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin.SchemaInput#getFields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFields(Plugin.SchemaInput... elements) {
      if (this.fields == null) {
        this.fields = ImmutableList.builder();
      }
      this.fields.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin.SchemaInput#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fields(@Nullable Iterable<? extends Plugin.SchemaInput> elements) {
      if (elements == null) {
        this.fields = null;
        return this;
      }
      this.fields = ImmutableList.builder();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link Plugin.SchemaInput#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFields(Iterable<? extends Plugin.SchemaInput> elements) {
      Objects.requireNonNull(elements, "fields element");
      if (this.fields == null) {
        this.fields = ImmutableList.builder();
      }
      this.fields.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SchemaInput#key() key} attribute.
     * @param key The value for key (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder key(@Nullable Plugin.SchemaInput key) {
      this.key = key;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SchemaInput#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(@Nullable Plugin.SchemaInput value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSchemaInput ImmutableSchemaInput}.
     * @return An immutable instance of SchemaInput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSchemaInput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSchemaInput(name, doc, isOptional, type, fieldName, fields == null ? null : fields.build(), key, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IS_OPTIONAL) != 0) attributes.add("isOptional");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build SchemaInput, some of required attributes are not set " + attributes;
    }
  }
}
