package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.SinkConnector}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSinkConnector.builder()}.
 */
@Generated(from = "Plugin.SinkConnector", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSinkConnector
    implements Plugin.SinkConnector {
  private final @Nullable String warning;
  private final @Nullable String tip;
  private final @Nullable String important;
  private final @Nullable String danger;
  private final @Nullable String note;
  private final @Nullable String title;
  private final @Nullable String description;
  private final @Nullable String icon;
  private final @Nullable String introduction;
  private final Class cls;
  private final Plugin.Configuration configuration;
  private final ImmutableList<String> examples;

  private ImmutableSinkConnector(
      @Nullable String warning,
      @Nullable String tip,
      @Nullable String important,
      @Nullable String danger,
      @Nullable String note,
      @Nullable String title,
      @Nullable String description,
      @Nullable String icon,
      @Nullable String introduction,
      Class cls,
      Plugin.Configuration configuration,
      ImmutableList<String> examples) {
    this.warning = warning;
    this.tip = tip;
    this.important = important;
    this.danger = danger;
    this.note = note;
    this.title = title;
    this.description = description;
    this.icon = icon;
    this.introduction = introduction;
    this.cls = cls;
    this.configuration = configuration;
    this.examples = examples;
  }

  /**
   * @return The value of the {@code warning} attribute
   */
  @Override
  public @Nullable String getWarning() {
    return warning;
  }

  /**
   * @return The value of the {@code tip} attribute
   */
  @Override
  public @Nullable String getTip() {
    return tip;
  }

  /**
   * @return The value of the {@code important} attribute
   */
  @Override
  public @Nullable String getImportant() {
    return important;
  }

  /**
   * @return The value of the {@code danger} attribute
   */
  @Override
  public @Nullable String getDanger() {
    return danger;
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @Override
  public @Nullable String getNote() {
    return note;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public @Nullable String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public @Nullable String getIcon() {
    return icon;
  }

  /**
   * @return The value of the {@code introduction} attribute
   */
  @Override
  public @Nullable String getIntroduction() {
    return introduction;
  }

  /**
   * @return The value of the {@code cls} attribute
   */
  @Override
  public Class getCls() {
    return cls;
  }

  /**
   * @return The value of the {@code configuration} attribute
   */
  @Override
  public Plugin.Configuration getConfiguration() {
    return configuration;
  }

  /**
   * @return The value of the {@code examples} attribute
   */
  @Override
  public ImmutableList<String> getExamples() {
    return examples;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getWarning() warning} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for warning (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withWarning(@Nullable String value) {
    if (Objects.equals(this.warning, value)) return this;
    return new ImmutableSinkConnector(
        value,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getTip() tip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withTip(@Nullable String value) {
    if (Objects.equals(this.tip, value)) return this;
    return new ImmutableSinkConnector(
        this.warning,
        value,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getImportant() important} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for important (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withImportant(@Nullable String value) {
    if (Objects.equals(this.important, value)) return this;
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        value,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getDanger() danger} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for danger (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withDanger(@Nullable String value) {
    if (Objects.equals(this.danger, value)) return this;
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        value,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getNote() note} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for note (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withNote(@Nullable String value) {
    if (Objects.equals(this.note, value)) return this;
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        value,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        value,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        value,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getIcon() icon} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withIcon(@Nullable String value) {
    if (Objects.equals(this.icon, value)) return this;
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        value,
        this.introduction,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getIntroduction() introduction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for introduction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withIntroduction(@Nullable String value) {
    if (Objects.equals(this.introduction, value)) return this;
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        value,
        this.cls,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getCls() cls} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cls
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withCls(Class value) {
    if (this.cls == value) return this;
    Class newValue = Objects.requireNonNull(value, "cls");
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        newValue,
        this.configuration,
        this.examples);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnector#getConfiguration() configuration} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for configuration
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnector withConfiguration(Plugin.Configuration value) {
    if (this.configuration == value) return this;
    Plugin.Configuration newValue = Objects.requireNonNull(value, "configuration");
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        newValue,
        this.examples);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.SinkConnector#getExamples() examples}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSinkConnector withExamples(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.SinkConnector#getExamples() examples}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of examples elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSinkConnector withExamples(Iterable<String> elements) {
    if (this.examples == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSinkConnector(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.cls,
        this.configuration,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSinkConnector} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSinkConnector
        && equalTo((ImmutableSinkConnector) another);
  }

  private boolean equalTo(ImmutableSinkConnector another) {
    return Objects.equals(warning, another.warning)
        && Objects.equals(tip, another.tip)
        && Objects.equals(important, another.important)
        && Objects.equals(danger, another.danger)
        && Objects.equals(note, another.note)
        && Objects.equals(title, another.title)
        && Objects.equals(description, another.description)
        && Objects.equals(icon, another.icon)
        && Objects.equals(introduction, another.introduction)
        && cls.equals(another.cls)
        && configuration.equals(another.configuration)
        && examples.equals(another.examples);
  }

  /**
   * Computes a hash code from attributes: {@code warning}, {@code tip}, {@code important}, {@code danger}, {@code note}, {@code title}, {@code description}, {@code icon}, {@code introduction}, {@code cls}, {@code configuration}, {@code examples}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(warning);
    h += (h << 5) + Objects.hashCode(tip);
    h += (h << 5) + Objects.hashCode(important);
    h += (h << 5) + Objects.hashCode(danger);
    h += (h << 5) + Objects.hashCode(note);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + Objects.hashCode(introduction);
    h += (h << 5) + cls.hashCode();
    h += (h << 5) + configuration.hashCode();
    h += (h << 5) + examples.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SinkConnector} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SinkConnector")
        .omitNullValues()
        .add("warning", warning)
        .add("tip", tip)
        .add("important", important)
        .add("danger", danger)
        .add("note", note)
        .add("title", title)
        .add("description", description)
        .add("icon", icon)
        .add("introduction", introduction)
        .add("cls", cls)
        .add("configuration", configuration)
        .add("examples", examples)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.SinkConnector} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SinkConnector instance
   */
  public static ImmutableSinkConnector copyOf(Plugin.SinkConnector instance) {
    if (instance instanceof ImmutableSinkConnector) {
      return (ImmutableSinkConnector) instance;
    }
    return ImmutableSinkConnector.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSinkConnector ImmutableSinkConnector}.
   * <pre>
   * ImmutableSinkConnector.builder()
   *    .warning(String | null) // nullable {@link Plugin.SinkConnector#getWarning() warning}
   *    .tip(String | null) // nullable {@link Plugin.SinkConnector#getTip() tip}
   *    .important(String | null) // nullable {@link Plugin.SinkConnector#getImportant() important}
   *    .danger(String | null) // nullable {@link Plugin.SinkConnector#getDanger() danger}
   *    .note(String | null) // nullable {@link Plugin.SinkConnector#getNote() note}
   *    .title(String | null) // nullable {@link Plugin.SinkConnector#getTitle() title}
   *    .description(String | null) // nullable {@link Plugin.SinkConnector#getDescription() description}
   *    .icon(String | null) // nullable {@link Plugin.SinkConnector#getIcon() icon}
   *    .introduction(String | null) // nullable {@link Plugin.SinkConnector#getIntroduction() introduction}
   *    .cls(Class) // required {@link Plugin.SinkConnector#getCls() cls}
   *    .configuration(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.Configuration) // required {@link Plugin.SinkConnector#getConfiguration() configuration}
   *    .addExamples|addAllExamples(String) // {@link Plugin.SinkConnector#getExamples() examples} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSinkConnector builder
   */
  public static ImmutableSinkConnector.Builder builder() {
    return new ImmutableSinkConnector.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSinkConnector ImmutableSinkConnector}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.SinkConnector", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLS = 0x1L;
    private static final long INIT_BIT_CONFIGURATION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String warning;
    private @Nullable String tip;
    private @Nullable String important;
    private @Nullable String danger;
    private @Nullable String note;
    private @Nullable String title;
    private @Nullable String description;
    private @Nullable String icon;
    private @Nullable String introduction;
    private @Nullable Class cls;
    private @Nullable Plugin.Configuration configuration;
    private ImmutableList.Builder<String> examples = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Notes} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Notes instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Plugin.Configurable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.Configurable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SinkConnector} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.SinkConnector instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Notes) {
        Notes instance = (Notes) object;
        @Nullable String importantValue = instance.getImportant();
        if (importantValue != null) {
          important(importantValue);
        }
        @Nullable String noteValue = instance.getNote();
        if (noteValue != null) {
          note(noteValue);
        }
        @Nullable String iconValue = instance.getIcon();
        if (iconValue != null) {
          icon(iconValue);
        }
        @Nullable String warningValue = instance.getWarning();
        if (warningValue != null) {
          warning(warningValue);
        }
        @Nullable String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String tipValue = instance.getTip();
        if (tipValue != null) {
          tip(tipValue);
        }
        @Nullable String dangerValue = instance.getDanger();
        if (dangerValue != null) {
          danger(dangerValue);
        }
        @Nullable String titleValue = instance.getTitle();
        if (titleValue != null) {
          title(titleValue);
        }
        @Nullable String introductionValue = instance.getIntroduction();
        if (introductionValue != null) {
          introduction(introductionValue);
        }
      }
      if (object instanceof Plugin.Configurable) {
        Plugin.Configurable instance = (Plugin.Configurable) object;
        addAllExamples(instance.getExamples());
        configuration(instance.getConfiguration());
        cls(instance.getCls());
      }
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getWarning() warning} attribute.
     * @param warning The value for warning (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder warning(@Nullable String warning) {
      this.warning = warning;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getTip() tip} attribute.
     * @param tip The value for tip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tip(@Nullable String tip) {
      this.tip = tip;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getImportant() important} attribute.
     * @param important The value for important (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder important(@Nullable String important) {
      this.important = important;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getDanger() danger} attribute.
     * @param danger The value for danger (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder danger(@Nullable String danger) {
      this.danger = danger;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getNote() note} attribute.
     * @param note The value for note (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder note(@Nullable String note) {
      this.note = note;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getTitle() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getIcon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder icon(@Nullable String icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getIntroduction() introduction} attribute.
     * @param introduction The value for introduction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder introduction(@Nullable String introduction) {
      this.introduction = introduction;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getCls() cls} attribute.
     * @param cls The value for cls 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cls(Class cls) {
      this.cls = Objects.requireNonNull(cls, "cls");
      initBits &= ~INIT_BIT_CLS;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnector#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder configuration(Plugin.Configuration configuration) {
      this.configuration = Objects.requireNonNull(configuration, "configuration");
      initBits &= ~INIT_BIT_CONFIGURATION;
      return this;
    }

    /**
     * Adds one element to {@link Plugin.SinkConnector#getExamples() examples} list.
     * @param element A examples element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExamples(String element) {
      this.examples.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin.SinkConnector#getExamples() examples} list.
     * @param elements An array of examples elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExamples(String... elements) {
      this.examples.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin.SinkConnector#getExamples() examples} list.
     * @param elements An iterable of examples elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder examples(Iterable<String> elements) {
      this.examples = ImmutableList.builder();
      return addAllExamples(elements);
    }

    /**
     * Adds elements to {@link Plugin.SinkConnector#getExamples() examples} list.
     * @param elements An iterable of examples elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExamples(Iterable<String> elements) {
      this.examples.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSinkConnector ImmutableSinkConnector}.
     * @return An immutable instance of SinkConnector
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSinkConnector build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSinkConnector(
          warning,
          tip,
          important,
          danger,
          note,
          title,
          description,
          icon,
          introduction,
          cls,
          configuration,
          examples.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLS) != 0) attributes.add("cls");
      if ((initBits & INIT_BIT_CONFIGURATION) != 0) attributes.add("configuration");
      return "Cannot build SinkConnector, some of required attributes are not set " + attributes;
    }
  }
}
