package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.SinkConnectorExampleInput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSinkConnectorExampleInput.builder()}.
 */
@Generated(from = "Plugin.SinkConnectorExampleInput", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSinkConnectorExampleInput
    implements Plugin.SinkConnectorExampleInput {
  private final @Nullable String config;
  private final Plugin.SinkConnectorExample example;
  private final @Nullable String inputJson;
  private final @Nullable String inputDescription;
  private final @Nullable String outputJson;
  private final @Nullable String outputDescription;

  private ImmutableSinkConnectorExampleInput(
      @Nullable String config,
      Plugin.SinkConnectorExample example,
      @Nullable String inputJson,
      @Nullable String inputDescription,
      @Nullable String outputJson,
      @Nullable String outputDescription) {
    this.config = config;
    this.example = example;
    this.inputJson = inputJson;
    this.inputDescription = inputDescription;
    this.outputJson = outputJson;
    this.outputDescription = outputDescription;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @Override
  public @Nullable String getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code example} attribute
   */
  @Override
  public Plugin.SinkConnectorExample getExample() {
    return example;
  }

  /**
   * @return The value of the {@code inputJson} attribute
   */
  @Override
  public @Nullable String getInputJson() {
    return inputJson;
  }

  /**
   * @return The value of the {@code inputDescription} attribute
   */
  @Override
  public @Nullable String getInputDescription() {
    return inputDescription;
  }

  /**
   * @return The value of the {@code outputJson} attribute
   */
  @Override
  public @Nullable String getOutputJson() {
    return outputJson;
  }

  /**
   * @return The value of the {@code outputDescription} attribute
   */
  @Override
  public @Nullable String getOutputDescription() {
    return outputDescription;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnectorExampleInput#getConfig() config} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnectorExampleInput withConfig(@Nullable String value) {
    if (Objects.equals(this.config, value)) return this;
    return new ImmutableSinkConnectorExampleInput(
        value,
        this.example,
        this.inputJson,
        this.inputDescription,
        this.outputJson,
        this.outputDescription);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnectorExampleInput#getExample() example} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for example
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnectorExampleInput withExample(Plugin.SinkConnectorExample value) {
    if (this.example == value) return this;
    Plugin.SinkConnectorExample newValue = Objects.requireNonNull(value, "example");
    return new ImmutableSinkConnectorExampleInput(
        this.config,
        newValue,
        this.inputJson,
        this.inputDescription,
        this.outputJson,
        this.outputDescription);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnectorExampleInput#getInputJson() inputJson} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inputJson (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnectorExampleInput withInputJson(@Nullable String value) {
    if (Objects.equals(this.inputJson, value)) return this;
    return new ImmutableSinkConnectorExampleInput(
        this.config,
        this.example,
        value,
        this.inputDescription,
        this.outputJson,
        this.outputDescription);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnectorExampleInput#getInputDescription() inputDescription} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inputDescription (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnectorExampleInput withInputDescription(@Nullable String value) {
    if (Objects.equals(this.inputDescription, value)) return this;
    return new ImmutableSinkConnectorExampleInput(this.config, this.example, this.inputJson, value, this.outputJson, this.outputDescription);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnectorExampleInput#getOutputJson() outputJson} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputJson (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnectorExampleInput withOutputJson(@Nullable String value) {
    if (Objects.equals(this.outputJson, value)) return this;
    return new ImmutableSinkConnectorExampleInput(this.config, this.example, this.inputJson, this.inputDescription, value, this.outputDescription);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SinkConnectorExampleInput#getOutputDescription() outputDescription} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputDescription (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSinkConnectorExampleInput withOutputDescription(@Nullable String value) {
    if (Objects.equals(this.outputDescription, value)) return this;
    return new ImmutableSinkConnectorExampleInput(this.config, this.example, this.inputJson, this.inputDescription, this.outputJson, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSinkConnectorExampleInput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSinkConnectorExampleInput
        && equalTo((ImmutableSinkConnectorExampleInput) another);
  }

  private boolean equalTo(ImmutableSinkConnectorExampleInput another) {
    return Objects.equals(config, another.config)
        && example.equals(another.example)
        && Objects.equals(inputJson, another.inputJson)
        && Objects.equals(inputDescription, another.inputDescription)
        && Objects.equals(outputJson, another.outputJson)
        && Objects.equals(outputDescription, another.outputDescription);
  }

  /**
   * Computes a hash code from attributes: {@code config}, {@code example}, {@code inputJson}, {@code inputDescription}, {@code outputJson}, {@code outputDescription}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(config);
    h += (h << 5) + example.hashCode();
    h += (h << 5) + Objects.hashCode(inputJson);
    h += (h << 5) + Objects.hashCode(inputDescription);
    h += (h << 5) + Objects.hashCode(outputJson);
    h += (h << 5) + Objects.hashCode(outputDescription);
    return h;
  }

  /**
   * Prints the immutable value {@code SinkConnectorExampleInput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SinkConnectorExampleInput")
        .omitNullValues()
        .add("config", config)
        .add("example", example)
        .add("inputJson", inputJson)
        .add("inputDescription", inputDescription)
        .add("outputJson", outputJson)
        .add("outputDescription", outputDescription)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.SinkConnectorExampleInput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SinkConnectorExampleInput instance
   */
  public static ImmutableSinkConnectorExampleInput copyOf(Plugin.SinkConnectorExampleInput instance) {
    if (instance instanceof ImmutableSinkConnectorExampleInput) {
      return (ImmutableSinkConnectorExampleInput) instance;
    }
    return ImmutableSinkConnectorExampleInput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSinkConnectorExampleInput ImmutableSinkConnectorExampleInput}.
   * <pre>
   * ImmutableSinkConnectorExampleInput.builder()
   *    .config(String | null) // nullable {@link Plugin.SinkConnectorExampleInput#getConfig() config}
   *    .example(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SinkConnectorExample) // required {@link Plugin.SinkConnectorExampleInput#getExample() example}
   *    .inputJson(String | null) // nullable {@link Plugin.SinkConnectorExampleInput#getInputJson() inputJson}
   *    .inputDescription(String | null) // nullable {@link Plugin.SinkConnectorExampleInput#getInputDescription() inputDescription}
   *    .outputJson(String | null) // nullable {@link Plugin.SinkConnectorExampleInput#getOutputJson() outputJson}
   *    .outputDescription(String | null) // nullable {@link Plugin.SinkConnectorExampleInput#getOutputDescription() outputDescription}
   *    .build();
   * </pre>
   * @return A new ImmutableSinkConnectorExampleInput builder
   */
  public static ImmutableSinkConnectorExampleInput.Builder builder() {
    return new ImmutableSinkConnectorExampleInput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSinkConnectorExampleInput ImmutableSinkConnectorExampleInput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.SinkConnectorExampleInput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXAMPLE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String config;
    private @Nullable Plugin.SinkConnectorExample example;
    private @Nullable String inputJson;
    private @Nullable String inputDescription;
    private @Nullable String outputJson;
    private @Nullable String outputDescription;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SinkConnectorExampleInput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.SinkConnectorExampleInput instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String configValue = instance.getConfig();
      if (configValue != null) {
        config(configValue);
      }
      example(instance.getExample());
      @Nullable String inputJsonValue = instance.getInputJson();
      if (inputJsonValue != null) {
        inputJson(inputJsonValue);
      }
      @Nullable String inputDescriptionValue = instance.getInputDescription();
      if (inputDescriptionValue != null) {
        inputDescription(inputDescriptionValue);
      }
      @Nullable String outputJsonValue = instance.getOutputJson();
      if (outputJsonValue != null) {
        outputJson(outputJsonValue);
      }
      @Nullable String outputDescriptionValue = instance.getOutputDescription();
      if (outputDescriptionValue != null) {
        outputDescription(outputDescriptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnectorExampleInput#getConfig() config} attribute.
     * @param config The value for config (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder config(@Nullable String config) {
      this.config = config;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnectorExampleInput#getExample() example} attribute.
     * @param example The value for example 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder example(Plugin.SinkConnectorExample example) {
      this.example = Objects.requireNonNull(example, "example");
      initBits &= ~INIT_BIT_EXAMPLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnectorExampleInput#getInputJson() inputJson} attribute.
     * @param inputJson The value for inputJson (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder inputJson(@Nullable String inputJson) {
      this.inputJson = inputJson;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnectorExampleInput#getInputDescription() inputDescription} attribute.
     * @param inputDescription The value for inputDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder inputDescription(@Nullable String inputDescription) {
      this.inputDescription = inputDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnectorExampleInput#getOutputJson() outputJson} attribute.
     * @param outputJson The value for outputJson (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder outputJson(@Nullable String outputJson) {
      this.outputJson = outputJson;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SinkConnectorExampleInput#getOutputDescription() outputDescription} attribute.
     * @param outputDescription The value for outputDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder outputDescription(@Nullable String outputDescription) {
      this.outputDescription = outputDescription;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSinkConnectorExampleInput ImmutableSinkConnectorExampleInput}.
     * @return An immutable instance of SinkConnectorExampleInput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSinkConnectorExampleInput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSinkConnectorExampleInput(config, example, inputJson, inputDescription, outputJson, outputDescription);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXAMPLE) != 0) attributes.add("example");
      return "Cannot build SinkConnectorExampleInput, some of required attributes are not set " + attributes;
    }
  }
}
