package com.github.jcustenborder.kafka.connect.utils.templates;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.connect.source.SourceRecord;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.SourceConnectorExample}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSourceConnectorExample.builder()}.
 */
@Generated(from = "Plugin.SourceConnectorExample", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSourceConnectorExample
    implements Plugin.SourceConnectorExample {
  private final @Nullable String warning;
  private final @Nullable String tip;
  private final @Nullable String important;
  private final @Nullable String danger;
  private final @Nullable String note;
  private final @Nullable String title;
  private final @Nullable String description;
  private final @Nullable String icon;
  private final @Nullable String introduction;
  private final String name;
  private final Map<String, String> config;
  private final Map<String, Map<String, String>> transformations;
  private final @Nullable SourceRecord output;

  private ImmutableSourceConnectorExample(
      @Nullable String warning,
      @Nullable String tip,
      @Nullable String important,
      @Nullable String danger,
      @Nullable String note,
      @Nullable String title,
      @Nullable String description,
      @Nullable String icon,
      @Nullable String introduction,
      String name,
      Map<String, String> config,
      Map<String, Map<String, String>> transformations,
      @Nullable SourceRecord output) {
    this.warning = warning;
    this.tip = tip;
    this.important = important;
    this.danger = danger;
    this.note = note;
    this.title = title;
    this.description = description;
    this.icon = icon;
    this.introduction = introduction;
    this.name = name;
    this.config = config;
    this.transformations = transformations;
    this.output = output;
  }

  /**
   * @return The value of the {@code warning} attribute
   */
  @JsonProperty("warning")
  @Override
  public @Nullable String getWarning() {
    return warning;
  }

  /**
   * @return The value of the {@code tip} attribute
   */
  @JsonProperty("tip")
  @Override
  public @Nullable String getTip() {
    return tip;
  }

  /**
   * @return The value of the {@code important} attribute
   */
  @JsonProperty("important")
  @Override
  public @Nullable String getImportant() {
    return important;
  }

  /**
   * @return The value of the {@code danger} attribute
   */
  @JsonProperty("danger")
  @Override
  public @Nullable String getDanger() {
    return danger;
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @JsonProperty("note")
  @Override
  public @Nullable String getNote() {
    return note;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty("title")
  @Override
  public @Nullable String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @JsonProperty("icon")
  @Override
  public @Nullable String getIcon() {
    return icon;
  }

  /**
   * @return The value of the {@code introduction} attribute
   */
  @JsonProperty("introduction")
  @Override
  public @Nullable String getIntroduction() {
    return introduction;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public Map<String, String> getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code transformations} attribute
   */
  @JsonProperty("transformations")
  @Override
  public Map<String, Map<String, String>> transformations() {
    return transformations;
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @JsonProperty("output")
  @Override
  public @Nullable SourceRecord getOutput() {
    return output;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getWarning() warning} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for warning (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withWarning(@Nullable String value) {
    if (Objects.equals(this.warning, value)) return this;
    return new ImmutableSourceConnectorExample(
        value,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getTip() tip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withTip(@Nullable String value) {
    if (Objects.equals(this.tip, value)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        value,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getImportant() important} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for important (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withImportant(@Nullable String value) {
    if (Objects.equals(this.important, value)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        value,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getDanger() danger} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for danger (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withDanger(@Nullable String value) {
    if (Objects.equals(this.danger, value)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        value,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getNote() note} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for note (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withNote(@Nullable String value) {
    if (Objects.equals(this.note, value)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        value,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        value,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        value,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getIcon() icon} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withIcon(@Nullable String value) {
    if (Objects.equals(this.icon, value)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        value,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getIntroduction() introduction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for introduction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withIntroduction(@Nullable String value) {
    if (Objects.equals(this.introduction, value)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        value,
        this.name,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        newValue,
        this.config,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by replacing the {@link Plugin.SourceConnectorExample#getConfig() config} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the config map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSourceConnectorExample withConfig(Map<String, ? extends String> entries) {
    if (this.config == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        newValue,
        this.transformations,
        this.output);
  }

  /**
   * Copy the current immutable object by replacing the {@link Plugin.SourceConnectorExample#transformations() transformations} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the transformations map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSourceConnectorExample withTransformations(Map<String, ? extends Map<String, String>> entries) {
    if (this.transformations == entries) return this;
    Map<String, Map<String, String>> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        newValue,
        this.output);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExample#getOutput() output} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for output (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExample withOutput(@Nullable SourceRecord value) {
    if (this.output == value) return this;
    return new ImmutableSourceConnectorExample(
        this.warning,
        this.tip,
        this.important,
        this.danger,
        this.note,
        this.title,
        this.description,
        this.icon,
        this.introduction,
        this.name,
        this.config,
        this.transformations,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSourceConnectorExample} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSourceConnectorExample
        && equalTo((ImmutableSourceConnectorExample) another);
  }

  private boolean equalTo(ImmutableSourceConnectorExample another) {
    return Objects.equals(warning, another.warning)
        && Objects.equals(tip, another.tip)
        && Objects.equals(important, another.important)
        && Objects.equals(danger, another.danger)
        && Objects.equals(note, another.note)
        && Objects.equals(title, another.title)
        && Objects.equals(description, another.description)
        && Objects.equals(icon, another.icon)
        && Objects.equals(introduction, another.introduction)
        && name.equals(another.name)
        && config.equals(another.config)
        && transformations.equals(another.transformations)
        && Objects.equals(output, another.output);
  }

  /**
   * Computes a hash code from attributes: {@code warning}, {@code tip}, {@code important}, {@code danger}, {@code note}, {@code title}, {@code description}, {@code icon}, {@code introduction}, {@code name}, {@code config}, {@code transformations}, {@code output}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(warning);
    h += (h << 5) + Objects.hashCode(tip);
    h += (h << 5) + Objects.hashCode(important);
    h += (h << 5) + Objects.hashCode(danger);
    h += (h << 5) + Objects.hashCode(note);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + Objects.hashCode(introduction);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + config.hashCode();
    h += (h << 5) + transformations.hashCode();
    h += (h << 5) + Objects.hashCode(output);
    return h;
  }

  /**
   * Prints the immutable value {@code SourceConnectorExample} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SourceConnectorExample{"
        + "warning=" + warning
        + ", tip=" + tip
        + ", important=" + important
        + ", danger=" + danger
        + ", note=" + note
        + ", title=" + title
        + ", description=" + description
        + ", icon=" + icon
        + ", introduction=" + introduction
        + ", name=" + name
        + ", config=" + config
        + ", transformations=" + transformations
        + ", output=" + output
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Plugin.SourceConnectorExample", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Plugin.SourceConnectorExample {
    @Nullable String warning;
    @Nullable String tip;
    @Nullable String important;
    @Nullable String danger;
    @Nullable String note;
    @Nullable String title;
    @Nullable String description;
    @Nullable String icon;
    @Nullable String introduction;
    @Nullable String name;
    @Nullable Map<String, String> config = Collections.emptyMap();
    @Nullable Map<String, Map<String, String>> transformations = Collections.emptyMap();
    @Nullable SourceRecord output;
    @JsonProperty("warning")
    public void setWarning(@Nullable String warning) {
      this.warning = warning;
    }
    @JsonProperty("tip")
    public void setTip(@Nullable String tip) {
      this.tip = tip;
    }
    @JsonProperty("important")
    public void setImportant(@Nullable String important) {
      this.important = important;
    }
    @JsonProperty("danger")
    public void setDanger(@Nullable String danger) {
      this.danger = danger;
    }
    @JsonProperty("note")
    public void setNote(@Nullable String note) {
      this.note = note;
    }
    @JsonProperty("title")
    public void setTitle(@Nullable String title) {
      this.title = title;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("icon")
    public void setIcon(@Nullable String icon) {
      this.icon = icon;
    }
    @JsonProperty("introduction")
    public void setIntroduction(@Nullable String introduction) {
      this.introduction = introduction;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("config")
    public void setConfig(Map<String, String> config) {
      this.config = config;
    }
    @JsonProperty("transformations")
    public void setTransformations(Map<String, Map<String, String>> transformations) {
      this.transformations = transformations;
    }
    @JsonProperty("output")
    public void setOutput(@Nullable SourceRecord output) {
      this.output = output;
    }
    @Override
    public String getWarning() { throw new UnsupportedOperationException(); }
    @Override
    public String getTip() { throw new UnsupportedOperationException(); }
    @Override
    public String getImportant() { throw new UnsupportedOperationException(); }
    @Override
    public String getDanger() { throw new UnsupportedOperationException(); }
    @Override
    public String getNote() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getIcon() { throw new UnsupportedOperationException(); }
    @Override
    public String getIntroduction() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getConfig() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Map<String, String>> transformations() { throw new UnsupportedOperationException(); }
    @Override
    public SourceRecord getOutput() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSourceConnectorExample fromJson(Json json) {
    ImmutableSourceConnectorExample.Builder builder = ImmutableSourceConnectorExample.builder();
    if (json.warning != null) {
      builder.warning(json.warning);
    }
    if (json.tip != null) {
      builder.tip(json.tip);
    }
    if (json.important != null) {
      builder.important(json.important);
    }
    if (json.danger != null) {
      builder.danger(json.danger);
    }
    if (json.note != null) {
      builder.note(json.note);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.icon != null) {
      builder.icon(json.icon);
    }
    if (json.introduction != null) {
      builder.introduction(json.introduction);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.config != null) {
      builder.putAllConfig(json.config);
    }
    if (json.transformations != null) {
      builder.putAllTransformations(json.transformations);
    }
    if (json.output != null) {
      builder.output(json.output);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.SourceConnectorExample} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SourceConnectorExample instance
   */
  public static ImmutableSourceConnectorExample copyOf(Plugin.SourceConnectorExample instance) {
    if (instance instanceof ImmutableSourceConnectorExample) {
      return (ImmutableSourceConnectorExample) instance;
    }
    return ImmutableSourceConnectorExample.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSourceConnectorExample ImmutableSourceConnectorExample}.
   * <pre>
   * ImmutableSourceConnectorExample.builder()
   *    .warning(String | null) // nullable {@link Plugin.SourceConnectorExample#getWarning() warning}
   *    .tip(String | null) // nullable {@link Plugin.SourceConnectorExample#getTip() tip}
   *    .important(String | null) // nullable {@link Plugin.SourceConnectorExample#getImportant() important}
   *    .danger(String | null) // nullable {@link Plugin.SourceConnectorExample#getDanger() danger}
   *    .note(String | null) // nullable {@link Plugin.SourceConnectorExample#getNote() note}
   *    .title(String | null) // nullable {@link Plugin.SourceConnectorExample#getTitle() title}
   *    .description(String | null) // nullable {@link Plugin.SourceConnectorExample#getDescription() description}
   *    .icon(String | null) // nullable {@link Plugin.SourceConnectorExample#getIcon() icon}
   *    .introduction(String | null) // nullable {@link Plugin.SourceConnectorExample#getIntroduction() introduction}
   *    .name(String) // required {@link Plugin.SourceConnectorExample#getName() name}
   *    .putConfig|putAllConfig(String =&gt; String) // {@link Plugin.SourceConnectorExample#getConfig() config} mappings
   *    .putTransformations|putAllTransformations(String =&gt; Map&amp;lt;String, String&amp;gt;) // {@link Plugin.SourceConnectorExample#transformations() transformations} mappings
   *    .output(org.apache.kafka.connect.source.SourceRecord | null) // nullable {@link Plugin.SourceConnectorExample#getOutput() output}
   *    .build();
   * </pre>
   * @return A new ImmutableSourceConnectorExample builder
   */
  public static ImmutableSourceConnectorExample.Builder builder() {
    return new ImmutableSourceConnectorExample.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSourceConnectorExample ImmutableSourceConnectorExample}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.SourceConnectorExample", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String warning;
    private @Nullable String tip;
    private @Nullable String important;
    private @Nullable String danger;
    private @Nullable String note;
    private @Nullable String title;
    private @Nullable String description;
    private @Nullable String icon;
    private @Nullable String introduction;
    private @Nullable String name;
    private Map<String, String> config = new LinkedHashMap<String, String>();
    private Map<String, Map<String, String>> transformations = new LinkedHashMap<String, Map<String, String>>();
    private @Nullable SourceRecord output;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Notes} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Notes instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Plugin.ConnectorExample} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.ConnectorExample instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Plugin.Example} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.Example instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SourceConnectorExample} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.SourceConnectorExample instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Notes) {
        Notes instance = (Notes) object;
        @Nullable String importantValue = instance.getImportant();
        if (importantValue != null) {
          important(importantValue);
        }
        @Nullable String noteValue = instance.getNote();
        if (noteValue != null) {
          note(noteValue);
        }
        @Nullable String iconValue = instance.getIcon();
        if (iconValue != null) {
          icon(iconValue);
        }
        @Nullable String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String warningValue = instance.getWarning();
        if (warningValue != null) {
          warning(warningValue);
        }
        @Nullable String tipValue = instance.getTip();
        if (tipValue != null) {
          tip(tipValue);
        }
        @Nullable String dangerValue = instance.getDanger();
        if (dangerValue != null) {
          danger(dangerValue);
        }
        @Nullable String titleValue = instance.getTitle();
        if (titleValue != null) {
          title(titleValue);
        }
        @Nullable String introductionValue = instance.getIntroduction();
        if (introductionValue != null) {
          introduction(introductionValue);
        }
      }
      if (object instanceof Plugin.ConnectorExample) {
        Plugin.ConnectorExample instance = (Plugin.ConnectorExample) object;
        putAllTransformations(instance.transformations());
      }
      if (object instanceof Plugin.Example) {
        Plugin.Example instance = (Plugin.Example) object;
        name(instance.getName());
        putAllConfig(instance.getConfig());
      }
      if (object instanceof Plugin.SourceConnectorExample) {
        Plugin.SourceConnectorExample instance = (Plugin.SourceConnectorExample) object;
        @Nullable SourceRecord outputValue = instance.getOutput();
        if (outputValue != null) {
          output(outputValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getWarning() warning} attribute.
     * @param warning The value for warning (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("warning")
    public final Builder warning(@Nullable String warning) {
      this.warning = warning;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getTip() tip} attribute.
     * @param tip The value for tip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tip")
    public final Builder tip(@Nullable String tip) {
      this.tip = tip;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getImportant() important} attribute.
     * @param important The value for important (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("important")
    public final Builder important(@Nullable String important) {
      this.important = important;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getDanger() danger} attribute.
     * @param danger The value for danger (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("danger")
    public final Builder danger(@Nullable String danger) {
      this.danger = danger;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getNote() note} attribute.
     * @param note The value for note (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("note")
    public final Builder note(@Nullable String note) {
      this.note = note;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getTitle() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("title")
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getIcon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("icon")
    public final Builder icon(@Nullable String icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getIntroduction() introduction} attribute.
     * @param introduction The value for introduction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("introduction")
    public final Builder introduction(@Nullable String introduction) {
      this.introduction = introduction;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Put one entry to the {@link Plugin.SourceConnectorExample#getConfig() config} map.
     * @param key The key in the config map
     * @param value The associated value in the config map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putConfig(String key, String value) {
      this.config.put(
          Objects.requireNonNull(key, "config key"),
          Objects.requireNonNull(value, "config value"));
      return this;
    }

    /**
     * Put one entry to the {@link Plugin.SourceConnectorExample#getConfig() config} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.config.put(
          Objects.requireNonNull(k, "config key"),
          Objects.requireNonNull(v, "config value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Plugin.SourceConnectorExample#getConfig() config} map. Nulls are not permitted
     * @param entries The entries that will be added to the config map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("config")
    public final Builder config(Map<String, ? extends String> entries) {
      this.config.clear();
      return putAllConfig(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Plugin.SourceConnectorExample#getConfig() config} map. Nulls are not permitted
     * @param entries The entries that will be added to the config map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllConfig(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.config.put(
            Objects.requireNonNull(k, "config key"),
            Objects.requireNonNull(v, "config value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Plugin.SourceConnectorExample#transformations() transformations} map.
     * @param key The key in the transformations map
     * @param value The associated value in the transformations map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTransformations(String key, Map<String, String> value) {
      this.transformations.put(
          Objects.requireNonNull(key, "transformations key"),
          Objects.requireNonNull(value, "transformations value"));
      return this;
    }

    /**
     * Put one entry to the {@link Plugin.SourceConnectorExample#transformations() transformations} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTransformations(Map.Entry<String, ? extends Map<String, String>> entry) {
      String k = entry.getKey();
      Map<String, String> v = entry.getValue();
      this.transformations.put(
          Objects.requireNonNull(k, "transformations key"),
          Objects.requireNonNull(v, "transformations value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Plugin.SourceConnectorExample#transformations() transformations} map. Nulls are not permitted
     * @param entries The entries that will be added to the transformations map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("transformations")
    public final Builder transformations(Map<String, ? extends Map<String, String>> entries) {
      this.transformations.clear();
      return putAllTransformations(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Plugin.SourceConnectorExample#transformations() transformations} map. Nulls are not permitted
     * @param entries The entries that will be added to the transformations map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTransformations(Map<String, ? extends Map<String, String>> entries) {
      for (Map.Entry<String, ? extends Map<String, String>> e : entries.entrySet()) {
        String k = e.getKey();
        Map<String, String> v = e.getValue();
        this.transformations.put(
            Objects.requireNonNull(k, "transformations key"),
            Objects.requireNonNull(v, "transformations value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExample#getOutput() output} attribute.
     * @param output The value for output (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("output")
    public final Builder output(@Nullable SourceRecord output) {
      this.output = output;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSourceConnectorExample ImmutableSourceConnectorExample}.
     * @return An immutable instance of SourceConnectorExample
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSourceConnectorExample build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSourceConnectorExample(
          warning,
          tip,
          important,
          danger,
          note,
          title,
          description,
          icon,
          introduction,
          name,
          createUnmodifiableMap(false, false, config),
          createUnmodifiableMap(false, false, transformations),
          output);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build SourceConnectorExample, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
