package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.SourceConnectorExampleInput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSourceConnectorExampleInput.builder()}.
 */
@Generated(from = "Plugin.SourceConnectorExampleInput", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSourceConnectorExampleInput
    implements Plugin.SourceConnectorExampleInput {
  private final @Nullable String config;
  private final Plugin.SourceConnectorExample example;
  private final @Nullable String outputJson;
  private final @Nullable String outputDescription;

  private ImmutableSourceConnectorExampleInput(
      @Nullable String config,
      Plugin.SourceConnectorExample example,
      @Nullable String outputJson,
      @Nullable String outputDescription) {
    this.config = config;
    this.example = example;
    this.outputJson = outputJson;
    this.outputDescription = outputDescription;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @Override
  public @Nullable String getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code example} attribute
   */
  @Override
  public Plugin.SourceConnectorExample getExample() {
    return example;
  }

  /**
   * @return The value of the {@code outputJson} attribute
   */
  @Override
  public @Nullable String getOutputJson() {
    return outputJson;
  }

  /**
   * @return The value of the {@code outputDescription} attribute
   */
  @Override
  public @Nullable String getOutputDescription() {
    return outputDescription;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExampleInput#getConfig() config} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExampleInput withConfig(@Nullable String value) {
    if (Objects.equals(this.config, value)) return this;
    return new ImmutableSourceConnectorExampleInput(value, this.example, this.outputJson, this.outputDescription);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExampleInput#getExample() example} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for example
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExampleInput withExample(Plugin.SourceConnectorExample value) {
    if (this.example == value) return this;
    Plugin.SourceConnectorExample newValue = Objects.requireNonNull(value, "example");
    return new ImmutableSourceConnectorExampleInput(this.config, newValue, this.outputJson, this.outputDescription);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExampleInput#getOutputJson() outputJson} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputJson (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExampleInput withOutputJson(@Nullable String value) {
    if (Objects.equals(this.outputJson, value)) return this;
    return new ImmutableSourceConnectorExampleInput(this.config, this.example, value, this.outputDescription);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.SourceConnectorExampleInput#getOutputDescription() outputDescription} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputDescription (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceConnectorExampleInput withOutputDescription(@Nullable String value) {
    if (Objects.equals(this.outputDescription, value)) return this;
    return new ImmutableSourceConnectorExampleInput(this.config, this.example, this.outputJson, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSourceConnectorExampleInput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSourceConnectorExampleInput
        && equalTo((ImmutableSourceConnectorExampleInput) another);
  }

  private boolean equalTo(ImmutableSourceConnectorExampleInput another) {
    return Objects.equals(config, another.config)
        && example.equals(another.example)
        && Objects.equals(outputJson, another.outputJson)
        && Objects.equals(outputDescription, another.outputDescription);
  }

  /**
   * Computes a hash code from attributes: {@code config}, {@code example}, {@code outputJson}, {@code outputDescription}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(config);
    h += (h << 5) + example.hashCode();
    h += (h << 5) + Objects.hashCode(outputJson);
    h += (h << 5) + Objects.hashCode(outputDescription);
    return h;
  }

  /**
   * Prints the immutable value {@code SourceConnectorExampleInput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SourceConnectorExampleInput")
        .omitNullValues()
        .add("config", config)
        .add("example", example)
        .add("outputJson", outputJson)
        .add("outputDescription", outputDescription)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.SourceConnectorExampleInput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SourceConnectorExampleInput instance
   */
  public static ImmutableSourceConnectorExampleInput copyOf(Plugin.SourceConnectorExampleInput instance) {
    if (instance instanceof ImmutableSourceConnectorExampleInput) {
      return (ImmutableSourceConnectorExampleInput) instance;
    }
    return ImmutableSourceConnectorExampleInput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSourceConnectorExampleInput ImmutableSourceConnectorExampleInput}.
   * <pre>
   * ImmutableSourceConnectorExampleInput.builder()
   *    .config(String | null) // nullable {@link Plugin.SourceConnectorExampleInput#getConfig() config}
   *    .example(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.SourceConnectorExample) // required {@link Plugin.SourceConnectorExampleInput#getExample() example}
   *    .outputJson(String | null) // nullable {@link Plugin.SourceConnectorExampleInput#getOutputJson() outputJson}
   *    .outputDescription(String | null) // nullable {@link Plugin.SourceConnectorExampleInput#getOutputDescription() outputDescription}
   *    .build();
   * </pre>
   * @return A new ImmutableSourceConnectorExampleInput builder
   */
  public static ImmutableSourceConnectorExampleInput.Builder builder() {
    return new ImmutableSourceConnectorExampleInput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSourceConnectorExampleInput ImmutableSourceConnectorExampleInput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.SourceConnectorExampleInput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXAMPLE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String config;
    private @Nullable Plugin.SourceConnectorExample example;
    private @Nullable String outputJson;
    private @Nullable String outputDescription;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SourceConnectorExampleInput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.SourceConnectorExampleInput instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String configValue = instance.getConfig();
      if (configValue != null) {
        config(configValue);
      }
      example(instance.getExample());
      @Nullable String outputJsonValue = instance.getOutputJson();
      if (outputJsonValue != null) {
        outputJson(outputJsonValue);
      }
      @Nullable String outputDescriptionValue = instance.getOutputDescription();
      if (outputDescriptionValue != null) {
        outputDescription(outputDescriptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExampleInput#getConfig() config} attribute.
     * @param config The value for config (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder config(@Nullable String config) {
      this.config = config;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExampleInput#getExample() example} attribute.
     * @param example The value for example 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder example(Plugin.SourceConnectorExample example) {
      this.example = Objects.requireNonNull(example, "example");
      initBits &= ~INIT_BIT_EXAMPLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExampleInput#getOutputJson() outputJson} attribute.
     * @param outputJson The value for outputJson (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder outputJson(@Nullable String outputJson) {
      this.outputJson = outputJson;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.SourceConnectorExampleInput#getOutputDescription() outputDescription} attribute.
     * @param outputDescription The value for outputDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder outputDescription(@Nullable String outputDescription) {
      this.outputDescription = outputDescription;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSourceConnectorExampleInput ImmutableSourceConnectorExampleInput}.
     * @return An immutable instance of SourceConnectorExampleInput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSourceConnectorExampleInput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSourceConnectorExampleInput(config, example, outputJson, outputDescription);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXAMPLE) != 0) attributes.add("example");
      return "Cannot build SourceConnectorExampleInput, some of required attributes are not set " + attributes;
    }
  }
}
