package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Plugin.TransformationExampleInput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransformationExampleInput.builder()}.
 */
@Generated(from = "Plugin.TransformationExampleInput", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTransformationExampleInput
    implements Plugin.TransformationExampleInput {
  private final @Nullable String config;
  private final ImmutableList<Integer> inputEmphasizeLines;
  private final @Nullable String inputJson;
  private final ImmutableList<Integer> outputEmphasizeLines;
  private final @Nullable String outputJson;
  private final Plugin.TransformationExample example;

  private ImmutableTransformationExampleInput(
      @Nullable String config,
      ImmutableList<Integer> inputEmphasizeLines,
      @Nullable String inputJson,
      ImmutableList<Integer> outputEmphasizeLines,
      @Nullable String outputJson,
      Plugin.TransformationExample example) {
    this.config = config;
    this.inputEmphasizeLines = inputEmphasizeLines;
    this.inputJson = inputJson;
    this.outputEmphasizeLines = outputEmphasizeLines;
    this.outputJson = outputJson;
    this.example = example;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @Override
  public @Nullable String getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code inputEmphasizeLines} attribute
   */
  @Override
  public ImmutableList<Integer> getInputEmphasizeLines() {
    return inputEmphasizeLines;
  }

  /**
   * @return The value of the {@code inputJson} attribute
   */
  @Override
  public @Nullable String getInputJson() {
    return inputJson;
  }

  /**
   * @return The value of the {@code outputEmphasizeLines} attribute
   */
  @Override
  public ImmutableList<Integer> getOutputEmphasizeLines() {
    return outputEmphasizeLines;
  }

  /**
   * @return The value of the {@code outputJson} attribute
   */
  @Override
  public @Nullable String getOutputJson() {
    return outputJson;
  }

  /**
   * @return The value of the {@code example} attribute
   */
  @Override
  public Plugin.TransformationExample getExample() {
    return example;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.TransformationExampleInput#getConfig() config} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransformationExampleInput withConfig(@Nullable String value) {
    if (Objects.equals(this.config, value)) return this;
    return new ImmutableTransformationExampleInput(
        value,
        this.inputEmphasizeLines,
        this.inputJson,
        this.outputEmphasizeLines,
        this.outputJson,
        this.example);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.TransformationExampleInput#getInputEmphasizeLines() inputEmphasizeLines}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransformationExampleInput withInputEmphasizeLines(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableTransformationExampleInput(this.config, newValue, this.inputJson, this.outputEmphasizeLines, this.outputJson, this.example);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.TransformationExampleInput#getInputEmphasizeLines() inputEmphasizeLines}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of inputEmphasizeLines elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransformationExampleInput withInputEmphasizeLines(Iterable<Integer> elements) {
    if (this.inputEmphasizeLines == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTransformationExampleInput(this.config, newValue, this.inputJson, this.outputEmphasizeLines, this.outputJson, this.example);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.TransformationExampleInput#getInputJson() inputJson} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inputJson (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransformationExampleInput withInputJson(@Nullable String value) {
    if (Objects.equals(this.inputJson, value)) return this;
    return new ImmutableTransformationExampleInput(
        this.config,
        this.inputEmphasizeLines,
        value,
        this.outputEmphasizeLines,
        this.outputJson,
        this.example);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.TransformationExampleInput#getOutputEmphasizeLines() outputEmphasizeLines}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransformationExampleInput withOutputEmphasizeLines(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableTransformationExampleInput(this.config, this.inputEmphasizeLines, this.inputJson, newValue, this.outputJson, this.example);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Plugin.TransformationExampleInput#getOutputEmphasizeLines() outputEmphasizeLines}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of outputEmphasizeLines elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransformationExampleInput withOutputEmphasizeLines(Iterable<Integer> elements) {
    if (this.outputEmphasizeLines == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTransformationExampleInput(this.config, this.inputEmphasizeLines, this.inputJson, newValue, this.outputJson, this.example);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.TransformationExampleInput#getOutputJson() outputJson} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputJson (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransformationExampleInput withOutputJson(@Nullable String value) {
    if (Objects.equals(this.outputJson, value)) return this;
    return new ImmutableTransformationExampleInput(
        this.config,
        this.inputEmphasizeLines,
        this.inputJson,
        this.outputEmphasizeLines,
        value,
        this.example);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Plugin.TransformationExampleInput#getExample() example} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for example
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransformationExampleInput withExample(Plugin.TransformationExample value) {
    if (this.example == value) return this;
    Plugin.TransformationExample newValue = Objects.requireNonNull(value, "example");
    return new ImmutableTransformationExampleInput(
        this.config,
        this.inputEmphasizeLines,
        this.inputJson,
        this.outputEmphasizeLines,
        this.outputJson,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransformationExampleInput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransformationExampleInput
        && equalTo((ImmutableTransformationExampleInput) another);
  }

  private boolean equalTo(ImmutableTransformationExampleInput another) {
    return Objects.equals(config, another.config)
        && inputEmphasizeLines.equals(another.inputEmphasizeLines)
        && Objects.equals(inputJson, another.inputJson)
        && outputEmphasizeLines.equals(another.outputEmphasizeLines)
        && Objects.equals(outputJson, another.outputJson)
        && example.equals(another.example);
  }

  /**
   * Computes a hash code from attributes: {@code config}, {@code inputEmphasizeLines}, {@code inputJson}, {@code outputEmphasizeLines}, {@code outputJson}, {@code example}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(config);
    h += (h << 5) + inputEmphasizeLines.hashCode();
    h += (h << 5) + Objects.hashCode(inputJson);
    h += (h << 5) + outputEmphasizeLines.hashCode();
    h += (h << 5) + Objects.hashCode(outputJson);
    h += (h << 5) + example.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TransformationExampleInput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransformationExampleInput")
        .omitNullValues()
        .add("config", config)
        .add("inputEmphasizeLines", inputEmphasizeLines)
        .add("inputJson", inputJson)
        .add("outputEmphasizeLines", outputEmphasizeLines)
        .add("outputJson", outputJson)
        .add("example", example)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Plugin.TransformationExampleInput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransformationExampleInput instance
   */
  public static ImmutableTransformationExampleInput copyOf(Plugin.TransformationExampleInput instance) {
    if (instance instanceof ImmutableTransformationExampleInput) {
      return (ImmutableTransformationExampleInput) instance;
    }
    return ImmutableTransformationExampleInput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransformationExampleInput ImmutableTransformationExampleInput}.
   * <pre>
   * ImmutableTransformationExampleInput.builder()
   *    .config(String | null) // nullable {@link Plugin.TransformationExampleInput#getConfig() config}
   *    .addInputEmphasizeLines|addAllInputEmphasizeLines(int) // {@link Plugin.TransformationExampleInput#getInputEmphasizeLines() inputEmphasizeLines} elements
   *    .inputJson(String | null) // nullable {@link Plugin.TransformationExampleInput#getInputJson() inputJson}
   *    .addOutputEmphasizeLines|addAllOutputEmphasizeLines(int) // {@link Plugin.TransformationExampleInput#getOutputEmphasizeLines() outputEmphasizeLines} elements
   *    .outputJson(String | null) // nullable {@link Plugin.TransformationExampleInput#getOutputJson() outputJson}
   *    .example(com.github.jcustenborder.kafka.connect.utils.templates.Plugin.TransformationExample) // required {@link Plugin.TransformationExampleInput#getExample() example}
   *    .build();
   * </pre>
   * @return A new ImmutableTransformationExampleInput builder
   */
  public static ImmutableTransformationExampleInput.Builder builder() {
    return new ImmutableTransformationExampleInput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransformationExampleInput ImmutableTransformationExampleInput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Plugin.TransformationExampleInput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXAMPLE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String config;
    private ImmutableList.Builder<Integer> inputEmphasizeLines = ImmutableList.builder();
    private @Nullable String inputJson;
    private ImmutableList.Builder<Integer> outputEmphasizeLines = ImmutableList.builder();
    private @Nullable String outputJson;
    private @Nullable Plugin.TransformationExample example;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransformationExampleInput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Plugin.TransformationExampleInput instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String configValue = instance.getConfig();
      if (configValue != null) {
        config(configValue);
      }
      addAllInputEmphasizeLines(instance.getInputEmphasizeLines());
      @Nullable String inputJsonValue = instance.getInputJson();
      if (inputJsonValue != null) {
        inputJson(inputJsonValue);
      }
      addAllOutputEmphasizeLines(instance.getOutputEmphasizeLines());
      @Nullable String outputJsonValue = instance.getOutputJson();
      if (outputJsonValue != null) {
        outputJson(outputJsonValue);
      }
      example(instance.getExample());
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.TransformationExampleInput#getConfig() config} attribute.
     * @param config The value for config (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder config(@Nullable String config) {
      this.config = config;
      return this;
    }

    /**
     * Adds one element to {@link Plugin.TransformationExampleInput#getInputEmphasizeLines() inputEmphasizeLines} list.
     * @param element A inputEmphasizeLines element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInputEmphasizeLines(int element) {
      this.inputEmphasizeLines.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin.TransformationExampleInput#getInputEmphasizeLines() inputEmphasizeLines} list.
     * @param elements An array of inputEmphasizeLines elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInputEmphasizeLines(int... elements) {
      this.inputEmphasizeLines.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin.TransformationExampleInput#getInputEmphasizeLines() inputEmphasizeLines} list.
     * @param elements An iterable of inputEmphasizeLines elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder inputEmphasizeLines(Iterable<Integer> elements) {
      this.inputEmphasizeLines = ImmutableList.builder();
      return addAllInputEmphasizeLines(elements);
    }

    /**
     * Adds elements to {@link Plugin.TransformationExampleInput#getInputEmphasizeLines() inputEmphasizeLines} list.
     * @param elements An iterable of inputEmphasizeLines elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInputEmphasizeLines(Iterable<Integer> elements) {
      this.inputEmphasizeLines.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.TransformationExampleInput#getInputJson() inputJson} attribute.
     * @param inputJson The value for inputJson (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder inputJson(@Nullable String inputJson) {
      this.inputJson = inputJson;
      return this;
    }

    /**
     * Adds one element to {@link Plugin.TransformationExampleInput#getOutputEmphasizeLines() outputEmphasizeLines} list.
     * @param element A outputEmphasizeLines element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOutputEmphasizeLines(int element) {
      this.outputEmphasizeLines.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Plugin.TransformationExampleInput#getOutputEmphasizeLines() outputEmphasizeLines} list.
     * @param elements An array of outputEmphasizeLines elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOutputEmphasizeLines(int... elements) {
      this.outputEmphasizeLines.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Plugin.TransformationExampleInput#getOutputEmphasizeLines() outputEmphasizeLines} list.
     * @param elements An iterable of outputEmphasizeLines elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder outputEmphasizeLines(Iterable<Integer> elements) {
      this.outputEmphasizeLines = ImmutableList.builder();
      return addAllOutputEmphasizeLines(elements);
    }

    /**
     * Adds elements to {@link Plugin.TransformationExampleInput#getOutputEmphasizeLines() outputEmphasizeLines} list.
     * @param elements An iterable of outputEmphasizeLines elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOutputEmphasizeLines(Iterable<Integer> elements) {
      this.outputEmphasizeLines.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.TransformationExampleInput#getOutputJson() outputJson} attribute.
     * @param outputJson The value for outputJson (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder outputJson(@Nullable String outputJson) {
      this.outputJson = outputJson;
      return this;
    }

    /**
     * Initializes the value for the {@link Plugin.TransformationExampleInput#getExample() example} attribute.
     * @param example The value for example 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder example(Plugin.TransformationExample example) {
      this.example = Objects.requireNonNull(example, "example");
      initBits &= ~INIT_BIT_EXAMPLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransformationExampleInput ImmutableTransformationExampleInput}.
     * @return An immutable instance of TransformationExampleInput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransformationExampleInput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransformationExampleInput(
          config,
          inputEmphasizeLines.build(),
          inputJson,
          outputEmphasizeLines.build(),
          outputJson,
          example);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXAMPLE) != 0) attributes.add("example");
      return "Cannot build TransformationExampleInput, some of required attributes are not set " + attributes;
    }
  }
}
