/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators;

import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

@Deprecated
public class ValidHostAndPort
implements ConfigDef.Validator {
    final Integer defaultPort;
    final boolean requireBracketsForIPv6;
    final boolean portRequired;

    private ValidHostAndPort(Integer defaultPort, boolean requireBracketsForIPv6, boolean portRequired) {
        this.defaultPort = defaultPort;
        this.requireBracketsForIPv6 = requireBracketsForIPv6;
        this.portRequired = portRequired;
    }

    public static ValidHostAndPort of() {
        return new ValidHostAndPort(null, false, true);
    }

    public static ValidHostAndPort of(Integer defaultPort, boolean requireBracketsForIPv6, boolean portRequired) {
        return new ValidHostAndPort(defaultPort, requireBracketsForIPv6, portRequired);
    }

    void validate(String setting, String input) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)input);
        if (this.requireBracketsForIPv6) {
            hostAndPort = hostAndPort.requireBracketsForIPv6();
        }
        if (null != this.defaultPort) {
            hostAndPort.withDefaultPort(this.defaultPort.intValue());
        }
        if (Strings.isNullOrEmpty((String)hostAndPort.getHost())) {
            throw new ConfigException(String.format("'%s'(%s) host cannot be blank or null.", setting, input));
        }
        if (this.portRequired && !hostAndPort.hasPort()) {
            throw new ConfigException(String.format("'%s'(%s) must specify a port.", setting, input));
        }
    }

    public void ensureValid(String setting, Object value) {
        if (value instanceof String) {
            String input = (String)value;
            this.validate(setting, input);
        } else if (value instanceof List) {
            List inputs = (List)value;
            for (String input : inputs) {
                this.validate(setting, input);
            }
        } else {
            throw new ConfigException(String.format("'%s' must be a String or List", setting));
        }
    }

    public String toString() {
        String result = this.portRequired ? "hostname:port" : "hostname[:port]";
        return result;
    }
}

