/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.xml;

import com.github.jcustenborder.kafka.connect.xml.AnnotationUtils;
import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class KafkaConnectPlugin
extends AbstractParameterizablePlugin {
    private static final Logger log = LoggerFactory.getLogger(KafkaConnectPlugin.class);
    private static final String CONNECT_SCHEMA_FIELD = "CONNECT_SCHEMA";
    JClass connectStructJClass;
    JClass connectTimestampJClass;
    JClass connectTimeJClass;
    JClass connectDateJClass;
    JClass connectDecimalJClass;
    JClass connectSchemaBuilderJClass;
    JClass connectSchemaJClass;
    JClass connectListOfStructJClass;
    JClass connectableJClass;
    JClass timezoneJClass;
    JClass typeList;
    JClass typeArrayList;
    JClass typeBigDecimal;
    JClass typeXMLGregorianCalendar;
    Map<JType, JExpression> typeLookup;
    static final String STRUCT_METHOD_NAME = "toConnectStruct";
    static final Class<?> CLASS_JNARROWED;
    static final Class<?> CLASS_JREFERENCEDCLASS;

    public String getOptionName() {
        return "Xconnect";
    }

    public String getUsage() {
        return "TBD";
    }

    JFieldVar processSchema(JCodeModel codeModel, ClassOutline classOutline, List<Field> fields) {
        JFieldVar schemaVariable = classOutline.implClass.field(25, (JType)this.connectSchemaJClass, CONNECT_SCHEMA_FIELD);
        JBlock constructorBlock = classOutline.implClass.init();
        JVar builderVar = constructorBlock.decl((JType)this.connectSchemaBuilderJClass, "builder", (JExpression)this.connectSchemaBuilderJClass.staticInvoke("struct"));
        String schemaName = String.format("%s.%s", classOutline._package()._package().name(), classOutline.implClass.name());
        constructorBlock.invoke((JExpression)builderVar, "name").arg(schemaName);
        constructorBlock.invoke((JExpression)builderVar, "optional");
        JVar fieldBuilderVar = constructorBlock.decl((JType)this.connectSchemaBuilderJClass, "fieldBuilder");
        for (Field field : fields) {
            if (field.type != Type.STRUCT) {
                constructorBlock.assign((JAssignmentTarget)fieldBuilderVar, field.schemaBuilder);
                if (!field.required) {
                    constructorBlock.invoke((JExpression)fieldBuilderVar, "optional");
                }
                constructorBlock.invoke((JExpression)builderVar, "field").arg(field.name).arg((JExpression)fieldBuilderVar.invoke("build"));
                continue;
            }
            constructorBlock.invoke((JExpression)builderVar, "field").arg(field.name).arg(field.schemaBuilder);
        }
        constructorBlock.assign((JAssignmentTarget)schemaVariable, (JExpression)builderVar.invoke("build"));
        return schemaVariable;
    }

    void setupImportedClasses(JCodeModel codeModel) {
        this.typeList = codeModel.ref(List.class);
        this.typeArrayList = codeModel.ref(ArrayList.class);
        this.connectStructJClass = codeModel.ref("org.apache.kafka.connect.data.Struct");
        this.connectListOfStructJClass = this.typeList.narrow(this.connectStructJClass);
        this.connectDateJClass = codeModel.ref("org.apache.kafka.connect.data.Date");
        this.connectTimeJClass = codeModel.ref("org.apache.kafka.connect.data.Time");
        this.connectDecimalJClass = codeModel.ref("org.apache.kafka.connect.data.Decimal");
        this.connectTimestampJClass = codeModel.ref("org.apache.kafka.connect.data.Timestamp");
        this.connectSchemaBuilderJClass = codeModel.ref("org.apache.kafka.connect.data.SchemaBuilder");
        this.connectSchemaJClass = codeModel.ref("org.apache.kafka.connect.data.Schema");
        this.connectableJClass = codeModel.ref("com.github.jcustenborder.kafka.connect.xml.Connectable");
        this.timezoneJClass = codeModel.ref(TimeZone.class);
        HashMap<JType, JExpression> typeLookup = new HashMap<JType, JExpression>();
        typeLookup.put((JType)JPrimitiveType.parse((JCodeModel)codeModel, (String)Boolean.TYPE.getName()), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("bool"));
        typeLookup.put((JType)codeModel.ref(Boolean.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("bool"));
        typeLookup.put((JType)JPrimitiveType.parse((JCodeModel)codeModel, (String)Float.TYPE.getName()), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("float32"));
        typeLookup.put((JType)codeModel.ref(Float.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("float32"));
        typeLookup.put((JType)JPrimitiveType.parse((JCodeModel)codeModel, (String)Double.TYPE.getName()), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("float64"));
        typeLookup.put((JType)codeModel.ref(Double.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("float64"));
        typeLookup.put((JType)JPrimitiveType.parse((JCodeModel)codeModel, (String)Byte.TYPE.getName()), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int8"));
        typeLookup.put((JType)codeModel.ref(Byte.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int8"));
        typeLookup.put((JType)JPrimitiveType.parse((JCodeModel)codeModel, (String)Short.TYPE.getName()), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int16"));
        typeLookup.put((JType)codeModel.ref(Short.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int16"));
        typeLookup.put((JType)JPrimitiveType.parse((JCodeModel)codeModel, (String)Integer.TYPE.getName()), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int32"));
        typeLookup.put((JType)codeModel.ref(Integer.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int32"));
        typeLookup.put((JType)JPrimitiveType.parse((JCodeModel)codeModel, (String)Long.TYPE.getName()), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int64"));
        typeLookup.put((JType)codeModel.ref(Long.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int64"));
        typeLookup.put((JType)codeModel.ref(BigInteger.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("int64"));
        typeLookup.put((JType)codeModel.ref(BigDecimal.class), (JExpression)this.connectDecimalJClass.staticInvoke("builder").arg(JExpr.lit((int)12)));
        typeLookup.put((JType)codeModel.ref(String.class), (JExpression)this.connectSchemaBuilderJClass.staticInvoke("string"));
        this.typeLookup = typeLookup;
        this.typeXMLGregorianCalendar = codeModel.ref(XMLGregorianCalendar.class);
    }

    JMethod findMethod(JCodeModel codeModel, ClassOutline classOutline, Field field) {
        String methodName = field.fieldVar.type().equals(codeModel.ref(Boolean.class)) || field.fieldVar.type().equals(JPrimitiveType.parse((JCodeModel)codeModel, (String)Boolean.TYPE.getName())) ? "is" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, field.fieldVar.name()) : "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, field.fieldVar.name());
        JMethod result = classOutline.implClass.getMethod(methodName, new JType[0]);
        if (null == result) {
            for (JMethod method : classOutline.implClass.methods()) {
                if (!methodName.equalsIgnoreCase(method.name())) continue;
                result = method;
                break;
            }
        }
        return result;
    }

    void processToStruct(JFieldVar schemaField, JCodeModel codeModel, ClassOutline classOutline, List<Field> fields) {
        JMethod method = classOutline.implClass.method(1, (JType)this.connectStructJClass, STRUCT_METHOD_NAME);
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        JVar structVar = methodBody.decl((JType)this.connectStructJClass, "struct", (JExpression)JExpr._new((JClass)this.connectStructJClass).arg((JExpression)schemaField));
        for (Field field : fields) {
            JConditional nullCheck;
            JMethod getterMethod = this.findMethod(codeModel, classOutline, field);
            if (null == getterMethod) {
                Preconditions.checkNotNull((Object)getterMethod, (String)"Could not find getter method for %s.%s", (Object[])new Object[]{classOutline.implClass.fullName(), field.fieldVar.name()});
            }
            JInvocation invokeGetter = JExpr._this().invoke(getterMethod);
            if (Type.ARRAY == field.type) {
                nullCheck = methodBody._if(JExpr._null().ne((JExpression)invokeGetter));
                JVar structs = nullCheck._then().decl((JType)this.connectListOfStructJClass, "structs", (JExpression)JExpr._new((JClass)this.typeArrayList));
                JFieldRef oField = JExpr.ref((String)"o");
                JForEach forLoop = nullCheck._then().forEach(field.arrayType, "o", (JExpression)invokeGetter);
                forLoop.body().add((JStatement)structs.invoke("add").arg((JExpression)oField.invoke(STRUCT_METHOD_NAME)));
                nullCheck._then().add((JStatement)structVar.invoke("put").arg(field.name).arg((JExpression)structs));
                continue;
            }
            if (Type.STRUCT == field.type) {
                JInvocation invokeStruct = invokeGetter.invoke(STRUCT_METHOD_NAME);
                JConditional nullCheck2 = methodBody._if(JExpr._null().ne((JExpression)invokeGetter));
                nullCheck2._then().add((JStatement)structVar.invoke("put").arg(field.name).arg((JExpression)invokeStruct));
                nullCheck2._else().add((JStatement)structVar.invoke("put").arg(field.name).arg(JExpr._null()));
                continue;
            }
            if (Type.VALUE == field.type) {
                methodBody.add((JStatement)structVar.invoke("put").arg(field.name).arg((JExpression)invokeGetter));
                continue;
            }
            if (Type.XML_CALENDER == field.type) {
                nullCheck = methodBody._if(JExpr._null().ne((JExpression)invokeGetter));
                JInvocation invokeGetTime = invokeGetter.invoke("toGregorianCalendar").arg((JExpression)codeModel.ref(TimeZone.class).staticInvoke("getTimeZone").arg("UTC")).arg(JExpr._null()).arg(JExpr._null()).invoke("getTime");
                nullCheck._then().add((JStatement)structVar.invoke("put").arg(field.name).arg((JExpression)invokeGetTime));
                nullCheck._else().add((JStatement)structVar.invoke("put").arg(field.name).arg(JExpr._null()));
                continue;
            }
            if (Type.VALUE == field.type) {
                methodBody.add((JStatement)structVar.invoke("put").arg(field.name).arg((JExpression)invokeGetter));
                continue;
            }
            if (Type.XML_ENUM != field.type) continue;
            JInvocation invokeValue = invokeGetter.invoke("value");
            methodBody.add((JStatement)structVar.invoke("put").arg(field.name).arg((JExpression)invokeValue));
        }
        methodBody._return((JExpression)structVar);
    }

    void processFromStruct(JCodeModel codeModel, ClassOutline classOutline) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Field> fields(JCodeModel codeModel, ClassOutline classOutline) {
        ArrayList<Field> result = new ArrayList<Field>();
        Map fields = classOutline.implClass.fields();
        for (Map.Entry kvp : fields.entrySet()) {
            String fieldName = (String)kvp.getKey();
            JFieldVar jFieldVar = (JFieldVar)kvp.getValue();
            log.trace("processSchema() - processing name = '{}' type = '{}'", (Object)fieldName, (Object)jFieldVar.type().name());
            Field field = new Field();
            result.add(field);
            field.fieldVar = jFieldVar;
            Map<String, Object> xmlElementValues = AnnotationUtils.xmlElement(codeModel, jFieldVar);
            Map<String, Object> xmlAttributeValues = AnnotationUtils.xmlAttribute(codeModel, jFieldVar);
            Map<String, Object> xmlSchemaTypeValues = AnnotationUtils.xmlSchemaType(codeModel, jFieldVar);
            Map<String, Object> xmlMixed = AnnotationUtils.annotationAttributes(codeModel, jFieldVar, XmlMixed.class);
            if (null != xmlMixed) {
                throw new UnsupportedOperationException(String.format("%s.%s is marked with XmlMixed.", classOutline.implClass.fullName(), jFieldVar.name()));
            }
            if (null != xmlElementValues && !xmlElementValues.isEmpty()) {
                field.required = (Boolean)xmlElementValues.getOrDefault("required", false);
                field.name = (String)xmlElementValues.getOrDefault("name", fieldName);
            } else if (null != xmlAttributeValues && !xmlAttributeValues.isEmpty()) {
                field.required = (Boolean)xmlAttributeValues.getOrDefault("required", false);
                field.name = (String)xmlAttributeValues.getOrDefault("name", fieldName);
            } else {
                field.required = false;
                field.name = fieldName;
            }
            Preconditions.checkNotNull((Object)field.name, (String)"fieldName cannot be null. %s", (Object[])new Object[]{classOutline.implClass.fullName()});
            if (null != xmlSchemaTypeValues && !xmlSchemaTypeValues.isEmpty()) {
                String name;
                switch (name = (String)xmlSchemaTypeValues.get("name")) {
                    case "date": {
                        field.schemaBuilder = this.connectDateJClass.staticInvoke("builder");
                        field.type = Type.XML_CALENDER;
                        break;
                    }
                    case "time": {
                        field.schemaBuilder = this.connectTimeJClass.staticInvoke("builder");
                        field.type = Type.XML_CALENDER;
                        break;
                    }
                    case "dateTime": {
                        field.schemaBuilder = this.connectTimestampJClass.staticInvoke("builder");
                        field.type = Type.XML_CALENDER;
                        break;
                    }
                    case "positiveInteger": 
                    case "unsignedLong": {
                        field.schemaBuilder = this.connectSchemaBuilderJClass.staticInvoke("int64");
                        field.type = Type.VALUE;
                        break;
                    }
                    case "anySimpleType": 
                    case "anyURI": {
                        field.schemaBuilder = this.connectSchemaBuilderJClass.staticInvoke("string");
                        field.type = Type.VALUE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unknown type %s", name));
                    }
                }
            } else if (this.typeLookup.containsKey(jFieldVar.type())) {
                field.schemaBuilder = this.typeLookup.get(jFieldVar.type());
                field.type = Type.VALUE;
            } else if (jFieldVar.type() instanceof JDefinedClass) {
                JDefinedClass jDefinedClass = (JDefinedClass)jFieldVar.type();
                if (null != AnnotationUtils.annotationAttributes(codeModel, jFieldVar, XmlEnum.class)) {
                    field.schemaBuilder = this.connectSchemaBuilderJClass.staticInvoke("string");
                    field.type = Type.XML_ENUM;
                } else {
                    field.schemaBuilder = jDefinedClass.staticRef(CONNECT_SCHEMA_FIELD);
                    field.type = Type.STRUCT;
                }
            } else if (CLASS_JNARROWED.equals(jFieldVar.type().getClass())) {
                List args;
                JClass basis;
                JClass jClass = (JClass)jFieldVar.type();
                try {
                    Class<?> jnarrowedCls = Class.forName("com.sun.codemodel.JNarrowedClass");
                    java.lang.reflect.Field basisField = jnarrowedCls.getDeclaredField("basis");
                    basisField.setAccessible(true);
                    java.lang.reflect.Field argsField = jnarrowedCls.getDeclaredField("args");
                    argsField.setAccessible(true);
                    basis = (JClass)basisField.get(jClass);
                    args = (List)argsField.get(jClass);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
                if (!this.typeList.equals(basis)) throw new IllegalStateException(String.format("%s is not supported.", basis.fullName()));
                JClass listType = (JClass)args.get(0);
                field.schemaBuilder = this.connectSchemaBuilderJClass.staticInvoke("array").arg((JExpression)listType.staticRef(CONNECT_SCHEMA_FIELD));
                field.type = Type.ARRAY;
                field.arrayType = listType;
            } else {
                if (!CLASS_JREFERENCEDCLASS.equals(jFieldVar.type().getClass())) throw new UnsupportedOperationException(String.format("%s is not supported.", jFieldVar.type().getClass().getName()));
                log.warn("Nothing for {}", (Object)jFieldVar.type().fullName());
            }
            Preconditions.checkNotNull((Object)field.schemaBuilder, (String)"%s.%s: %s was not handled", (Object[])new Object[]{classOutline.implClass.fullName(), jFieldVar.name(), jFieldVar.type().fullName()});
        }
        return result;
    }

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) throws SAXException {
        try {
            JCodeModel codeModel = model.getCodeModel();
            this.setupImportedClasses(codeModel);
            for (ClassOutline classOutline : model.getClasses()) {
                classOutline.implClass._implements(this.connectableJClass);
                log.trace("run - {}", (Object)classOutline.implClass.name());
                List<Field> fields = this.fields(codeModel, classOutline);
                log.trace("Found {} field(s). {}", (Object)fields.size(), fields);
                JFieldVar schemaField = this.processSchema(codeModel, classOutline, fields);
                this.processToStruct(schemaField, codeModel, classOutline, fields);
            }
            return true;
        }
        catch (Exception e) {
            errorHandler.error(new SAXParseException("Exception thrown while processing: " + e.getMessage(), null));
            return false;
        }
    }

    static {
        try {
            CLASS_JNARROWED = Class.forName("com.sun.codemodel.JNarrowedClass");
            CLASS_JREFERENCEDCLASS = Class.forName("com.sun.codemodel.JCodeModel$JReferencedClass");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static class Field {
        public String name;
        public JFieldVar fieldVar;
        public boolean required;
        public Type type;
        public JExpression schemaBuilder;
        public JType arrayType;

        Field() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("required", this.required).add("type", (Object)this.type).toString();
        }
    }

    static enum Type {
        VALUE,
        ARRAY,
        STRUCT,
        XML_ENUM,
        XML_CALENDER;

    }
}

