/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.xml;

import com.google.common.base.Preconditions;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnotationUtils {
    private static final Logger log = LoggerFactory.getLogger(AnnotationUtils.class);

    AnnotationUtils() {
    }

    public static Map<String, Object> xmlSchemaType(JCodeModel codeModel, JFieldVar field) {
        Map<String, Object> result = AnnotationUtils.annotationAttributes(codeModel, field, XmlSchemaType.class);
        return result;
    }

    public static Map<String, Object> xmlAttribute(JCodeModel codeModel, JFieldVar field) {
        Map<String, Object> result = AnnotationUtils.annotationAttributes(codeModel, field, XmlAttribute.class);
        if (null == result) {
            return null;
        }
        if ("##default".equals(result.get("name"))) {
            result.put("name", field.name());
        }
        if ("##default".equals(result.get("namespace"))) {
            result.remove("namespace");
        }
        return result;
    }

    public static Map<String, Object> xmlElement(JCodeModel codeModel, JFieldVar field) {
        Map<String, Object> result = AnnotationUtils.annotationAttributes(codeModel, field, XmlElement.class);
        if (null == result) {
            return null;
        }
        if ("##default".equals(result.get("name"))) {
            result.put("name", field.name());
        }
        if ("##default".equals(result.get("namespace"))) {
            result.remove("namespace");
        }
        return result;
    }

    public static boolean required(JCodeModel codeModel, JFieldVar field) {
        Map<String, Object> xmlElementValues = AnnotationUtils.xmlElement(codeModel, field);
        if (null != xmlElementValues && !xmlElementValues.isEmpty()) {
            return (Boolean)xmlElementValues.getOrDefault("required", false);
        }
        Map<String, Object> xmlAttributeValues = AnnotationUtils.xmlAttribute(codeModel, field);
        if (null != xmlAttributeValues && !xmlAttributeValues.isEmpty()) {
            return (Boolean)xmlAttributeValues.getOrDefault("required", false);
        }
        return false;
    }

    public static String name(JCodeModel codeModel, JFieldVar field, String fieldName) {
        Map<String, Object> xmlElementValues = AnnotationUtils.xmlElement(codeModel, field);
        if (null != xmlElementValues && !xmlElementValues.isEmpty()) {
            return (String)xmlElementValues.getOrDefault("name", fieldName);
        }
        Map<String, Object> xmlAttributeValues = AnnotationUtils.xmlAttribute(codeModel, field);
        if (null != xmlAttributeValues && !xmlAttributeValues.isEmpty()) {
            return (String)xmlAttributeValues.getOrDefault("name", fieldName);
        }
        return fieldName;
    }

    public static String xmlType(JCodeModel codeModel, JFieldVar jFieldVar) {
        Map<String, Object> xmlSchemaTypeValues = AnnotationUtils.xmlSchemaType(codeModel, jFieldVar);
        String name = null != xmlSchemaTypeValues && !xmlSchemaTypeValues.isEmpty() ? (String)xmlSchemaTypeValues.get("name") : null;
        return name;
    }

    public static Map<String, Object> annotationAttributes(JCodeModel codeModel, JFieldVar field, Class<?> cls) {
        Preconditions.checkNotNull((Object)field, (Object)"field cannot be null.");
        Preconditions.checkNotNull(cls, (Object)"cls cannot be null.");
        Preconditions.checkState((boolean)cls.isAnnotation(), (Object)"cls must be an annotation.");
        JClass jClass = codeModel.ref(cls);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        boolean found = false;
        for (JAnnotationUse annotationUse : field.annotations()) {
            if (!jClass.equals(annotationUse.getAnnotationClass())) continue;
            found = true;
            for (Method method : cls.getMethods()) {
                Object value;
                Map annotationMembers;
                log.trace("annotationAttributes() - looking for member '{}'", (Object)method.getName());
                try {
                    annotationMembers = annotationUse.getAnnotationMembers();
                }
                catch (NullPointerException ex) {
                    log.trace("Exception thrown while trying to read annotationMembers from {}", (Object)annotationUse, (Object)ex);
                    continue;
                }
                JAnnotationValue annotationValue = (JAnnotationValue)annotationMembers.get(method.getName());
                if (null == annotationValue) {
                    log.trace("annotationAttributes() - Setting default for '{}' to '{}'", (Object)method.getName(), method.getDefaultValue());
                    result.put(method.getName(), method.getDefaultValue());
                    continue;
                }
                log.trace("annotationAttributes() - Return type for '{}' is '{}'", (Object)method.getName(), method.getReturnType());
                StringWriter writer = new StringWriter();
                JFormatter formatter = new JFormatter((Writer)writer);
                annotationValue.generate(formatter);
                String stringValue = writer.toString();
                if (Boolean.TYPE.equals(method.getReturnType())) {
                    log.trace("annotationAttributes() - Parsing value for '{}' to '{}'. stringValue = '{}'", new Object[]{method.getName(), method.getReturnType(), stringValue});
                    value = Boolean.parseBoolean(stringValue);
                } else if (String.class.equals(method.getReturnType()) || Class.class.equals(method.getReturnType())) {
                    value = stringValue.replaceAll("^\\\"(.*)\\\"$", "$1");
                    if (value == "\u0000") {
                        continue;
                    }
                } else if (Long.TYPE.equals(method.getReturnType())) {
                    value = Long.parseLong(stringValue);
                } else if (Integer.TYPE.equals(method.getReturnType())) {
                    value = Integer.parseInt(stringValue);
                } else {
                    throw new IllegalStateException(String.format("Could not parse type for %s.%s: %s", cls.getName(), method.getName(), method.getReturnType().getName()));
                }
                result.put(method.getName(), value);
            }
        }
        if (!found) {
            return null;
        }
        return result;
    }

    public static Map<String, Object> attributes(JFieldVar field, JClass cls) {
        Preconditions.checkNotNull((Object)field, (Object)"field cannot be null.");
        Preconditions.checkNotNull((Object)cls, (Object)"cls cannot be null.");
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (JAnnotationUse annotationUse : field.annotations()) {
            if (!cls.equals(annotationUse.getAnnotationClass())) continue;
            for (Map.Entry kvp : annotationUse.getAnnotationMembers().entrySet()) {
                String memberName = (String)kvp.getKey();
                JAnnotationValue annotationValue = (JAnnotationValue)kvp.getValue();
                log.trace("attributes() - memberName = '{}' annotationValue = '{}'", (Object)memberName, (Object)annotationValue);
                StringWriter writer = new StringWriter();
                JFormatter formatter = new JFormatter((Writer)writer);
                annotationValue.generate(formatter);
                log.trace("attributes() - memberName = '{}' value = '{}'", (Object)memberName, (Object)writer.toString());
                result.put((String)kvp.getKey(), writer.toString());
            }
        }
        return result;
    }
}

