/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.xml;

import com.github.jcustenborder.kafka.connect.xml.FieldState;
import com.github.jcustenborder.kafka.connect.xml.Nullable;
import com.github.jcustenborder.kafka.connect.xml.State;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import java.util.ArrayList;
import java.util.Objects;

final class ImmutableFieldState
implements FieldState {
    private final String name;
    private final JFieldVar fieldVar;
    private final boolean required;
    private final ImmutableList<JExpression> readMethodArgs;
    @Nullable
    private final JExpression schema;
    private final JExpression schemaBuilder;
    private final String readMethod;
    private final String writeMethod;
    private final ImmutableList<JExpression> writeMethodArgs;

    private ImmutableFieldState(String name, JFieldVar fieldVar, boolean required, ImmutableList<JExpression> readMethodArgs, @Nullable JExpression schema, JExpression schemaBuilder, String readMethod, String writeMethod, ImmutableList<JExpression> writeMethodArgs) {
        this.name = name;
        this.fieldVar = fieldVar;
        this.required = required;
        this.readMethodArgs = readMethodArgs;
        this.schema = schema;
        this.schemaBuilder = schemaBuilder;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.writeMethodArgs = writeMethodArgs;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public JFieldVar fieldVar() {
        return this.fieldVar;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    public ImmutableList<JExpression> readMethodArgs() {
        return this.readMethodArgs;
    }

    @Override
    @Nullable
    public JExpression schema() {
        return this.schema;
    }

    @Override
    public JExpression schemaBuilder() {
        return this.schemaBuilder;
    }

    @Override
    public String readMethod() {
        return this.readMethod;
    }

    @Override
    public String writeMethod() {
        return this.writeMethod;
    }

    public ImmutableList<JExpression> writeMethodArgs() {
        return this.writeMethodArgs;
    }

    public final ImmutableFieldState withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "name");
        return new ImmutableFieldState(newValue, this.fieldVar, this.required, this.readMethodArgs, this.schema, this.schemaBuilder, this.readMethod, this.writeMethod, this.writeMethodArgs);
    }

    public final ImmutableFieldState withFieldVar(JFieldVar value) {
        if (this.fieldVar == value) {
            return this;
        }
        JFieldVar newValue = Objects.requireNonNull(value, "fieldVar");
        return new ImmutableFieldState(this.name, newValue, this.required, this.readMethodArgs, this.schema, this.schemaBuilder, this.readMethod, this.writeMethod, this.writeMethodArgs);
    }

    public final ImmutableFieldState withRequired(boolean value) {
        if (this.required == value) {
            return this;
        }
        return new ImmutableFieldState(this.name, this.fieldVar, value, this.readMethodArgs, this.schema, this.schemaBuilder, this.readMethod, this.writeMethod, this.writeMethodArgs);
    }

    public final ImmutableFieldState withReadMethodArgs(JExpression ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFieldState(this.name, this.fieldVar, this.required, (ImmutableList<JExpression>)newValue, this.schema, this.schemaBuilder, this.readMethod, this.writeMethod, this.writeMethodArgs);
    }

    public final ImmutableFieldState withReadMethodArgs(Iterable<? extends JExpression> elements) {
        if (this.readMethodArgs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFieldState(this.name, this.fieldVar, this.required, (ImmutableList<JExpression>)newValue, this.schema, this.schemaBuilder, this.readMethod, this.writeMethod, this.writeMethodArgs);
    }

    public final ImmutableFieldState withSchema(@Nullable JExpression value) {
        if (this.schema == value) {
            return this;
        }
        return new ImmutableFieldState(this.name, this.fieldVar, this.required, this.readMethodArgs, value, this.schemaBuilder, this.readMethod, this.writeMethod, this.writeMethodArgs);
    }

    public final ImmutableFieldState withSchemaBuilder(JExpression value) {
        if (this.schemaBuilder == value) {
            return this;
        }
        JExpression newValue = Objects.requireNonNull(value, "schemaBuilder");
        return new ImmutableFieldState(this.name, this.fieldVar, this.required, this.readMethodArgs, this.schema, newValue, this.readMethod, this.writeMethod, this.writeMethodArgs);
    }

    public final ImmutableFieldState withReadMethod(String value) {
        if (this.readMethod.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "readMethod");
        return new ImmutableFieldState(this.name, this.fieldVar, this.required, this.readMethodArgs, this.schema, this.schemaBuilder, newValue, this.writeMethod, this.writeMethodArgs);
    }

    public final ImmutableFieldState withWriteMethod(String value) {
        if (this.writeMethod.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "writeMethod");
        return new ImmutableFieldState(this.name, this.fieldVar, this.required, this.readMethodArgs, this.schema, this.schemaBuilder, this.readMethod, newValue, this.writeMethodArgs);
    }

    public final ImmutableFieldState withWriteMethodArgs(JExpression ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFieldState(this.name, this.fieldVar, this.required, this.readMethodArgs, this.schema, this.schemaBuilder, this.readMethod, this.writeMethod, (ImmutableList<JExpression>)newValue);
    }

    public final ImmutableFieldState withWriteMethodArgs(Iterable<? extends JExpression> elements) {
        if (this.writeMethodArgs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFieldState(this.name, this.fieldVar, this.required, this.readMethodArgs, this.schema, this.schemaBuilder, this.readMethod, this.writeMethod, (ImmutableList<JExpression>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldState && this.equalTo((ImmutableFieldState)another);
    }

    private boolean equalTo(ImmutableFieldState another) {
        return this.name.equals(another.name) && this.fieldVar.equals(another.fieldVar) && this.required == another.required && this.readMethodArgs.equals(another.readMethodArgs) && Objects.equals(this.schema, another.schema) && this.schemaBuilder.equals(another.schemaBuilder) && this.readMethod.equals(another.readMethod) && this.writeMethod.equals(another.writeMethod) && this.writeMethodArgs.equals(another.writeMethodArgs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.fieldVar.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.required);
        h += (h << 5) + this.readMethodArgs.hashCode();
        h += (h << 5) + Objects.hashCode(this.schema);
        h += (h << 5) + this.schemaBuilder.hashCode();
        h += (h << 5) + this.readMethod.hashCode();
        h += (h << 5) + this.writeMethod.hashCode();
        h += (h << 5) + this.writeMethodArgs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FieldState").omitNullValues().add("name", (Object)this.name).add("fieldVar", (Object)this.fieldVar).add("required", this.required).add("readMethodArgs", this.readMethodArgs).add("schema", (Object)this.schema).add("schemaBuilder", (Object)this.schemaBuilder).add("readMethod", (Object)this.readMethod).add("writeMethod", (Object)this.writeMethod).add("writeMethodArgs", this.writeMethodArgs).toString();
    }

    public static ImmutableFieldState copyOf(FieldState instance) {
        if (instance instanceof ImmutableFieldState) {
            return (ImmutableFieldState)instance;
        }
        return ImmutableFieldState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_FIELD_VAR = 2L;
        private static final long INIT_BIT_REQUIRED = 4L;
        private static final long INIT_BIT_SCHEMA_BUILDER = 8L;
        private static final long INIT_BIT_READ_METHOD = 16L;
        private static final long INIT_BIT_WRITE_METHOD = 32L;
        private long initBits = 63L;
        private String name;
        private JFieldVar fieldVar;
        private boolean required;
        private ImmutableList.Builder<JExpression> readMethodArgs = ImmutableList.builder();
        private JExpression schema;
        private JExpression schemaBuilder;
        private String readMethod;
        private String writeMethod;
        private ImmutableList.Builder<JExpression> writeMethodArgs = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(FieldState instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(State instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            State instance;
            long bits = 0L;
            if (object instanceof FieldState) {
                instance = (FieldState)object;
                this.name(instance.name());
                if ((bits & 1L) == 0L) {
                    this.addAllReadMethodArgs(instance.readMethodArgs());
                    bits |= 1L;
                }
                this.fieldVar(instance.fieldVar());
                this.required(instance.required());
            }
            if (object instanceof State) {
                instance = (State)object;
                JExpression schemaValue = instance.schema();
                if (schemaValue != null) {
                    this.schema(schemaValue);
                }
                if ((bits & 1L) == 0L) {
                    this.addAllReadMethodArgs(instance.readMethodArgs());
                    bits |= 1L;
                }
                this.schemaBuilder(instance.schemaBuilder());
                this.writeMethod(instance.writeMethod());
                this.readMethod(instance.readMethod());
                this.addAllWriteMethodArgs(instance.writeMethodArgs());
            }
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fieldVar(JFieldVar fieldVar) {
            this.fieldVar = Objects.requireNonNull(fieldVar, "fieldVar");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder required(boolean required) {
            this.required = required;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addReadMethodArgs(JExpression element) {
            this.readMethodArgs.add((Object)element);
            return this;
        }

        public final Builder addReadMethodArgs(JExpression ... elements) {
            this.readMethodArgs.add((Object[])elements);
            return this;
        }

        public final Builder readMethodArgs(Iterable<? extends JExpression> elements) {
            this.readMethodArgs = ImmutableList.builder();
            return this.addAllReadMethodArgs(elements);
        }

        public final Builder addAllReadMethodArgs(Iterable<? extends JExpression> elements) {
            this.readMethodArgs.addAll(elements);
            return this;
        }

        public final Builder schema(@Nullable JExpression schema) {
            this.schema = schema;
            return this;
        }

        public final Builder schemaBuilder(JExpression schemaBuilder) {
            this.schemaBuilder = Objects.requireNonNull(schemaBuilder, "schemaBuilder");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder readMethod(String readMethod) {
            this.readMethod = Objects.requireNonNull(readMethod, "readMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder writeMethod(String writeMethod) {
            this.writeMethod = Objects.requireNonNull(writeMethod, "writeMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addWriteMethodArgs(JExpression element) {
            this.writeMethodArgs.add((Object)element);
            return this;
        }

        public final Builder addWriteMethodArgs(JExpression ... elements) {
            this.writeMethodArgs.add((Object[])elements);
            return this;
        }

        public final Builder writeMethodArgs(Iterable<? extends JExpression> elements) {
            this.writeMethodArgs = ImmutableList.builder();
            return this.addAllWriteMethodArgs(elements);
        }

        public final Builder addAllWriteMethodArgs(Iterable<? extends JExpression> elements) {
            this.writeMethodArgs.addAll(elements);
            return this;
        }

        public ImmutableFieldState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFieldState(this.name, this.fieldVar, this.required, this.readMethodArgs.build(), this.schema, this.schemaBuilder, this.readMethod, this.writeMethod, this.writeMethodArgs.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fieldVar");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("required");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("schemaBuilder");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("readMethod");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("writeMethod");
            }
            return "Cannot build FieldState, some of required attributes are not set " + attributes;
        }
    }
}

