package com.github.jcustenborder.kafka.connect.xml;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link StaticTypeState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStaticTypeState.builder()}.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableStaticTypeState
    implements StaticTypeState {
  private final ImmutableList<JType> types;
  private final @Nullable JExpression schema;
  private final JExpression schemaBuilder;
  private final String readMethod;
  private final ImmutableList<JExpression> readMethodArgs;
  private final String writeMethod;
  private final ImmutableList<JExpression> writeMethodArgs;

  private ImmutableStaticTypeState(
      ImmutableList<JType> types,
      @Nullable JExpression schema,
      JExpression schemaBuilder,
      String readMethod,
      ImmutableList<JExpression> readMethodArgs,
      String writeMethod,
      ImmutableList<JExpression> writeMethodArgs) {
    this.types = types;
    this.schema = schema;
    this.schemaBuilder = schemaBuilder;
    this.readMethod = readMethod;
    this.readMethodArgs = readMethodArgs;
    this.writeMethod = writeMethod;
    this.writeMethodArgs = writeMethodArgs;
  }

  /**
   * @return The value of the {@code types} attribute
   */
  @Override
  public ImmutableList<JType> types() {
    return types;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @Override
  public @Nullable JExpression schema() {
    return schema;
  }

  /**
   * @return The value of the {@code schemaBuilder} attribute
   */
  @Override
  public JExpression schemaBuilder() {
    return schemaBuilder;
  }

  /**
   * @return The value of the {@code readMethod} attribute
   */
  @Override
  public String readMethod() {
    return readMethod;
  }

  /**
   * @return The value of the {@code readMethodArgs} attribute
   */
  @Override
  public ImmutableList<JExpression> readMethodArgs() {
    return readMethodArgs;
  }

  /**
   * @return The value of the {@code writeMethod} attribute
   */
  @Override
  public String writeMethod() {
    return writeMethod;
  }

  /**
   * @return The value of the {@code writeMethodArgs} attribute
   */
  @Override
  public ImmutableList<JExpression> writeMethodArgs() {
    return writeMethodArgs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticTypeState#types() types}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticTypeState withTypes(JType... elements) {
    ImmutableList<JType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStaticTypeState(
        newValue,
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticTypeState#types() types}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of types elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticTypeState withTypes(Iterable<? extends JType> elements) {
    if (this.types == elements) return this;
    ImmutableList<JType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStaticTypeState(
        newValue,
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticTypeState#schema() schema} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStaticTypeState withSchema(@Nullable JExpression value) {
    if (this.schema == value) return this;
    return new ImmutableStaticTypeState(
        this.types,
        value,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticTypeState#schemaBuilder() schemaBuilder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStaticTypeState withSchemaBuilder(JExpression value) {
    if (this.schemaBuilder == value) return this;
    JExpression newValue = Objects.requireNonNull(value, "schemaBuilder");
    return new ImmutableStaticTypeState(
        this.types,
        this.schema,
        newValue,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticTypeState#readMethod() readMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStaticTypeState withReadMethod(String value) {
    if (this.readMethod.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "readMethod");
    return new ImmutableStaticTypeState(
        this.types,
        this.schema,
        this.schemaBuilder,
        newValue,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticTypeState#readMethodArgs() readMethodArgs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticTypeState withReadMethodArgs(JExpression... elements) {
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStaticTypeState(
        this.types,
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        newValue,
        this.writeMethod,
        this.writeMethodArgs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticTypeState#readMethodArgs() readMethodArgs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of readMethodArgs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticTypeState withReadMethodArgs(Iterable<? extends JExpression> elements) {
    if (this.readMethodArgs == elements) return this;
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStaticTypeState(
        this.types,
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        newValue,
        this.writeMethod,
        this.writeMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticTypeState#writeMethod() writeMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for writeMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStaticTypeState withWriteMethod(String value) {
    if (this.writeMethod.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "writeMethod");
    return new ImmutableStaticTypeState(
        this.types,
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        newValue,
        this.writeMethodArgs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticTypeState#writeMethodArgs() writeMethodArgs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticTypeState withWriteMethodArgs(JExpression... elements) {
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStaticTypeState(
        this.types,
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticTypeState#writeMethodArgs() writeMethodArgs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of writeMethodArgs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticTypeState withWriteMethodArgs(Iterable<? extends JExpression> elements) {
    if (this.writeMethodArgs == elements) return this;
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStaticTypeState(
        this.types,
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStaticTypeState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStaticTypeState
        && equalTo((ImmutableStaticTypeState) another);
  }

  private boolean equalTo(ImmutableStaticTypeState another) {
    return types.equals(another.types)
        && Objects.equals(schema, another.schema)
        && schemaBuilder.equals(another.schemaBuilder)
        && readMethod.equals(another.readMethod)
        && readMethodArgs.equals(another.readMethodArgs)
        && writeMethod.equals(another.writeMethod)
        && writeMethodArgs.equals(another.writeMethodArgs);
  }

  /**
   * Computes a hash code from attributes: {@code types}, {@code schema}, {@code schemaBuilder}, {@code readMethod}, {@code readMethodArgs}, {@code writeMethod}, {@code writeMethodArgs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + types.hashCode();
    h += (h << 5) + Objects.hashCode(schema);
    h += (h << 5) + schemaBuilder.hashCode();
    h += (h << 5) + readMethod.hashCode();
    h += (h << 5) + readMethodArgs.hashCode();
    h += (h << 5) + writeMethod.hashCode();
    h += (h << 5) + writeMethodArgs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StaticTypeState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StaticTypeState")
        .omitNullValues()
        .add("types", types)
        .add("schema", schema)
        .add("schemaBuilder", schemaBuilder)
        .add("readMethod", readMethod)
        .add("readMethodArgs", readMethodArgs)
        .add("writeMethod", writeMethod)
        .add("writeMethodArgs", writeMethodArgs)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StaticTypeState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StaticTypeState instance
   */
  public static ImmutableStaticTypeState copyOf(StaticTypeState instance) {
    if (instance instanceof ImmutableStaticTypeState) {
      return (ImmutableStaticTypeState) instance;
    }
    return ImmutableStaticTypeState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStaticTypeState ImmutableStaticTypeState}.
   * @return A new ImmutableStaticTypeState builder
   */
  public static ImmutableStaticTypeState.Builder builder() {
    return new ImmutableStaticTypeState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStaticTypeState ImmutableStaticTypeState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SCHEMA_BUILDER = 0x1L;
    private static final long INIT_BIT_READ_METHOD = 0x2L;
    private static final long INIT_BIT_WRITE_METHOD = 0x4L;
    private long initBits = 0x7L;

    private ImmutableList.Builder<JType> types = ImmutableList.builder();
    private JExpression schema;
    private JExpression schemaBuilder;
    private String readMethod;
    private ImmutableList.Builder<JExpression> readMethodArgs = ImmutableList.builder();
    private String writeMethod;
    private ImmutableList.Builder<JExpression> writeMethodArgs = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.xml.StaticTypeState} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StaticTypeState instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.xml.State} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(State instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StaticTypeState) {
        StaticTypeState instance = (StaticTypeState) object;
        addAllTypes(instance.types());
      }
      if (object instanceof State) {
        State instance = (State) object;
        @Nullable JExpression schemaValue = instance.schema();
        if (schemaValue != null) {
          schema(schemaValue);
        }
        schemaBuilder(instance.schemaBuilder());
        addAllReadMethodArgs(instance.readMethodArgs());
        writeMethod(instance.writeMethod());
        readMethod(instance.readMethod());
        addAllWriteMethodArgs(instance.writeMethodArgs());
      }
    }

    /**
     * Adds one element to {@link StaticTypeState#types() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTypes(JType element) {
      this.types.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StaticTypeState#types() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTypes(JType... elements) {
      this.types.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StaticTypeState#types() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(Iterable<? extends JType> elements) {
      this.types = ImmutableList.builder();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link StaticTypeState#types() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<? extends JType> elements) {
      this.types.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link StaticTypeState#schema() schema} attribute.
     * @param schema The value for schema (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(@Nullable JExpression schema) {
      this.schema = schema;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticTypeState#schemaBuilder() schemaBuilder} attribute.
     * @param schemaBuilder The value for schemaBuilder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemaBuilder(JExpression schemaBuilder) {
      this.schemaBuilder = Objects.requireNonNull(schemaBuilder, "schemaBuilder");
      initBits &= ~INIT_BIT_SCHEMA_BUILDER;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticTypeState#readMethod() readMethod} attribute.
     * @param readMethod The value for readMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder readMethod(String readMethod) {
      this.readMethod = Objects.requireNonNull(readMethod, "readMethod");
      initBits &= ~INIT_BIT_READ_METHOD;
      return this;
    }

    /**
     * Adds one element to {@link StaticTypeState#readMethodArgs() readMethodArgs} list.
     * @param element A readMethodArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addReadMethodArgs(JExpression element) {
      this.readMethodArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StaticTypeState#readMethodArgs() readMethodArgs} list.
     * @param elements An array of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addReadMethodArgs(JExpression... elements) {
      this.readMethodArgs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StaticTypeState#readMethodArgs() readMethodArgs} list.
     * @param elements An iterable of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder readMethodArgs(Iterable<? extends JExpression> elements) {
      this.readMethodArgs = ImmutableList.builder();
      return addAllReadMethodArgs(elements);
    }

    /**
     * Adds elements to {@link StaticTypeState#readMethodArgs() readMethodArgs} list.
     * @param elements An iterable of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllReadMethodArgs(Iterable<? extends JExpression> elements) {
      this.readMethodArgs.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link StaticTypeState#writeMethod() writeMethod} attribute.
     * @param writeMethod The value for writeMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeMethod(String writeMethod) {
      this.writeMethod = Objects.requireNonNull(writeMethod, "writeMethod");
      initBits &= ~INIT_BIT_WRITE_METHOD;
      return this;
    }

    /**
     * Adds one element to {@link StaticTypeState#writeMethodArgs() writeMethodArgs} list.
     * @param element A writeMethodArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addWriteMethodArgs(JExpression element) {
      this.writeMethodArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StaticTypeState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An array of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addWriteMethodArgs(JExpression... elements) {
      this.writeMethodArgs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StaticTypeState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An iterable of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeMethodArgs(Iterable<? extends JExpression> elements) {
      this.writeMethodArgs = ImmutableList.builder();
      return addAllWriteMethodArgs(elements);
    }

    /**
     * Adds elements to {@link StaticTypeState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An iterable of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllWriteMethodArgs(Iterable<? extends JExpression> elements) {
      this.writeMethodArgs.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStaticTypeState ImmutableStaticTypeState}.
     * @return An immutable instance of StaticTypeState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStaticTypeState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStaticTypeState(
          types.build(),
          schema,
          schemaBuilder,
          readMethod,
          readMethodArgs.build(),
          writeMethod,
          writeMethodArgs.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SCHEMA_BUILDER) != 0) attributes.add("schemaBuilder");
      if ((initBits & INIT_BIT_READ_METHOD) != 0) attributes.add("readMethod");
      if ((initBits & INIT_BIT_WRITE_METHOD) != 0) attributes.add("writeMethod");
      return "Cannot build StaticTypeState, some of required attributes are not set " + attributes;
    }
  }
}
