/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.xml;

import com.github.jcustenborder.kafka.connect.xml.AnnotationUtils;
import com.github.jcustenborder.kafka.connect.xml.DefinedTypeState;
import com.github.jcustenborder.kafka.connect.xml.FieldState;
import com.github.jcustenborder.kafka.connect.xml.ImmutableDefinedTypeState;
import com.github.jcustenborder.kafka.connect.xml.ImmutableFieldState;
import com.github.jcustenborder.kafka.connect.xml.ImmutableStaticTypeState;
import com.github.jcustenborder.kafka.connect.xml.ImmutableXmlTypeState;
import com.github.jcustenborder.kafka.connect.xml.State;
import com.github.jcustenborder.kafka.connect.xml.StaticTypeState;
import com.github.jcustenborder.kafka.connect.xml.TypeTooGenericException;
import com.github.jcustenborder.kafka.connect.xml.Types;
import com.github.jcustenborder.kafka.connect.xml.UnsupportedTypeException;
import com.github.jcustenborder.kafka.connect.xml.XmlTypeState;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class KafkaConnectPlugin
extends AbstractParameterizablePlugin {
    static final String TO_CONNECT_STRUCT = "toStruct";
    static final String FROM_CONNECT_STRUCT = "fromStruct";
    static final Class<?> CLASS_JNARROWED;
    static final Class<?> CLASS_JREFERENCEDCLASS;
    private static final Logger log;
    private static final String CONNECT_SCHEMA_FIELD = "CONNECT_SCHEMA";
    Types types;
    Map<JType, StaticTypeState> jTypeLookup;
    Map<String, XmlTypeState> xmlTypeLookup;
    Map<JType, DefinedTypeState> definedTypeStateLookup = new HashMap<JType, DefinedTypeState>();

    public String getOptionName() {
        return "Xconnect";
    }

    public String getUsage() {
        return "TBD";
    }

    JFieldVar processSchema(JCodeModel codeModel, ClassOutline classOutline, List<FieldState> fieldStates) {
        JFieldVar schemaVariable = classOutline.implClass.field(25, (JType)this.types.schema(), CONNECT_SCHEMA_FIELD);
        JBlock constructorBlock = classOutline.implClass.init();
        JVar builderVar = constructorBlock.decl((JType)this.types.schemaBuilder(), "builder", (JExpression)this.types.schemaBuilder().staticInvoke("struct"));
        String schemaName = String.format("%s.%s", classOutline._package()._package().name(), classOutline.implClass.name());
        constructorBlock.invoke((JExpression)builderVar, "name").arg(schemaName);
        constructorBlock.invoke((JExpression)builderVar, "optional");
        JVar fieldBuilderVar = constructorBlock.decl((JType)this.types.schemaBuilder(), "fieldBuilder");
        for (FieldState fieldState : fieldStates) {
            if (fieldState.schemaBuilder() instanceof JInvocation) {
                constructorBlock.assign((JAssignmentTarget)fieldBuilderVar, fieldState.schemaBuilder());
                if (!fieldState.required()) {
                    constructorBlock.invoke((JExpression)fieldBuilderVar, "optional");
                }
                constructorBlock.invoke((JExpression)builderVar, "field").arg(fieldState.name()).arg((JExpression)fieldBuilderVar.invoke("build"));
                continue;
            }
            constructorBlock.invoke((JExpression)builderVar, "field").arg(fieldState.name()).arg(fieldState.schemaBuilder());
        }
        constructorBlock.assign((JAssignmentTarget)schemaVariable, (JExpression)builderVar.invoke("build"));
        return schemaVariable;
    }

    void add(Map<JType, StaticTypeState> result, JExpression schemaBuilder, JExpression schema, String readMethod, String writeMethod, JCodeModel codeModel, Class<?> ... classes) {
        ImmutableStaticTypeState.Builder builder = ImmutableStaticTypeState.builder();
        for (Class<?> cls : classes) {
            Object type = cls.isPrimitive() ? JType.parse((JCodeModel)codeModel, (String)cls.getName()) : codeModel.ref(cls);
            builder.addTypes((JType)type);
        }
        builder.readMethod(readMethod);
        builder.writeMethod(writeMethod);
        builder.schema(schema);
        builder.schemaBuilder(schemaBuilder);
        ImmutableStaticTypeState typeState = builder.build();
        for (JType type : typeState.types()) {
            result.put(type, typeState);
        }
    }

    Map<JType, StaticTypeState> buildTypeLookup(JCodeModel codeModel) {
        HashMap<JType, StaticTypeState> result = new HashMap<JType, StaticTypeState>();
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("bool"), (JExpression)this.types.schema().staticRef("BOOLEAN_SCHEMA"), "toBoolean", "fromBoolean", codeModel, Boolean.TYPE, Boolean.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("float32"), (JExpression)this.types.schema().staticRef("FLOAT32_SCHEMA"), "toFloat32", "fromFloat32", codeModel, Float.TYPE, Float.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("float64"), (JExpression)this.types.schema().staticRef("FLOAT64_SCHEMA"), "toFloat64", "fromFloat64", codeModel, Double.TYPE, Double.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int8"), (JExpression)this.types.schema().staticRef("INT8_SCHEMA"), "toInt8", "fromInt8", codeModel, Byte.TYPE, Byte.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int16"), (JExpression)this.types.schema().staticRef("INT16_SCHEMA"), "toInt16", "fromInt16", codeModel, Short.TYPE, Short.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int32"), (JExpression)this.types.schema().staticRef("INT32_SCHEMA"), "toInt32", "fromInt32", codeModel, Integer.TYPE, Integer.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int64"), (JExpression)this.types.schema().staticRef("INT64_SCHEMA"), "toInt64", "fromInt64", codeModel, Long.TYPE, Long.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int64"), (JExpression)this.types.schema().staticRef("INT64_SCHEMA"), "toInt64", "fromInt64BigInteger", codeModel, BigInteger.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("bytes"), (JExpression)this.types.schema().staticRef("BYTES_SCHEMA"), "toBytes", "fromBytes", codeModel, byte[].class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("string"), (JExpression)this.types.schema().staticRef("STRING_SCHEMA"), "toString", "fromString", codeModel, String.class);
        this.add(result, (JExpression)this.types.decimal().staticInvoke("builder").arg(JExpr.lit((int)12)), null, "toDecimal", "fromDecimal", codeModel, BigDecimal.class);
        this.add(result, (JExpression)this.types.connectableHelper().staticInvoke("qnameBuilder"), null, "toQname", "fromQname", codeModel, QName.class);
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int64"), (JExpression)this.types.schema().staticRef("IN64_SCHEMA"), "toDuration", "fromDuration", codeModel, Duration.class);
        return ImmutableMap.copyOf(result);
    }

    void add(Map<String, XmlTypeState> result, JExpression schemaBuilder, JExpression schema, String readMethod, String writeMethod, String ... xmlTypes) {
        ImmutableXmlTypeState.Builder builder = ImmutableXmlTypeState.builder();
        builder.addXmlTypes(xmlTypes);
        builder.schema(schema);
        builder.readMethod(readMethod);
        builder.writeMethod(writeMethod);
        builder.schemaBuilder(schemaBuilder);
        ImmutableXmlTypeState typeState = builder.build();
        for (String type : typeState.xmlTypes()) {
            result.put(type, typeState);
        }
    }

    Map<String, XmlTypeState> buildXmlTypeLookup() {
        HashMap<String, XmlTypeState> result = new HashMap<String, XmlTypeState>();
        this.add(result, (JExpression)this.types.date().staticInvoke("builder"), (JExpression)this.types.date().staticRef("SCHEMA"), "toDate", "fromDate", "date");
        this.add(result, (JExpression)this.types.time().staticInvoke("builder"), (JExpression)this.types.time().staticRef("SCHEMA"), "toTime", "fromTime", "time");
        this.add(result, (JExpression)this.types.timestamp().staticInvoke("builder"), (JExpression)this.types.timestamp().staticRef("BOOLEAN_SCHEMA"), "toDateTime", "fromDateTime", "dateTime");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int32"), (JExpression)this.types.schema().staticRef("INT32_SCHEMA"), "toInt32", "fromInt32", "unsignedShort", "int");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int64"), (JExpression)this.types.schema().staticRef("INT64_SCHEMA"), "toInt64", "fromInt64BigInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "negativeInteger", "unsignedLong", "positiveInteger");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int64"), (JExpression)this.types.schema().staticRef("INT64_SCHEMA"), "toInt64", "fromInt64", "unsignedInt");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("string"), (JExpression)this.types.schema().staticRef("STRING_SCHEMA"), "toString", "fromString", "anySimpleType", "normalizedString", "anyURI", "ENTITY", "Name", "NCName", "token", "ID", "IDREF", "language", "NMTOKEN");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int32"), (JExpression)this.types.schema().staticRef("INT32_SCHEMA"), "toXmlgDay", "fromXmlgDay", "gDay");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int32"), (JExpression)this.types.schema().staticRef("INT32_SCHEMA"), "toXmlgMonth", "fromXmlgMonth", "gMonth");
        this.add(result, (JExpression)this.types.date().staticInvoke("builder"), (JExpression)this.types.schema().staticRef("INT32_SCHEMA"), "toXmlgMonthDay", "fromXmlgMonthDay", "gMonthDay");
        this.add(result, (JExpression)this.types.date().staticInvoke("builder"), (JExpression)this.types.schema().staticRef("INT32_SCHEMA"), "toXmlgYearMonth", "fromXmlgYearMonth", "gYearMonth");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int32"), (JExpression)this.types.schema().staticRef("INT32_SCHEMA"), "toXmlgYear", "fromXmlgYear", "gYear");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("bytes"), (JExpression)this.types.schema().staticRef("BYTES_SCHEMA"), "toBytes", "fromBytes", "base64Binary", "hexBinary");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("int16"), (JExpression)this.types.schema().staticRef("INT16_SCHEMA"), "toInt16", "fromInt16", "unsignedByte");
        this.add(result, (JExpression)this.types.schemaBuilder().staticInvoke("array").arg((JExpression)this.types.schema().staticRef("STRING")), null, "toArray", "fromArray", "IDREFS");
        return ImmutableMap.copyOf(result);
    }

    void setupImportedClasses(JCodeModel codeModel) {
        this.types = Types.build(codeModel);
        this.jTypeLookup = this.buildTypeLookup(codeModel);
        this.xmlTypeLookup = this.buildXmlTypeLookup();
    }

    void processToStruct(JFieldVar schemaField, JCodeModel codeModel, ClassOutline classOutline, List<FieldState> fieldStates) {
        JMethod method = classOutline.implClass.method(1, (JType)this.types.struct(), TO_CONNECT_STRUCT);
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        JVar structVar = methodBody.decl((JType)this.types.struct(), "struct", (JExpression)JExpr._new((JClass)this.types.struct()).arg((JExpression)schemaField));
        for (FieldState fieldState : fieldStates) {
            JInvocation callAddMethod = this.types.connectableHelper().staticInvoke(fieldState.readMethod()).arg((JExpression)structVar).arg(JExpr.lit((String)fieldState.name())).arg((JExpression)JExpr._this().ref((JVar)fieldState.fieldVar()));
            for (JExpression arg : fieldState.readMethodArgs()) {
                callAddMethod.arg(arg);
            }
            methodBody.add((JStatement)callAddMethod);
        }
        methodBody._return((JExpression)structVar);
    }

    void processFromStruct(JCodeModel codeModel, ClassOutline classOutline, List<FieldState> fieldStates) {
        JMethod method = classOutline.implClass.method(1, Void.TYPE, FROM_CONNECT_STRUCT);
        JVar structVar = method.param((JType)this.types.struct(), "struct");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        for (FieldState fieldState : fieldStates) {
            JInvocation callAddMethod = this.types.connectableHelper().staticInvoke(fieldState.writeMethod()).arg((JExpression)structVar).arg(JExpr.lit((String)fieldState.name()));
            for (JExpression arg : fieldState.writeMethodArgs()) {
                callAddMethod.arg(arg);
            }
            methodBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)fieldState.fieldVar()), (JExpression)callAddMethod);
        }
    }

    State type(JCodeModel codeModel, ClassOutline classOutline, JFieldVar field, JType type) {
        if (this.types.blackListTypes().contains(type)) {
            throw new TypeTooGenericException(classOutline, field, null, type);
        }
        State jTypeState = this.jTypeLookup.get(type);
        if (null != jTypeState) {
            return jTypeState;
        }
        if (type instanceof JDefinedClass) {
            return this.definedTypeStateLookup.computeIfAbsent(type, jType -> {
                JDefinedClass jDefinedClass = (JDefinedClass)type;
                ImmutableDefinedTypeState.Builder builder = ImmutableDefinedTypeState.builder();
                if (this.targetsEnum(jDefinedClass)) {
                    builder.schemaBuilder((JExpression)this.types.schemaBuilder().staticInvoke("string"));
                    builder.readMethod("fromEnum");
                    builder.writeMethod("toEnum");
                    builder.addWriteMethodArgs(jDefinedClass.dotclass());
                } else {
                    builder.schemaBuilder((JExpression)jDefinedClass.staticRef(CONNECT_SCHEMA_FIELD));
                    builder.readMethod(TO_CONNECT_STRUCT);
                    builder.writeMethod(FROM_CONNECT_STRUCT);
                    builder.addWriteMethodArgs(jDefinedClass.dotclass());
                    builder.schema((JExpression)jDefinedClass.staticRef(CONNECT_SCHEMA_FIELD));
                }
                builder.type(type);
                return builder.build();
            });
        }
        if (CLASS_JNARROWED.equals(type.getClass())) {
            return this.definedTypeStateLookup.computeIfAbsent(type, jType -> {
                List args;
                JClass basis;
                JClass jClass = (JClass)field.type();
                try {
                    Class<?> jnarrowedCls = Class.forName("com.sun.codemodel.JNarrowedClass");
                    Field basisField = jnarrowedCls.getDeclaredField("basis");
                    basisField.setAccessible(true);
                    Field argsField = jnarrowedCls.getDeclaredField("args");
                    argsField.setAccessible(true);
                    basis = (JClass)basisField.get(jClass);
                    args = (List)argsField.get(jClass);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
                ImmutableDefinedTypeState.Builder builder = ImmutableDefinedTypeState.builder().type(type);
                if (this.types.qNameMap().equals(jClass)) {
                    JInvocation schemaBuilder = this.types.schemaBuilder().staticInvoke("map").arg((JExpression)this.types.connectableHelper().staticRef("QNAME_SCHEMA")).arg((JExpression)this.types.schema().staticRef("OPTIONAL_STRING_SCHEMA"));
                    builder.schemaBuilder((JExpression)schemaBuilder);
                    builder.readMethod("toQNameMap");
                    builder.writeMethod("fromQNameMap");
                    return builder.build();
                }
                if (this.types.list().equals(basis)) {
                    JClass valueType = (JClass)args.get(0);
                    State valueState = this.type(codeModel, classOutline, field, (JType)valueType);
                    JExpression valueSchema = valueState.schema();
                    if (valueSchema == null) {
                        valueSchema = valueState.schemaBuilder().invoke("build");
                    }
                    JInvocation schemaBuilder = this.types.schemaBuilder().staticInvoke("array").arg(valueSchema);
                    builder.schemaBuilder((JExpression)schemaBuilder);
                    builder.readMethod("toArray");
                    builder.writeMethod("fromArray");
                    builder.addWriteMethodArgs(valueType.dotclass());
                    return builder.build();
                }
                if (this.types.map().equals(basis)) {
                    JClass valueType;
                    State valueState;
                    JExpression valueSchema;
                    JClass keyType = (JClass)args.get(0);
                    State keyState = this.type(codeModel, classOutline, field, (JType)keyType);
                    JExpression keySchema = keyState.schema();
                    if (keySchema == null) {
                        keySchema = keyState.schemaBuilder().invoke("build");
                    }
                    if ((valueSchema = (valueState = this.type(codeModel, classOutline, field, (JType)(valueType = (JClass)args.get(1)))).schema()) == null) {
                        valueSchema = valueState.schemaBuilder().invoke("build");
                    }
                    JInvocation schemaBuilder = this.types.schemaBuilder().staticInvoke("map").arg(keySchema).arg(valueSchema);
                    builder.schemaBuilder((JExpression)schemaBuilder);
                    builder.readMethod("toMap");
                    builder.writeMethod("fromMap");
                    builder.addWriteMethodArgs(keyType.dotclass());
                    builder.addWriteMethodArgs(valueType.dotclass());
                    return builder.build();
                }
                throw new UnsupportedTypeException(classOutline, field, field.type(), (JType)basis);
            });
        }
        throw new UnsupportedTypeException(classOutline, field, null, field.type());
    }

    FieldState field(JCodeModel codeModel, ClassOutline classOutline, String fieldName, JFieldVar jFieldVar) {
        try {
            log.trace("field() - processing name = '{}' type = '{}'", (Object)fieldName, (Object)jFieldVar.type().name());
            ImmutableFieldState.Builder fieldState = ImmutableFieldState.builder();
            String name = AnnotationUtils.name(codeModel, jFieldVar, fieldName);
            boolean required = AnnotationUtils.required(codeModel, jFieldVar);
            String xmlType = AnnotationUtils.xmlType(codeModel, jFieldVar);
            fieldState.required(required);
            fieldState.name(name);
            fieldState.fieldVar(jFieldVar);
            if (!Strings.isNullOrEmpty((String)xmlType) && !this.targetsEnum(jFieldVar)) {
                log.trace("field() - xmlType = '{}'", (Object)xmlType);
                XmlTypeState xmlTypeState = this.xmlTypeLookup.get(xmlType);
                if (null == xmlTypeState) {
                    throw new UnsupportedOperationException(String.format("%s is not a supported xml type.", xmlType));
                }
                fieldState.from(xmlTypeState);
            } else {
                State jTypeState = this.type(codeModel, classOutline, jFieldVar, jFieldVar.type());
                if (null != jTypeState) {
                    fieldState.from(jTypeState);
                } else if (CLASS_JREFERENCEDCLASS.equals(jFieldVar.type().getClass())) {
                    log.warn("Nothing for {}", (Object)jFieldVar.type().fullName());
                } else {
                    throw new UnsupportedTypeException(classOutline, jFieldVar, null, jFieldVar.type());
                }
            }
            return fieldState.build();
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Exception thrown while building field '%s'. %s", fieldName, classOutline.implClass.name()), ex);
        }
    }

    private boolean targetsEnum(JDefinedClass cls) {
        return ClassType.ENUM == cls.getClassType();
    }

    private boolean targetsEnum(JFieldVar field) {
        if (field.type() instanceof JDefinedClass) {
            return this.targetsEnum((JDefinedClass)field.type());
        }
        return false;
    }

    void fields(JCodeModel codeModel, ClassOutline classOutline, List<FieldState> fieldStates) {
        Map fields = classOutline.implClass.fields();
        for (Map.Entry kvp : fields.entrySet()) {
            String fieldName = (String)kvp.getKey();
            if (CONNECT_SCHEMA_FIELD.equals(fieldName)) continue;
            JFieldVar jFieldVar = (JFieldVar)kvp.getValue();
            FieldState fieldState = this.field(codeModel, classOutline, fieldName, jFieldVar);
            fieldStates.add(fieldState);
        }
        if (classOutline.getSuperClass() != null) {
            this.fields(codeModel, classOutline.getSuperClass(), fieldStates);
        }
    }

    List<FieldState> fields(JCodeModel codeModel, ClassOutline classOutline) {
        ArrayList<FieldState> result = new ArrayList<FieldState>();
        this.fields(codeModel, classOutline, result);
        return result;
    }

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) throws SAXException {
        try {
            JCodeModel codeModel = model.getCodeModel();
            this.setupImportedClasses(codeModel);
            for (ClassOutline classOutline : model.getClasses()) {
                classOutline.implClass._implements(this.types.connectable());
                log.trace("run - {}", (Object)classOutline.implClass.name());
                List<FieldState> fieldStates = this.fields(codeModel, classOutline);
                log.trace("Found {} field(s). {}", (Object)fieldStates.size(), fieldStates);
                JFieldVar schemaField = this.processSchema(codeModel, classOutline, fieldStates);
                this.processToStruct(schemaField, codeModel, classOutline, fieldStates);
                this.processFromStruct(codeModel, classOutline, fieldStates);
            }
            return true;
        }
        catch (Exception e) {
            errorHandler.error(new SAXParseException("Exception thrown while processing: " + e.getMessage(), null, e));
            return false;
        }
    }

    static {
        log = LoggerFactory.getLogger(KafkaConnectPlugin.class);
        try {
            CLASS_JNARROWED = Class.forName("com.sun.codemodel.JNarrowedClass");
            CLASS_JREFERENCEDCLASS = Class.forName("com.sun.codemodel.JCodeModel$JReferencedClass");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

