package com.github.jcustenborder.kafka.connect.xml;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FieldState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFieldState.builder()}.
 */
@Generated(from = "FieldState", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableFieldState implements FieldState {
  private final @Nullable JExpression schema;
  private final JExpression schemaBuilder;
  private final String readMethod;
  private final String writeMethod;
  private final ImmutableList<JExpression> writeMethodArgs;
  private final String name;
  private final JFieldVar fieldVar;
  private final boolean required;
  private final ImmutableList<JExpression> readMethodArgs;

  private ImmutableFieldState(
      @Nullable JExpression schema,
      JExpression schemaBuilder,
      String readMethod,
      String writeMethod,
      ImmutableList<JExpression> writeMethodArgs,
      String name,
      JFieldVar fieldVar,
      boolean required,
      ImmutableList<JExpression> readMethodArgs) {
    this.schema = schema;
    this.schemaBuilder = schemaBuilder;
    this.readMethod = readMethod;
    this.writeMethod = writeMethod;
    this.writeMethodArgs = writeMethodArgs;
    this.name = name;
    this.fieldVar = fieldVar;
    this.required = required;
    this.readMethodArgs = readMethodArgs;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @Override
  public @Nullable JExpression schema() {
    return schema;
  }

  /**
   * @return The value of the {@code schemaBuilder} attribute
   */
  @Override
  public JExpression schemaBuilder() {
    return schemaBuilder;
  }

  /**
   * @return The value of the {@code readMethod} attribute
   */
  @Override
  public String readMethod() {
    return readMethod;
  }

  /**
   * @return The value of the {@code writeMethod} attribute
   */
  @Override
  public String writeMethod() {
    return writeMethod;
  }

  /**
   * @return The value of the {@code writeMethodArgs} attribute
   */
  @Override
  public ImmutableList<JExpression> writeMethodArgs() {
    return writeMethodArgs;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code fieldVar} attribute
   */
  @Override
  public JFieldVar fieldVar() {
    return fieldVar;
  }

  /**
   * @return The value of the {@code required} attribute
   */
  @Override
  public boolean required() {
    return required;
  }

  /**
   * @return The value of the {@code readMethodArgs} attribute
   */
  @Override
  public ImmutableList<JExpression> readMethodArgs() {
    return readMethodArgs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldState#schema() schema} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldState withSchema(@Nullable JExpression value) {
    if (this.schema == value) return this;
    return new ImmutableFieldState(
        value,
        this.schemaBuilder,
        this.readMethod,
        this.writeMethod,
        this.writeMethodArgs,
        this.name,
        this.fieldVar,
        this.required,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldState#schemaBuilder() schemaBuilder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldState withSchemaBuilder(JExpression value) {
    if (this.schemaBuilder == value) return this;
    JExpression newValue = Objects.requireNonNull(value, "schemaBuilder");
    return new ImmutableFieldState(
        this.schema,
        newValue,
        this.readMethod,
        this.writeMethod,
        this.writeMethodArgs,
        this.name,
        this.fieldVar,
        this.required,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldState#readMethod() readMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldState withReadMethod(String value) {
    String newValue = Objects.requireNonNull(value, "readMethod");
    if (this.readMethod.equals(newValue)) return this;
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        newValue,
        this.writeMethod,
        this.writeMethodArgs,
        this.name,
        this.fieldVar,
        this.required,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldState#writeMethod() writeMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for writeMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldState withWriteMethod(String value) {
    String newValue = Objects.requireNonNull(value, "writeMethod");
    if (this.writeMethod.equals(newValue)) return this;
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        newValue,
        this.writeMethodArgs,
        this.name,
        this.fieldVar,
        this.required,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FieldState#writeMethodArgs() writeMethodArgs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFieldState withWriteMethodArgs(JExpression... elements) {
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.writeMethod,
        newValue,
        this.name,
        this.fieldVar,
        this.required,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FieldState#writeMethodArgs() writeMethodArgs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of writeMethodArgs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFieldState withWriteMethodArgs(Iterable<? extends JExpression> elements) {
    if (this.writeMethodArgs == elements) return this;
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.writeMethod,
        newValue,
        this.name,
        this.fieldVar,
        this.required,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldState#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldState withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.writeMethod,
        this.writeMethodArgs,
        newValue,
        this.fieldVar,
        this.required,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldState#fieldVar() fieldVar} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldVar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldState withFieldVar(JFieldVar value) {
    if (this.fieldVar == value) return this;
    JFieldVar newValue = Objects.requireNonNull(value, "fieldVar");
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.writeMethod,
        this.writeMethodArgs,
        this.name,
        newValue,
        this.required,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldState#required() required} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for required
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldState withRequired(boolean value) {
    if (this.required == value) return this;
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.writeMethod,
        this.writeMethodArgs,
        this.name,
        this.fieldVar,
        value,
        this.readMethodArgs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FieldState#readMethodArgs() readMethodArgs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFieldState withReadMethodArgs(JExpression... elements) {
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.writeMethod,
        this.writeMethodArgs,
        this.name,
        this.fieldVar,
        this.required,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FieldState#readMethodArgs() readMethodArgs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of readMethodArgs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFieldState withReadMethodArgs(Iterable<? extends JExpression> elements) {
    if (this.readMethodArgs == elements) return this;
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFieldState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.writeMethod,
        this.writeMethodArgs,
        this.name,
        this.fieldVar,
        this.required,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldState
        && equalTo((ImmutableFieldState) another);
  }

  private boolean equalTo(ImmutableFieldState another) {
    return Objects.equals(schema, another.schema)
        && schemaBuilder.equals(another.schemaBuilder)
        && readMethod.equals(another.readMethod)
        && writeMethod.equals(another.writeMethod)
        && writeMethodArgs.equals(another.writeMethodArgs)
        && name.equals(another.name)
        && fieldVar.equals(another.fieldVar)
        && required == another.required
        && readMethodArgs.equals(another.readMethodArgs);
  }

  /**
   * Computes a hash code from attributes: {@code schema}, {@code schemaBuilder}, {@code readMethod}, {@code writeMethod}, {@code writeMethodArgs}, {@code name}, {@code fieldVar}, {@code required}, {@code readMethodArgs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(schema);
    h += (h << 5) + schemaBuilder.hashCode();
    h += (h << 5) + readMethod.hashCode();
    h += (h << 5) + writeMethod.hashCode();
    h += (h << 5) + writeMethodArgs.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + fieldVar.hashCode();
    h += (h << 5) + Booleans.hashCode(required);
    h += (h << 5) + readMethodArgs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FieldState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FieldState")
        .omitNullValues()
        .add("schema", schema)
        .add("schemaBuilder", schemaBuilder)
        .add("readMethod", readMethod)
        .add("writeMethod", writeMethod)
        .add("writeMethodArgs", writeMethodArgs)
        .add("name", name)
        .add("fieldVar", fieldVar)
        .add("required", required)
        .add("readMethodArgs", readMethodArgs)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FieldState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FieldState instance
   */
  public static ImmutableFieldState copyOf(FieldState instance) {
    if (instance instanceof ImmutableFieldState) {
      return (ImmutableFieldState) instance;
    }
    return ImmutableFieldState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFieldState ImmutableFieldState}.
   * <pre>
   * ImmutableFieldState.builder()
   *    .schema(com.sun.codemodel.JExpression | null) // nullable {@link FieldState#schema() schema}
   *    .schemaBuilder(com.sun.codemodel.JExpression) // required {@link FieldState#schemaBuilder() schemaBuilder}
   *    .readMethod(String) // required {@link FieldState#readMethod() readMethod}
   *    .writeMethod(String) // required {@link FieldState#writeMethod() writeMethod}
   *    .addWriteMethodArgs|addAllWriteMethodArgs(com.sun.codemodel.JExpression) // {@link FieldState#writeMethodArgs() writeMethodArgs} elements
   *    .name(String) // required {@link FieldState#name() name}
   *    .fieldVar(com.sun.codemodel.JFieldVar) // required {@link FieldState#fieldVar() fieldVar}
   *    .required(boolean) // required {@link FieldState#required() required}
   *    .addReadMethodArgs|addAllReadMethodArgs(com.sun.codemodel.JExpression) // {@link FieldState#readMethodArgs() readMethodArgs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableFieldState builder
   */
  public static ImmutableFieldState.Builder builder() {
    return new ImmutableFieldState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFieldState ImmutableFieldState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FieldState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SCHEMA_BUILDER = 0x1L;
    private static final long INIT_BIT_READ_METHOD = 0x2L;
    private static final long INIT_BIT_WRITE_METHOD = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private static final long INIT_BIT_FIELD_VAR = 0x10L;
    private static final long INIT_BIT_REQUIRED = 0x20L;
    private long initBits = 0x3fL;

    private @javax.annotation.Nullable JExpression schema;
    private @javax.annotation.Nullable JExpression schemaBuilder;
    private @javax.annotation.Nullable String readMethod;
    private @javax.annotation.Nullable String writeMethod;
    private ImmutableList.Builder<JExpression> writeMethodArgs = ImmutableList.builder();
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable JFieldVar fieldVar;
    private boolean required;
    private ImmutableList.Builder<JExpression> readMethodArgs = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.xml.FieldState} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldState instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.xml.State} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(State instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof FieldState) {
        FieldState instance = (FieldState) object;
        name(instance.name());
        if ((bits & 0x1L) == 0) {
          addAllReadMethodArgs(instance.readMethodArgs());
          bits |= 0x1L;
        }
        fieldVar(instance.fieldVar());
        required(instance.required());
      }
      if (object instanceof State) {
        State instance = (State) object;
        @Nullable JExpression schemaValue = instance.schema();
        if (schemaValue != null) {
          schema(schemaValue);
        }
        schemaBuilder(instance.schemaBuilder());
        if ((bits & 0x1L) == 0) {
          addAllReadMethodArgs(instance.readMethodArgs());
          bits |= 0x1L;
        }
        writeMethod(instance.writeMethod());
        readMethod(instance.readMethod());
        addAllWriteMethodArgs(instance.writeMethodArgs());
      }
    }

    /**
     * Initializes the value for the {@link FieldState#schema() schema} attribute.
     * @param schema The value for schema (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(@Nullable JExpression schema) {
      this.schema = schema;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldState#schemaBuilder() schemaBuilder} attribute.
     * @param schemaBuilder The value for schemaBuilder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemaBuilder(JExpression schemaBuilder) {
      this.schemaBuilder = Objects.requireNonNull(schemaBuilder, "schemaBuilder");
      initBits &= ~INIT_BIT_SCHEMA_BUILDER;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldState#readMethod() readMethod} attribute.
     * @param readMethod The value for readMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder readMethod(String readMethod) {
      this.readMethod = Objects.requireNonNull(readMethod, "readMethod");
      initBits &= ~INIT_BIT_READ_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldState#writeMethod() writeMethod} attribute.
     * @param writeMethod The value for writeMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeMethod(String writeMethod) {
      this.writeMethod = Objects.requireNonNull(writeMethod, "writeMethod");
      initBits &= ~INIT_BIT_WRITE_METHOD;
      return this;
    }

    /**
     * Adds one element to {@link FieldState#writeMethodArgs() writeMethodArgs} list.
     * @param element A writeMethodArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addWriteMethodArgs(JExpression element) {
      this.writeMethodArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FieldState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An array of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addWriteMethodArgs(JExpression... elements) {
      this.writeMethodArgs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FieldState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An iterable of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeMethodArgs(Iterable<? extends JExpression> elements) {
      this.writeMethodArgs = ImmutableList.builder();
      return addAllWriteMethodArgs(elements);
    }

    /**
     * Adds elements to {@link FieldState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An iterable of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllWriteMethodArgs(Iterable<? extends JExpression> elements) {
      this.writeMethodArgs.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link FieldState#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldState#fieldVar() fieldVar} attribute.
     * @param fieldVar The value for fieldVar 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fieldVar(JFieldVar fieldVar) {
      this.fieldVar = Objects.requireNonNull(fieldVar, "fieldVar");
      initBits &= ~INIT_BIT_FIELD_VAR;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldState#required() required} attribute.
     * @param required The value for required 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder required(boolean required) {
      this.required = required;
      initBits &= ~INIT_BIT_REQUIRED;
      return this;
    }

    /**
     * Adds one element to {@link FieldState#readMethodArgs() readMethodArgs} list.
     * @param element A readMethodArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addReadMethodArgs(JExpression element) {
      this.readMethodArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FieldState#readMethodArgs() readMethodArgs} list.
     * @param elements An array of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addReadMethodArgs(JExpression... elements) {
      this.readMethodArgs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FieldState#readMethodArgs() readMethodArgs} list.
     * @param elements An iterable of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder readMethodArgs(Iterable<? extends JExpression> elements) {
      this.readMethodArgs = ImmutableList.builder();
      return addAllReadMethodArgs(elements);
    }

    /**
     * Adds elements to {@link FieldState#readMethodArgs() readMethodArgs} list.
     * @param elements An iterable of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllReadMethodArgs(Iterable<? extends JExpression> elements) {
      this.readMethodArgs.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldState ImmutableFieldState}.
     * @return An immutable instance of FieldState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFieldState(
          schema,
          schemaBuilder,
          readMethod,
          writeMethod,
          writeMethodArgs.build(),
          name,
          fieldVar,
          required,
          readMethodArgs.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SCHEMA_BUILDER) != 0) attributes.add("schemaBuilder");
      if ((initBits & INIT_BIT_READ_METHOD) != 0) attributes.add("readMethod");
      if ((initBits & INIT_BIT_WRITE_METHOD) != 0) attributes.add("writeMethod");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_FIELD_VAR) != 0) attributes.add("fieldVar");
      if ((initBits & INIT_BIT_REQUIRED) != 0) attributes.add("required");
      return "Cannot build FieldState, some of required attributes are not set " + attributes;
    }
  }
}
