package com.github.jcustenborder.kafka.connect.xml;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Types}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTypes.builder()}.
 */
@Generated(from = "Types", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableTypes implements Types {
  private final JClass struct;
  private final JClass timestamp;
  private final JClass time;
  private final JClass date;
  private final JClass decimal;
  private final JClass schemaBuilder;
  private final JClass schema;
  private final JClass connectable;
  private final JClass connectableHelper;
  private final JClass list;
  private final JClass map;
  private final JClass qName;
  private final JClass qNameMap;
  private final JClass string;
  private final JClass arrayList;
  private final JClass bigDecimal;
  private final JClass bigInteger;
  private final JClass xmlGregorianCalendar;
  private final ImmutableSet<JType> blackListTypes;

  private ImmutableTypes(
      JClass struct,
      JClass timestamp,
      JClass time,
      JClass date,
      JClass decimal,
      JClass schemaBuilder,
      JClass schema,
      JClass connectable,
      JClass connectableHelper,
      JClass list,
      JClass map,
      JClass qName,
      JClass qNameMap,
      JClass string,
      JClass arrayList,
      JClass bigDecimal,
      JClass bigInteger,
      JClass xmlGregorianCalendar,
      ImmutableSet<JType> blackListTypes) {
    this.struct = struct;
    this.timestamp = timestamp;
    this.time = time;
    this.date = date;
    this.decimal = decimal;
    this.schemaBuilder = schemaBuilder;
    this.schema = schema;
    this.connectable = connectable;
    this.connectableHelper = connectableHelper;
    this.list = list;
    this.map = map;
    this.qName = qName;
    this.qNameMap = qNameMap;
    this.string = string;
    this.arrayList = arrayList;
    this.bigDecimal = bigDecimal;
    this.bigInteger = bigInteger;
    this.xmlGregorianCalendar = xmlGregorianCalendar;
    this.blackListTypes = blackListTypes;
  }

  /**
   * @return The value of the {@code struct} attribute
   */
  @Override
  public JClass struct() {
    return struct;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @Override
  public JClass timestamp() {
    return timestamp;
  }

  /**
   * @return The value of the {@code time} attribute
   */
  @Override
  public JClass time() {
    return time;
  }

  /**
   * @return The value of the {@code date} attribute
   */
  @Override
  public JClass date() {
    return date;
  }

  /**
   * @return The value of the {@code decimal} attribute
   */
  @Override
  public JClass decimal() {
    return decimal;
  }

  /**
   * @return The value of the {@code schemaBuilder} attribute
   */
  @Override
  public JClass schemaBuilder() {
    return schemaBuilder;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @Override
  public JClass schema() {
    return schema;
  }

  /**
   * @return The value of the {@code connectable} attribute
   */
  @Override
  public JClass connectable() {
    return connectable;
  }

  /**
   * @return The value of the {@code connectableHelper} attribute
   */
  @Override
  public JClass connectableHelper() {
    return connectableHelper;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public JClass list() {
    return list;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public JClass map() {
    return map;
  }

  /**
   * @return The value of the {@code qName} attribute
   */
  @Override
  public JClass qName() {
    return qName;
  }

  /**
   * @return The value of the {@code qNameMap} attribute
   */
  @Override
  public JClass qNameMap() {
    return qNameMap;
  }

  /**
   * @return The value of the {@code string} attribute
   */
  @Override
  public JClass string() {
    return string;
  }

  /**
   * @return The value of the {@code arrayList} attribute
   */
  @Override
  public JClass arrayList() {
    return arrayList;
  }

  /**
   * @return The value of the {@code bigDecimal} attribute
   */
  @Override
  public JClass bigDecimal() {
    return bigDecimal;
  }

  /**
   * @return The value of the {@code bigInteger} attribute
   */
  @Override
  public JClass bigInteger() {
    return bigInteger;
  }

  /**
   * @return The value of the {@code xmlGregorianCalendar} attribute
   */
  @Override
  public JClass xmlGregorianCalendar() {
    return xmlGregorianCalendar;
  }

  /**
   * @return The value of the {@code blackListTypes} attribute
   */
  @Override
  public ImmutableSet<JType> blackListTypes() {
    return blackListTypes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#struct() struct} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for struct
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withStruct(JClass value) {
    if (this.struct == value) return this;
    JClass newValue = Objects.requireNonNull(value, "struct");
    return new ImmutableTypes(
        newValue,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#timestamp() timestamp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withTimestamp(JClass value) {
    if (this.timestamp == value) return this;
    JClass newValue = Objects.requireNonNull(value, "timestamp");
    return new ImmutableTypes(
        this.struct,
        newValue,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#time() time} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for time
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withTime(JClass value) {
    if (this.time == value) return this;
    JClass newValue = Objects.requireNonNull(value, "time");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        newValue,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#date() date} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for date
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withDate(JClass value) {
    if (this.date == value) return this;
    JClass newValue = Objects.requireNonNull(value, "date");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        newValue,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#decimal() decimal} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decimal
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withDecimal(JClass value) {
    if (this.decimal == value) return this;
    JClass newValue = Objects.requireNonNull(value, "decimal");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        newValue,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#schemaBuilder() schemaBuilder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withSchemaBuilder(JClass value) {
    if (this.schemaBuilder == value) return this;
    JClass newValue = Objects.requireNonNull(value, "schemaBuilder");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        newValue,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#schema() schema} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withSchema(JClass value) {
    if (this.schema == value) return this;
    JClass newValue = Objects.requireNonNull(value, "schema");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        newValue,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#connectable() connectable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withConnectable(JClass value) {
    if (this.connectable == value) return this;
    JClass newValue = Objects.requireNonNull(value, "connectable");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        newValue,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#connectableHelper() connectableHelper} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectableHelper
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withConnectableHelper(JClass value) {
    if (this.connectableHelper == value) return this;
    JClass newValue = Objects.requireNonNull(value, "connectableHelper");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        newValue,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#list() list} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for list
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withList(JClass value) {
    if (this.list == value) return this;
    JClass newValue = Objects.requireNonNull(value, "list");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        newValue,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#map() map} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for map
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withMap(JClass value) {
    if (this.map == value) return this;
    JClass newValue = Objects.requireNonNull(value, "map");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        newValue,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#qName() qName} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withQName(JClass value) {
    if (this.qName == value) return this;
    JClass newValue = Objects.requireNonNull(value, "qName");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        newValue,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#qNameMap() qNameMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qNameMap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withQNameMap(JClass value) {
    if (this.qNameMap == value) return this;
    JClass newValue = Objects.requireNonNull(value, "qNameMap");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        newValue,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#string() string} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for string
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withString(JClass value) {
    if (this.string == value) return this;
    JClass newValue = Objects.requireNonNull(value, "string");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        newValue,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#arrayList() arrayList} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for arrayList
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withArrayList(JClass value) {
    if (this.arrayList == value) return this;
    JClass newValue = Objects.requireNonNull(value, "arrayList");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        newValue,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#bigDecimal() bigDecimal} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bigDecimal
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withBigDecimal(JClass value) {
    if (this.bigDecimal == value) return this;
    JClass newValue = Objects.requireNonNull(value, "bigDecimal");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        newValue,
        this.bigInteger,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#bigInteger() bigInteger} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bigInteger
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withBigInteger(JClass value) {
    if (this.bigInteger == value) return this;
    JClass newValue = Objects.requireNonNull(value, "bigInteger");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        newValue,
        this.xmlGregorianCalendar,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Types#xmlGregorianCalendar() xmlGregorianCalendar} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for xmlGregorianCalendar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypes withXmlGregorianCalendar(JClass value) {
    if (this.xmlGregorianCalendar == value) return this;
    JClass newValue = Objects.requireNonNull(value, "xmlGregorianCalendar");
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        newValue,
        this.blackListTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Types#blackListTypes() blackListTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTypes withBlackListTypes(JType... elements) {
    ImmutableSet<JType> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Types#blackListTypes() blackListTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blackListTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTypes withBlackListTypes(Iterable<? extends JType> elements) {
    if (this.blackListTypes == elements) return this;
    ImmutableSet<JType> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableTypes(
        this.struct,
        this.timestamp,
        this.time,
        this.date,
        this.decimal,
        this.schemaBuilder,
        this.schema,
        this.connectable,
        this.connectableHelper,
        this.list,
        this.map,
        this.qName,
        this.qNameMap,
        this.string,
        this.arrayList,
        this.bigDecimal,
        this.bigInteger,
        this.xmlGregorianCalendar,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTypes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTypes
        && equalTo((ImmutableTypes) another);
  }

  private boolean equalTo(ImmutableTypes another) {
    return struct.equals(another.struct)
        && timestamp.equals(another.timestamp)
        && time.equals(another.time)
        && date.equals(another.date)
        && decimal.equals(another.decimal)
        && schemaBuilder.equals(another.schemaBuilder)
        && schema.equals(another.schema)
        && connectable.equals(another.connectable)
        && connectableHelper.equals(another.connectableHelper)
        && list.equals(another.list)
        && map.equals(another.map)
        && qName.equals(another.qName)
        && qNameMap.equals(another.qNameMap)
        && string.equals(another.string)
        && arrayList.equals(another.arrayList)
        && bigDecimal.equals(another.bigDecimal)
        && bigInteger.equals(another.bigInteger)
        && xmlGregorianCalendar.equals(another.xmlGregorianCalendar)
        && blackListTypes.equals(another.blackListTypes);
  }

  /**
   * Computes a hash code from attributes: {@code struct}, {@code timestamp}, {@code time}, {@code date}, {@code decimal}, {@code schemaBuilder}, {@code schema}, {@code connectable}, {@code connectableHelper}, {@code list}, {@code map}, {@code qName}, {@code qNameMap}, {@code string}, {@code arrayList}, {@code bigDecimal}, {@code bigInteger}, {@code xmlGregorianCalendar}, {@code blackListTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + struct.hashCode();
    h += (h << 5) + timestamp.hashCode();
    h += (h << 5) + time.hashCode();
    h += (h << 5) + date.hashCode();
    h += (h << 5) + decimal.hashCode();
    h += (h << 5) + schemaBuilder.hashCode();
    h += (h << 5) + schema.hashCode();
    h += (h << 5) + connectable.hashCode();
    h += (h << 5) + connectableHelper.hashCode();
    h += (h << 5) + list.hashCode();
    h += (h << 5) + map.hashCode();
    h += (h << 5) + qName.hashCode();
    h += (h << 5) + qNameMap.hashCode();
    h += (h << 5) + string.hashCode();
    h += (h << 5) + arrayList.hashCode();
    h += (h << 5) + bigDecimal.hashCode();
    h += (h << 5) + bigInteger.hashCode();
    h += (h << 5) + xmlGregorianCalendar.hashCode();
    h += (h << 5) + blackListTypes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Types} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Types")
        .omitNullValues()
        .add("struct", struct)
        .add("timestamp", timestamp)
        .add("time", time)
        .add("date", date)
        .add("decimal", decimal)
        .add("schemaBuilder", schemaBuilder)
        .add("schema", schema)
        .add("connectable", connectable)
        .add("connectableHelper", connectableHelper)
        .add("list", list)
        .add("map", map)
        .add("qName", qName)
        .add("qNameMap", qNameMap)
        .add("string", string)
        .add("arrayList", arrayList)
        .add("bigDecimal", bigDecimal)
        .add("bigInteger", bigInteger)
        .add("xmlGregorianCalendar", xmlGregorianCalendar)
        .add("blackListTypes", blackListTypes)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Types} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Types instance
   */
  public static ImmutableTypes copyOf(Types instance) {
    if (instance instanceof ImmutableTypes) {
      return (ImmutableTypes) instance;
    }
    return ImmutableTypes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTypes ImmutableTypes}.
   * <pre>
   * ImmutableTypes.builder()
   *    .struct(com.sun.codemodel.JClass) // required {@link Types#struct() struct}
   *    .timestamp(com.sun.codemodel.JClass) // required {@link Types#timestamp() timestamp}
   *    .time(com.sun.codemodel.JClass) // required {@link Types#time() time}
   *    .date(com.sun.codemodel.JClass) // required {@link Types#date() date}
   *    .decimal(com.sun.codemodel.JClass) // required {@link Types#decimal() decimal}
   *    .schemaBuilder(com.sun.codemodel.JClass) // required {@link Types#schemaBuilder() schemaBuilder}
   *    .schema(com.sun.codemodel.JClass) // required {@link Types#schema() schema}
   *    .connectable(com.sun.codemodel.JClass) // required {@link Types#connectable() connectable}
   *    .connectableHelper(com.sun.codemodel.JClass) // required {@link Types#connectableHelper() connectableHelper}
   *    .list(com.sun.codemodel.JClass) // required {@link Types#list() list}
   *    .map(com.sun.codemodel.JClass) // required {@link Types#map() map}
   *    .qName(com.sun.codemodel.JClass) // required {@link Types#qName() qName}
   *    .qNameMap(com.sun.codemodel.JClass) // required {@link Types#qNameMap() qNameMap}
   *    .string(com.sun.codemodel.JClass) // required {@link Types#string() string}
   *    .arrayList(com.sun.codemodel.JClass) // required {@link Types#arrayList() arrayList}
   *    .bigDecimal(com.sun.codemodel.JClass) // required {@link Types#bigDecimal() bigDecimal}
   *    .bigInteger(com.sun.codemodel.JClass) // required {@link Types#bigInteger() bigInteger}
   *    .xmlGregorianCalendar(com.sun.codemodel.JClass) // required {@link Types#xmlGregorianCalendar() xmlGregorianCalendar}
   *    .addBlackListTypes|addAllBlackListTypes(com.sun.codemodel.JType) // {@link Types#blackListTypes() blackListTypes} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTypes builder
   */
  public static ImmutableTypes.Builder builder() {
    return new ImmutableTypes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTypes ImmutableTypes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Types", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STRUCT = 0x1L;
    private static final long INIT_BIT_TIMESTAMP = 0x2L;
    private static final long INIT_BIT_TIME = 0x4L;
    private static final long INIT_BIT_DATE = 0x8L;
    private static final long INIT_BIT_DECIMAL = 0x10L;
    private static final long INIT_BIT_SCHEMA_BUILDER = 0x20L;
    private static final long INIT_BIT_SCHEMA = 0x40L;
    private static final long INIT_BIT_CONNECTABLE = 0x80L;
    private static final long INIT_BIT_CONNECTABLE_HELPER = 0x100L;
    private static final long INIT_BIT_LIST = 0x200L;
    private static final long INIT_BIT_MAP = 0x400L;
    private static final long INIT_BIT_Q_NAME = 0x800L;
    private static final long INIT_BIT_Q_NAME_MAP = 0x1000L;
    private static final long INIT_BIT_STRING = 0x2000L;
    private static final long INIT_BIT_ARRAY_LIST = 0x4000L;
    private static final long INIT_BIT_BIG_DECIMAL = 0x8000L;
    private static final long INIT_BIT_BIG_INTEGER = 0x10000L;
    private static final long INIT_BIT_XML_GREGORIAN_CALENDAR = 0x20000L;
    private long initBits = 0x3ffffL;

    private @Nullable JClass struct;
    private @Nullable JClass timestamp;
    private @Nullable JClass time;
    private @Nullable JClass date;
    private @Nullable JClass decimal;
    private @Nullable JClass schemaBuilder;
    private @Nullable JClass schema;
    private @Nullable JClass connectable;
    private @Nullable JClass connectableHelper;
    private @Nullable JClass list;
    private @Nullable JClass map;
    private @Nullable JClass qName;
    private @Nullable JClass qNameMap;
    private @Nullable JClass string;
    private @Nullable JClass arrayList;
    private @Nullable JClass bigDecimal;
    private @Nullable JClass bigInteger;
    private @Nullable JClass xmlGregorianCalendar;
    private ImmutableSet.Builder<JType> blackListTypes = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Types} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Types instance) {
      Objects.requireNonNull(instance, "instance");
      struct(instance.struct());
      timestamp(instance.timestamp());
      time(instance.time());
      date(instance.date());
      decimal(instance.decimal());
      schemaBuilder(instance.schemaBuilder());
      schema(instance.schema());
      connectable(instance.connectable());
      connectableHelper(instance.connectableHelper());
      list(instance.list());
      map(instance.map());
      qName(instance.qName());
      qNameMap(instance.qNameMap());
      string(instance.string());
      arrayList(instance.arrayList());
      bigDecimal(instance.bigDecimal());
      bigInteger(instance.bigInteger());
      xmlGregorianCalendar(instance.xmlGregorianCalendar());
      addAllBlackListTypes(instance.blackListTypes());
      return this;
    }

    /**
     * Initializes the value for the {@link Types#struct() struct} attribute.
     * @param struct The value for struct 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder struct(JClass struct) {
      this.struct = Objects.requireNonNull(struct, "struct");
      initBits &= ~INIT_BIT_STRUCT;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#timestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(JClass timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#time() time} attribute.
     * @param time The value for time 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder time(JClass time) {
      this.time = Objects.requireNonNull(time, "time");
      initBits &= ~INIT_BIT_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#date() date} attribute.
     * @param date The value for date 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder date(JClass date) {
      this.date = Objects.requireNonNull(date, "date");
      initBits &= ~INIT_BIT_DATE;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#decimal() decimal} attribute.
     * @param decimal The value for decimal 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder decimal(JClass decimal) {
      this.decimal = Objects.requireNonNull(decimal, "decimal");
      initBits &= ~INIT_BIT_DECIMAL;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#schemaBuilder() schemaBuilder} attribute.
     * @param schemaBuilder The value for schemaBuilder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemaBuilder(JClass schemaBuilder) {
      this.schemaBuilder = Objects.requireNonNull(schemaBuilder, "schemaBuilder");
      initBits &= ~INIT_BIT_SCHEMA_BUILDER;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#schema() schema} attribute.
     * @param schema The value for schema 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(JClass schema) {
      this.schema = Objects.requireNonNull(schema, "schema");
      initBits &= ~INIT_BIT_SCHEMA;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#connectable() connectable} attribute.
     * @param connectable The value for connectable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectable(JClass connectable) {
      this.connectable = Objects.requireNonNull(connectable, "connectable");
      initBits &= ~INIT_BIT_CONNECTABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#connectableHelper() connectableHelper} attribute.
     * @param connectableHelper The value for connectableHelper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectableHelper(JClass connectableHelper) {
      this.connectableHelper = Objects.requireNonNull(connectableHelper, "connectableHelper");
      initBits &= ~INIT_BIT_CONNECTABLE_HELPER;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#list() list} attribute.
     * @param list The value for list 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder list(JClass list) {
      this.list = Objects.requireNonNull(list, "list");
      initBits &= ~INIT_BIT_LIST;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#map() map} attribute.
     * @param map The value for map 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder map(JClass map) {
      this.map = Objects.requireNonNull(map, "map");
      initBits &= ~INIT_BIT_MAP;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#qName() qName} attribute.
     * @param qName The value for qName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder qName(JClass qName) {
      this.qName = Objects.requireNonNull(qName, "qName");
      initBits &= ~INIT_BIT_Q_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#qNameMap() qNameMap} attribute.
     * @param qNameMap The value for qNameMap 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder qNameMap(JClass qNameMap) {
      this.qNameMap = Objects.requireNonNull(qNameMap, "qNameMap");
      initBits &= ~INIT_BIT_Q_NAME_MAP;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#string() string} attribute.
     * @param string The value for string 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder string(JClass string) {
      this.string = Objects.requireNonNull(string, "string");
      initBits &= ~INIT_BIT_STRING;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#arrayList() arrayList} attribute.
     * @param arrayList The value for arrayList 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder arrayList(JClass arrayList) {
      this.arrayList = Objects.requireNonNull(arrayList, "arrayList");
      initBits &= ~INIT_BIT_ARRAY_LIST;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#bigDecimal() bigDecimal} attribute.
     * @param bigDecimal The value for bigDecimal 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bigDecimal(JClass bigDecimal) {
      this.bigDecimal = Objects.requireNonNull(bigDecimal, "bigDecimal");
      initBits &= ~INIT_BIT_BIG_DECIMAL;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#bigInteger() bigInteger} attribute.
     * @param bigInteger The value for bigInteger 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bigInteger(JClass bigInteger) {
      this.bigInteger = Objects.requireNonNull(bigInteger, "bigInteger");
      initBits &= ~INIT_BIT_BIG_INTEGER;
      return this;
    }

    /**
     * Initializes the value for the {@link Types#xmlGregorianCalendar() xmlGregorianCalendar} attribute.
     * @param xmlGregorianCalendar The value for xmlGregorianCalendar 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder xmlGregorianCalendar(JClass xmlGregorianCalendar) {
      this.xmlGregorianCalendar = Objects.requireNonNull(xmlGregorianCalendar, "xmlGregorianCalendar");
      initBits &= ~INIT_BIT_XML_GREGORIAN_CALENDAR;
      return this;
    }

    /**
     * Adds one element to {@link Types#blackListTypes() blackListTypes} set.
     * @param element A blackListTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlackListTypes(JType element) {
      this.blackListTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Types#blackListTypes() blackListTypes} set.
     * @param elements An array of blackListTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlackListTypes(JType... elements) {
      this.blackListTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Types#blackListTypes() blackListTypes} set.
     * @param elements An iterable of blackListTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blackListTypes(Iterable<? extends JType> elements) {
      this.blackListTypes = ImmutableSet.builder();
      return addAllBlackListTypes(elements);
    }

    /**
     * Adds elements to {@link Types#blackListTypes() blackListTypes} set.
     * @param elements An iterable of blackListTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlackListTypes(Iterable<? extends JType> elements) {
      this.blackListTypes.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTypes ImmutableTypes}.
     * @return An immutable instance of Types
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTypes build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTypes(
          struct,
          timestamp,
          time,
          date,
          decimal,
          schemaBuilder,
          schema,
          connectable,
          connectableHelper,
          list,
          map,
          qName,
          qNameMap,
          string,
          arrayList,
          bigDecimal,
          bigInteger,
          xmlGregorianCalendar,
          blackListTypes.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STRUCT) != 0) attributes.add("struct");
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
      if ((initBits & INIT_BIT_DATE) != 0) attributes.add("date");
      if ((initBits & INIT_BIT_DECIMAL) != 0) attributes.add("decimal");
      if ((initBits & INIT_BIT_SCHEMA_BUILDER) != 0) attributes.add("schemaBuilder");
      if ((initBits & INIT_BIT_SCHEMA) != 0) attributes.add("schema");
      if ((initBits & INIT_BIT_CONNECTABLE) != 0) attributes.add("connectable");
      if ((initBits & INIT_BIT_CONNECTABLE_HELPER) != 0) attributes.add("connectableHelper");
      if ((initBits & INIT_BIT_LIST) != 0) attributes.add("list");
      if ((initBits & INIT_BIT_MAP) != 0) attributes.add("map");
      if ((initBits & INIT_BIT_Q_NAME) != 0) attributes.add("qName");
      if ((initBits & INIT_BIT_Q_NAME_MAP) != 0) attributes.add("qNameMap");
      if ((initBits & INIT_BIT_STRING) != 0) attributes.add("string");
      if ((initBits & INIT_BIT_ARRAY_LIST) != 0) attributes.add("arrayList");
      if ((initBits & INIT_BIT_BIG_DECIMAL) != 0) attributes.add("bigDecimal");
      if ((initBits & INIT_BIT_BIG_INTEGER) != 0) attributes.add("bigInteger");
      if ((initBits & INIT_BIT_XML_GREGORIAN_CALENDAR) != 0) attributes.add("xmlGregorianCalendar");
      return "Cannot build Types, some of required attributes are not set " + attributes;
    }
  }
}
