package com.github.jcustenborder.kafka.connect.xml;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.sun.codemodel.JExpression;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link XmlTypeState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableXmlTypeState.builder()}.
 */
@Generated(from = "XmlTypeState", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableXmlTypeState implements XmlTypeState {
  private final @Nullable JExpression schema;
  private final JExpression schemaBuilder;
  private final String readMethod;
  private final ImmutableList<JExpression> readMethodArgs;
  private final String writeMethod;
  private final ImmutableList<JExpression> writeMethodArgs;
  private final ImmutableList<String> xmlTypes;

  private ImmutableXmlTypeState(
      @Nullable JExpression schema,
      JExpression schemaBuilder,
      String readMethod,
      ImmutableList<JExpression> readMethodArgs,
      String writeMethod,
      ImmutableList<JExpression> writeMethodArgs,
      ImmutableList<String> xmlTypes) {
    this.schema = schema;
    this.schemaBuilder = schemaBuilder;
    this.readMethod = readMethod;
    this.readMethodArgs = readMethodArgs;
    this.writeMethod = writeMethod;
    this.writeMethodArgs = writeMethodArgs;
    this.xmlTypes = xmlTypes;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @Override
  public @Nullable JExpression schema() {
    return schema;
  }

  /**
   * @return The value of the {@code schemaBuilder} attribute
   */
  @Override
  public JExpression schemaBuilder() {
    return schemaBuilder;
  }

  /**
   * @return The value of the {@code readMethod} attribute
   */
  @Override
  public String readMethod() {
    return readMethod;
  }

  /**
   * @return The value of the {@code readMethodArgs} attribute
   */
  @Override
  public ImmutableList<JExpression> readMethodArgs() {
    return readMethodArgs;
  }

  /**
   * @return The value of the {@code writeMethod} attribute
   */
  @Override
  public String writeMethod() {
    return writeMethod;
  }

  /**
   * @return The value of the {@code writeMethodArgs} attribute
   */
  @Override
  public ImmutableList<JExpression> writeMethodArgs() {
    return writeMethodArgs;
  }

  /**
   * @return The value of the {@code xmlTypes} attribute
   */
  @Override
  public ImmutableList<String> xmlTypes() {
    return xmlTypes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link XmlTypeState#schema() schema} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableXmlTypeState withSchema(@Nullable JExpression value) {
    if (this.schema == value) return this;
    return new ImmutableXmlTypeState(
        value,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs,
        this.xmlTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link XmlTypeState#schemaBuilder() schemaBuilder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableXmlTypeState withSchemaBuilder(JExpression value) {
    if (this.schemaBuilder == value) return this;
    JExpression newValue = Objects.requireNonNull(value, "schemaBuilder");
    return new ImmutableXmlTypeState(
        this.schema,
        newValue,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs,
        this.xmlTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link XmlTypeState#readMethod() readMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableXmlTypeState withReadMethod(String value) {
    String newValue = Objects.requireNonNull(value, "readMethod");
    if (this.readMethod.equals(newValue)) return this;
    return new ImmutableXmlTypeState(
        this.schema,
        this.schemaBuilder,
        newValue,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs,
        this.xmlTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link XmlTypeState#readMethodArgs() readMethodArgs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableXmlTypeState withReadMethodArgs(JExpression... elements) {
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableXmlTypeState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        newValue,
        this.writeMethod,
        this.writeMethodArgs,
        this.xmlTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link XmlTypeState#readMethodArgs() readMethodArgs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of readMethodArgs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableXmlTypeState withReadMethodArgs(Iterable<? extends JExpression> elements) {
    if (this.readMethodArgs == elements) return this;
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableXmlTypeState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        newValue,
        this.writeMethod,
        this.writeMethodArgs,
        this.xmlTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link XmlTypeState#writeMethod() writeMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for writeMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableXmlTypeState withWriteMethod(String value) {
    String newValue = Objects.requireNonNull(value, "writeMethod");
    if (this.writeMethod.equals(newValue)) return this;
    return new ImmutableXmlTypeState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        newValue,
        this.writeMethodArgs,
        this.xmlTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link XmlTypeState#writeMethodArgs() writeMethodArgs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableXmlTypeState withWriteMethodArgs(JExpression... elements) {
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableXmlTypeState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        newValue,
        this.xmlTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link XmlTypeState#writeMethodArgs() writeMethodArgs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of writeMethodArgs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableXmlTypeState withWriteMethodArgs(Iterable<? extends JExpression> elements) {
    if (this.writeMethodArgs == elements) return this;
    ImmutableList<JExpression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableXmlTypeState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        newValue,
        this.xmlTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link XmlTypeState#xmlTypes() xmlTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableXmlTypeState withXmlTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableXmlTypeState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link XmlTypeState#xmlTypes() xmlTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of xmlTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableXmlTypeState withXmlTypes(Iterable<String> elements) {
    if (this.xmlTypes == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableXmlTypeState(
        this.schema,
        this.schemaBuilder,
        this.readMethod,
        this.readMethodArgs,
        this.writeMethod,
        this.writeMethodArgs,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableXmlTypeState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableXmlTypeState
        && equalTo((ImmutableXmlTypeState) another);
  }

  private boolean equalTo(ImmutableXmlTypeState another) {
    return Objects.equals(schema, another.schema)
        && schemaBuilder.equals(another.schemaBuilder)
        && readMethod.equals(another.readMethod)
        && readMethodArgs.equals(another.readMethodArgs)
        && writeMethod.equals(another.writeMethod)
        && writeMethodArgs.equals(another.writeMethodArgs)
        && xmlTypes.equals(another.xmlTypes);
  }

  /**
   * Computes a hash code from attributes: {@code schema}, {@code schemaBuilder}, {@code readMethod}, {@code readMethodArgs}, {@code writeMethod}, {@code writeMethodArgs}, {@code xmlTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(schema);
    h += (h << 5) + schemaBuilder.hashCode();
    h += (h << 5) + readMethod.hashCode();
    h += (h << 5) + readMethodArgs.hashCode();
    h += (h << 5) + writeMethod.hashCode();
    h += (h << 5) + writeMethodArgs.hashCode();
    h += (h << 5) + xmlTypes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code XmlTypeState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("XmlTypeState")
        .omitNullValues()
        .add("schema", schema)
        .add("schemaBuilder", schemaBuilder)
        .add("readMethod", readMethod)
        .add("readMethodArgs", readMethodArgs)
        .add("writeMethod", writeMethod)
        .add("writeMethodArgs", writeMethodArgs)
        .add("xmlTypes", xmlTypes)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link XmlTypeState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable XmlTypeState instance
   */
  public static ImmutableXmlTypeState copyOf(XmlTypeState instance) {
    if (instance instanceof ImmutableXmlTypeState) {
      return (ImmutableXmlTypeState) instance;
    }
    return ImmutableXmlTypeState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableXmlTypeState ImmutableXmlTypeState}.
   * <pre>
   * ImmutableXmlTypeState.builder()
   *    .schema(com.sun.codemodel.JExpression | null) // nullable {@link XmlTypeState#schema() schema}
   *    .schemaBuilder(com.sun.codemodel.JExpression) // required {@link XmlTypeState#schemaBuilder() schemaBuilder}
   *    .readMethod(String) // required {@link XmlTypeState#readMethod() readMethod}
   *    .addReadMethodArgs|addAllReadMethodArgs(com.sun.codemodel.JExpression) // {@link XmlTypeState#readMethodArgs() readMethodArgs} elements
   *    .writeMethod(String) // required {@link XmlTypeState#writeMethod() writeMethod}
   *    .addWriteMethodArgs|addAllWriteMethodArgs(com.sun.codemodel.JExpression) // {@link XmlTypeState#writeMethodArgs() writeMethodArgs} elements
   *    .addXmlTypes|addAllXmlTypes(String) // {@link XmlTypeState#xmlTypes() xmlTypes} elements
   *    .build();
   * </pre>
   * @return A new ImmutableXmlTypeState builder
   */
  public static ImmutableXmlTypeState.Builder builder() {
    return new ImmutableXmlTypeState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableXmlTypeState ImmutableXmlTypeState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "XmlTypeState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SCHEMA_BUILDER = 0x1L;
    private static final long INIT_BIT_READ_METHOD = 0x2L;
    private static final long INIT_BIT_WRITE_METHOD = 0x4L;
    private long initBits = 0x7L;

    private @javax.annotation.Nullable JExpression schema;
    private @javax.annotation.Nullable JExpression schemaBuilder;
    private @javax.annotation.Nullable String readMethod;
    private ImmutableList.Builder<JExpression> readMethodArgs = ImmutableList.builder();
    private @javax.annotation.Nullable String writeMethod;
    private ImmutableList.Builder<JExpression> writeMethodArgs = ImmutableList.builder();
    private ImmutableList.Builder<String> xmlTypes = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.xml.XmlTypeState} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(XmlTypeState instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.jcustenborder.kafka.connect.xml.State} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(State instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof XmlTypeState) {
        XmlTypeState instance = (XmlTypeState) object;
        addAllXmlTypes(instance.xmlTypes());
      }
      if (object instanceof State) {
        State instance = (State) object;
        @Nullable JExpression schemaValue = instance.schema();
        if (schemaValue != null) {
          schema(schemaValue);
        }
        schemaBuilder(instance.schemaBuilder());
        addAllReadMethodArgs(instance.readMethodArgs());
        writeMethod(instance.writeMethod());
        readMethod(instance.readMethod());
        addAllWriteMethodArgs(instance.writeMethodArgs());
      }
    }

    /**
     * Initializes the value for the {@link XmlTypeState#schema() schema} attribute.
     * @param schema The value for schema (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(@Nullable JExpression schema) {
      this.schema = schema;
      return this;
    }

    /**
     * Initializes the value for the {@link XmlTypeState#schemaBuilder() schemaBuilder} attribute.
     * @param schemaBuilder The value for schemaBuilder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemaBuilder(JExpression schemaBuilder) {
      this.schemaBuilder = Objects.requireNonNull(schemaBuilder, "schemaBuilder");
      initBits &= ~INIT_BIT_SCHEMA_BUILDER;
      return this;
    }

    /**
     * Initializes the value for the {@link XmlTypeState#readMethod() readMethod} attribute.
     * @param readMethod The value for readMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder readMethod(String readMethod) {
      this.readMethod = Objects.requireNonNull(readMethod, "readMethod");
      initBits &= ~INIT_BIT_READ_METHOD;
      return this;
    }

    /**
     * Adds one element to {@link XmlTypeState#readMethodArgs() readMethodArgs} list.
     * @param element A readMethodArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addReadMethodArgs(JExpression element) {
      this.readMethodArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link XmlTypeState#readMethodArgs() readMethodArgs} list.
     * @param elements An array of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addReadMethodArgs(JExpression... elements) {
      this.readMethodArgs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link XmlTypeState#readMethodArgs() readMethodArgs} list.
     * @param elements An iterable of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder readMethodArgs(Iterable<? extends JExpression> elements) {
      this.readMethodArgs = ImmutableList.builder();
      return addAllReadMethodArgs(elements);
    }

    /**
     * Adds elements to {@link XmlTypeState#readMethodArgs() readMethodArgs} list.
     * @param elements An iterable of readMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllReadMethodArgs(Iterable<? extends JExpression> elements) {
      this.readMethodArgs.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link XmlTypeState#writeMethod() writeMethod} attribute.
     * @param writeMethod The value for writeMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeMethod(String writeMethod) {
      this.writeMethod = Objects.requireNonNull(writeMethod, "writeMethod");
      initBits &= ~INIT_BIT_WRITE_METHOD;
      return this;
    }

    /**
     * Adds one element to {@link XmlTypeState#writeMethodArgs() writeMethodArgs} list.
     * @param element A writeMethodArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addWriteMethodArgs(JExpression element) {
      this.writeMethodArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link XmlTypeState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An array of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addWriteMethodArgs(JExpression... elements) {
      this.writeMethodArgs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link XmlTypeState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An iterable of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeMethodArgs(Iterable<? extends JExpression> elements) {
      this.writeMethodArgs = ImmutableList.builder();
      return addAllWriteMethodArgs(elements);
    }

    /**
     * Adds elements to {@link XmlTypeState#writeMethodArgs() writeMethodArgs} list.
     * @param elements An iterable of writeMethodArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllWriteMethodArgs(Iterable<? extends JExpression> elements) {
      this.writeMethodArgs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link XmlTypeState#xmlTypes() xmlTypes} list.
     * @param element A xmlTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXmlTypes(String element) {
      this.xmlTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link XmlTypeState#xmlTypes() xmlTypes} list.
     * @param elements An array of xmlTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXmlTypes(String... elements) {
      this.xmlTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link XmlTypeState#xmlTypes() xmlTypes} list.
     * @param elements An iterable of xmlTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder xmlTypes(Iterable<String> elements) {
      this.xmlTypes = ImmutableList.builder();
      return addAllXmlTypes(elements);
    }

    /**
     * Adds elements to {@link XmlTypeState#xmlTypes() xmlTypes} list.
     * @param elements An iterable of xmlTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllXmlTypes(Iterable<String> elements) {
      this.xmlTypes.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableXmlTypeState ImmutableXmlTypeState}.
     * @return An immutable instance of XmlTypeState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableXmlTypeState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableXmlTypeState(
          schema,
          schemaBuilder,
          readMethod,
          readMethodArgs.build(),
          writeMethod,
          writeMethodArgs.build(),
          xmlTypes.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SCHEMA_BUILDER) != 0) attributes.add("schemaBuilder");
      if ((initBits & INIT_BIT_READ_METHOD) != 0) attributes.add("readMethod");
      if ((initBits & INIT_BIT_WRITE_METHOD) != 0) attributes.add("writeMethod");
      return "Cannot build XmlTypeState, some of required attributes are not set " + attributes;
    }
  }
}
