/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.xml;

import com.github.jcustenborder.kafka.connect.xml.Nullable;
import com.github.jcustenborder.kafka.connect.xml.State;
import com.github.jcustenborder.kafka.connect.xml.StaticTypeState;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="StaticTypeState", generator="Immutables")
@SuppressFBWarnings
@Immutable
final class ImmutableStaticTypeState
implements StaticTypeState {
    @Nullable
    private final JExpression schema;
    private final JExpression schemaBuilder;
    private final String readMethod;
    private final ImmutableList<JExpression> readMethodArgs;
    private final String writeMethod;
    private final ImmutableList<JExpression> writeMethodArgs;
    private final ImmutableList<JType> types;

    private ImmutableStaticTypeState(@Nullable JExpression schema, JExpression schemaBuilder, String readMethod, ImmutableList<JExpression> readMethodArgs, String writeMethod, ImmutableList<JExpression> writeMethodArgs, ImmutableList<JType> types) {
        this.schema = schema;
        this.schemaBuilder = schemaBuilder;
        this.readMethod = readMethod;
        this.readMethodArgs = readMethodArgs;
        this.writeMethod = writeMethod;
        this.writeMethodArgs = writeMethodArgs;
        this.types = types;
    }

    @Override
    @Nullable
    public JExpression schema() {
        return this.schema;
    }

    @Override
    public JExpression schemaBuilder() {
        return this.schemaBuilder;
    }

    @Override
    public String readMethod() {
        return this.readMethod;
    }

    public ImmutableList<JExpression> readMethodArgs() {
        return this.readMethodArgs;
    }

    @Override
    public String writeMethod() {
        return this.writeMethod;
    }

    public ImmutableList<JExpression> writeMethodArgs() {
        return this.writeMethodArgs;
    }

    public ImmutableList<JType> types() {
        return this.types;
    }

    public final ImmutableStaticTypeState withSchema(@Nullable JExpression value) {
        if (this.schema == value) {
            return this;
        }
        return new ImmutableStaticTypeState(value, this.schemaBuilder, this.readMethod, this.readMethodArgs, this.writeMethod, this.writeMethodArgs, this.types);
    }

    public final ImmutableStaticTypeState withSchemaBuilder(JExpression value) {
        if (this.schemaBuilder == value) {
            return this;
        }
        JExpression newValue = Objects.requireNonNull(value, "schemaBuilder");
        return new ImmutableStaticTypeState(this.schema, newValue, this.readMethod, this.readMethodArgs, this.writeMethod, this.writeMethodArgs, this.types);
    }

    public final ImmutableStaticTypeState withReadMethod(String value) {
        String newValue = Objects.requireNonNull(value, "readMethod");
        if (this.readMethod.equals(newValue)) {
            return this;
        }
        return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, newValue, this.readMethodArgs, this.writeMethod, this.writeMethodArgs, this.types);
    }

    public final ImmutableStaticTypeState withReadMethodArgs(JExpression ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, this.readMethod, (ImmutableList<JExpression>)newValue, this.writeMethod, this.writeMethodArgs, this.types);
    }

    public final ImmutableStaticTypeState withReadMethodArgs(Iterable<? extends JExpression> elements) {
        if (this.readMethodArgs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, this.readMethod, (ImmutableList<JExpression>)newValue, this.writeMethod, this.writeMethodArgs, this.types);
    }

    public final ImmutableStaticTypeState withWriteMethod(String value) {
        String newValue = Objects.requireNonNull(value, "writeMethod");
        if (this.writeMethod.equals(newValue)) {
            return this;
        }
        return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, this.readMethod, this.readMethodArgs, newValue, this.writeMethodArgs, this.types);
    }

    public final ImmutableStaticTypeState withWriteMethodArgs(JExpression ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, this.readMethod, this.readMethodArgs, this.writeMethod, (ImmutableList<JExpression>)newValue, this.types);
    }

    public final ImmutableStaticTypeState withWriteMethodArgs(Iterable<? extends JExpression> elements) {
        if (this.writeMethodArgs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, this.readMethod, this.readMethodArgs, this.writeMethod, (ImmutableList<JExpression>)newValue, this.types);
    }

    public final ImmutableStaticTypeState withTypes(JType ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, this.readMethod, this.readMethodArgs, this.writeMethod, this.writeMethodArgs, (ImmutableList<JType>)newValue);
    }

    public final ImmutableStaticTypeState withTypes(Iterable<? extends JType> elements) {
        if (this.types == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, this.readMethod, this.readMethodArgs, this.writeMethod, this.writeMethodArgs, (ImmutableList<JType>)newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStaticTypeState && this.equalTo((ImmutableStaticTypeState)another);
    }

    private boolean equalTo(ImmutableStaticTypeState another) {
        return Objects.equals(this.schema, another.schema) && this.schemaBuilder.equals(another.schemaBuilder) && this.readMethod.equals(another.readMethod) && this.readMethodArgs.equals(another.readMethodArgs) && this.writeMethod.equals(another.writeMethod) && this.writeMethodArgs.equals(another.writeMethodArgs) && this.types.equals(another.types);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.schema);
        h += (h << 5) + this.schemaBuilder.hashCode();
        h += (h << 5) + this.readMethod.hashCode();
        h += (h << 5) + this.readMethodArgs.hashCode();
        h += (h << 5) + this.writeMethod.hashCode();
        h += (h << 5) + this.writeMethodArgs.hashCode();
        h += (h << 5) + this.types.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StaticTypeState").omitNullValues().add("schema", (Object)this.schema).add("schemaBuilder", (Object)this.schemaBuilder).add("readMethod", (Object)this.readMethod).add("readMethodArgs", this.readMethodArgs).add("writeMethod", (Object)this.writeMethod).add("writeMethodArgs", this.writeMethodArgs).add("types", this.types).toString();
    }

    public static ImmutableStaticTypeState copyOf(StaticTypeState instance) {
        if (instance instanceof ImmutableStaticTypeState) {
            return (ImmutableStaticTypeState)instance;
        }
        return ImmutableStaticTypeState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StaticTypeState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCHEMA_BUILDER = 1L;
        private static final long INIT_BIT_READ_METHOD = 2L;
        private static final long INIT_BIT_WRITE_METHOD = 4L;
        private long initBits = 7L;
        @javax.annotation.Nullable
        private JExpression schema;
        @javax.annotation.Nullable
        private JExpression schemaBuilder;
        @javax.annotation.Nullable
        private String readMethod;
        private ImmutableList.Builder<JExpression> readMethodArgs = ImmutableList.builder();
        @javax.annotation.Nullable
        private String writeMethod;
        private ImmutableList.Builder<JExpression> writeMethodArgs = ImmutableList.builder();
        private ImmutableList.Builder<JType> types = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(StaticTypeState instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(State instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            State instance;
            if (object instanceof StaticTypeState) {
                instance = (StaticTypeState)object;
                this.addAllTypes(instance.types());
            }
            if (object instanceof State) {
                instance = (State)object;
                JExpression schemaValue = instance.schema();
                if (schemaValue != null) {
                    this.schema(schemaValue);
                }
                this.schemaBuilder(instance.schemaBuilder());
                this.addAllReadMethodArgs(instance.readMethodArgs());
                this.writeMethod(instance.writeMethod());
                this.readMethod(instance.readMethod());
                this.addAllWriteMethodArgs(instance.writeMethodArgs());
            }
        }

        public final Builder schema(@Nullable JExpression schema) {
            this.schema = schema;
            return this;
        }

        public final Builder schemaBuilder(JExpression schemaBuilder) {
            this.schemaBuilder = Objects.requireNonNull(schemaBuilder, "schemaBuilder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder readMethod(String readMethod) {
            this.readMethod = Objects.requireNonNull(readMethod, "readMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addReadMethodArgs(JExpression element) {
            this.readMethodArgs.add((Object)element);
            return this;
        }

        public final Builder addReadMethodArgs(JExpression ... elements) {
            this.readMethodArgs.add((Object[])elements);
            return this;
        }

        public final Builder readMethodArgs(Iterable<? extends JExpression> elements) {
            this.readMethodArgs = ImmutableList.builder();
            return this.addAllReadMethodArgs(elements);
        }

        public final Builder addAllReadMethodArgs(Iterable<? extends JExpression> elements) {
            this.readMethodArgs.addAll(elements);
            return this;
        }

        public final Builder writeMethod(String writeMethod) {
            this.writeMethod = Objects.requireNonNull(writeMethod, "writeMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addWriteMethodArgs(JExpression element) {
            this.writeMethodArgs.add((Object)element);
            return this;
        }

        public final Builder addWriteMethodArgs(JExpression ... elements) {
            this.writeMethodArgs.add((Object[])elements);
            return this;
        }

        public final Builder writeMethodArgs(Iterable<? extends JExpression> elements) {
            this.writeMethodArgs = ImmutableList.builder();
            return this.addAllWriteMethodArgs(elements);
        }

        public final Builder addAllWriteMethodArgs(Iterable<? extends JExpression> elements) {
            this.writeMethodArgs.addAll(elements);
            return this;
        }

        public final Builder addTypes(JType element) {
            this.types.add((Object)element);
            return this;
        }

        public final Builder addTypes(JType ... elements) {
            this.types.add((Object[])elements);
            return this;
        }

        public final Builder types(Iterable<? extends JType> elements) {
            this.types = ImmutableList.builder();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<? extends JType> elements) {
            this.types.addAll(elements);
            return this;
        }

        public ImmutableStaticTypeState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStaticTypeState(this.schema, this.schemaBuilder, this.readMethod, (ImmutableList<JExpression>)this.readMethodArgs.build(), this.writeMethod, (ImmutableList<JExpression>)this.writeMethodArgs.build(), (ImmutableList<JType>)this.types.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("schemaBuilder");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("readMethod");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("writeMethod");
            }
            return "Cannot build StaticTypeState, some of required attributes are not set " + attributes;
        }
    }
}

