/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.serialization.jackson;

import com.github.jcustenborder.kafka.serialization.jackson.JacksonDeserializer;
import com.github.jcustenborder.kafka.serialization.jackson.JacksonSerializer;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public class JacksonSerde<T>
implements Serde<T> {
    private final Serializer<T> serializer;
    private final Deserializer<T> deserializer;

    private JacksonSerde(Class<T> cls) {
        this.deserializer = new JacksonDeserializer<T>(cls);
        this.serializer = new JacksonSerializer();
    }

    public JacksonSerde() {
        this.deserializer = new JacksonDeserializer();
        this.serializer = new JacksonSerializer();
    }

    public static final <T> JacksonSerde<T> of(Class<T> cls) {
        return new JacksonSerde<T>(cls);
    }

    public void configure(Map<String, ?> settings, boolean isKey) {
        this.serializer.configure(settings, isKey);
        this.deserializer.configure(settings, isKey);
    }

    public void close() {
        this.deserializer.close();
        this.serializer.close();
    }

    public Serializer<T> serializer() {
        return this.serializer;
    }

    public Deserializer<T> deserializer() {
        return this.deserializer;
    }
}

