/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.serialization.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jcustenborder.kafka.serialization.jackson.JacksonSerializerConfig;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class JacksonSerializer<T>
implements Serializer<T> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private JacksonSerializerConfig config;

    public static Map<String, String> nonDefaultSettings(ObjectMapper objectMapper) {
        return JacksonSerializerConfig.nonDefaultSettings(objectMapper);
    }

    public void configure(Map<String, ?> settings, boolean isKey) {
        this.config = new JacksonSerializerConfig(settings);
        this.config.configure(this.objectMapper);
    }

    public byte[] serialize(String topic, T message) {
        if (null == message) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes(message);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void close() {
    }
}

