/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.salesforce.rest;

import com.github.jcustenborder.salesforce.rest.SalesforceRestClient;
import com.github.jcustenborder.salesforce.rest.SalesforceRestClientConfig;
import com.github.jcustenborder.salesforce.rest.model.ApiVersion;
import com.github.jcustenborder.salesforce.rest.model.ApiVersions;
import com.github.jcustenborder.salesforce.rest.model.AuthenticationResponse;
import com.github.jcustenborder.salesforce.rest.model.PushTopic;
import com.github.jcustenborder.salesforce.rest.model.PushTopicQueryResult;
import com.github.jcustenborder.salesforce.rest.model.SObjectDescriptor;
import com.github.jcustenborder.salesforce.rest.model.SObjectMetadata;
import com.github.jcustenborder.salesforce.rest.model.SObjectsResponse;
import com.github.jcustenborder.salesforce.rest.model.SalesforceException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SalesforceRestClientImpl
implements SalesforceRestClient {
    static final Logger log = LoggerFactory.getLogger(SalesforceRestClientImpl.class);
    public static final JsonFactory JSON_FACTORY = new JacksonFactory();
    final SalesforceRestClientConfig config;
    final GenericUrl authenticateUrl = new GenericUrl("https://login.salesforce.com/services/oauth2/token");
    final HttpRequestFactory requestFactory;
    final HttpTransport httpTransport;
    AuthenticationResponse authentication;
    GenericUrl baseUrl;
    GenericUrl versionBaseUrl;

    public SalesforceRestClientImpl(SalesforceRestClientConfig config) {
        this(config, (HttpTransport)new NetHttpTransport());
    }

    public SalesforceRestClientImpl(final SalesforceRestClientConfig config, HttpTransport httpTransport) {
        this.config = config;
        this.httpTransport = httpTransport;
        java.util.logging.Logger transportLogger = java.util.logging.Logger.getLogger(HttpTransport.class.getName());
        transportLogger.setLevel(Level.ALL);
        transportLogger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (Level.INFO.equals(record.getLevel())) {
                    log.info(record.getMessage());
                } else if (Level.WARNING.equals(record.getLevel())) {
                    log.warn(record.getMessage());
                } else if (Level.SEVERE.equals(record.getLevel())) {
                    log.error(record.getMessage());
                }
                log.debug(record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        this.requestFactory = httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                if (config.curlLogging) {
                    request.setCurlLoggingEnabled(true);
                    request.setLoggingEnabled(true);
                }
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
                if (null != SalesforceRestClientImpl.this.authentication) {
                    String headerValue = String.format("%s %s", SalesforceRestClientImpl.this.authentication.tokenType(), SalesforceRestClientImpl.this.authentication.accessToken());
                    request.getHeaders().setAuthorization(headerValue);
                }
            }
        });
    }

    UrlEncodedContent buildAuthContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("grant_type", "password");
        content.put("client_id", this.config.consumerKey);
        content.put("client_secret", this.config.consumerSecret);
        content.put("username", this.config.username);
        String password = String.format("%s%s", this.config.password, this.config.passwordToken);
        content.put("password", password);
        return new UrlEncodedContent(content);
    }

    <T> T executeAndParse(HttpRequest request, Class<T> cls) throws IOException {
        log.trace("executeAndParse() - Calling {} on {}", (Object)request.getRequestMethod(), (Object)request.getUrl());
        HttpResponse response = request.execute();
        if (response.isSuccessStatusCode()) {
            return (T)response.parseAs(cls);
        }
        SalesforceException exception = (SalesforceException)response.parseAs(SalesforceException.class);
        throw exception;
    }

    <T> T getAndParse(GenericUrl url, Class<T> cls) throws IOException {
        HttpRequest request = this.requestFactory.buildGetRequest(url);
        return this.executeAndParse(request, cls);
    }

    <T> T postAndParse(GenericUrl url, HttpContent content, Class<T> cls) throws IOException {
        HttpRequest request = this.requestFactory.buildPostRequest(url, content);
        return this.executeAndParse(request, cls);
    }

    @Override
    public AuthenticationResponse authenticate() throws IOException {
        UrlEncodedContent formContent = this.buildAuthContent();
        this.authentication = this.postAndParse(this.authenticateUrl, (HttpContent)formContent, AuthenticationResponse.class);
        this.baseUrl = null == this.config.instance || this.config.instance.isEmpty() ? new GenericUrl(this.authentication.instanceUrl()) : new GenericUrl(this.config.instance);
        return this.authentication;
    }

    @Override
    public void apiVersion(ApiVersion apiVersion) {
        GenericUrl versionUrl = this.baseUrl.clone();
        versionUrl.appendRawPath(apiVersion.url());
        this.versionBaseUrl = versionUrl;
    }

    @Override
    public List<ApiVersion> apiVersions() throws IOException {
        GenericUrl versionsUrl = this.baseUrl.clone();
        versionsUrl.appendRawPath("/services/data/");
        List apiVersions = this.getAndParse(versionsUrl, ApiVersions.class);
        Collections.sort(apiVersions);
        Collections.reverse(apiVersions);
        Preconditions.checkState((!apiVersions.isEmpty() ? 1 : 0) != 0, (Object)"No api versions were found.");
        return apiVersions;
    }

    @Override
    public SObjectsResponse objects() throws IOException {
        GenericUrl objectsUrl = this.versionBaseUrl.clone();
        objectsUrl.appendRawPath("/sobjects/");
        SObjectsResponse response = this.getAndParse(objectsUrl, SObjectsResponse.class);
        return response;
    }

    @Override
    public SObjectDescriptor describe(SObjectMetadata metadata) throws IOException {
        String describeUrlText = metadata.urls().get("describe");
        GenericUrl describeUrl = this.baseUrl.clone();
        describeUrl.appendRawPath(describeUrlText);
        return this.getAndParse(describeUrl, SObjectDescriptor.class);
    }

    @Override
    public List<PushTopic> pushTopics() throws IOException {
        GenericUrl pushTopicsUrl = this.versionBaseUrl.clone();
        pushTopicsUrl.appendRawPath("/query/");
        pushTopicsUrl.set("q", (Object)"SELECT Name, Query, ApiVersion, NotifyForOperationCreate, NotifyForOperationUpdate, NotifyForOperationUndelete, NotifyForOperationDelete, NotifyForFields from PushTopic");
        PushTopicQueryResult queryResult = this.getAndParse(pushTopicsUrl, PushTopicQueryResult.class);
        return queryResult.records();
    }

    @Override
    public void pushTopic(PushTopic pushTopic) throws IOException {
        JsonHttpContent httpContent = new JsonHttpContent(JSON_FACTORY, (Object)pushTopic);
        GenericUrl pushTopicsUrl = this.versionBaseUrl.clone();
        pushTopicsUrl.appendRawPath("/sobjects/PushTopic");
        this.postAndParse(pushTopicsUrl, (HttpContent)httpContent, Map.class);
    }
}

