/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica;

import com.github.jcustenborder.vertica.VerticaColumnInfo;
import com.github.jcustenborder.vertica.VerticaStreamWriter;
import com.github.jcustenborder.vertica.VerticaStreamWriterBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VerticaNativeStreamWriter
implements VerticaStreamWriter {
    private static final Logger log = LoggerFactory.getLogger(VerticaNativeStreamWriter.class);
    final OutputStream outputStream;
    final WritableByteChannel channel;
    final ByteBuffer rowBuffer;
    final ByteBuffer rowHeaderBuffer;
    final List<VerticaColumnInfo> columns;
    final int nullMarkerBufferSize;
    static final byte[] HEADER = BaseEncoding.base16().decode((CharSequence)"4E41544956450AFF0D0A00");

    VerticaNativeStreamWriter(VerticaStreamWriterBuilder builder, OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        this.channel = Channels.newChannel(this.outputStream);
        this.columns = ImmutableList.copyOf(builder.columnInfos);
        log.trace("ctor() - Allocating row buffer of {} bytes.", (Object)builder.rowBufferSize);
        this.rowBuffer = ByteBuffer.allocate(builder.rowBufferSize);
        this.rowBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.nullMarkerBufferSize = (int)Math.ceil((double)this.columns.size() / 8.0);
        int rowHeaderSize = this.nullMarkerBufferSize + 4;
        log.trace("ctor() - Allocating {} byte(s) for row header.", (Object)rowHeaderSize);
        this.rowHeaderBuffer = ByteBuffer.allocate(rowHeaderSize).order(ByteOrder.LITTLE_ENDIAN);
        log.trace("ctor() - Writing header");
        this.rowBuffer.put(HEADER);
        int headerLength = this.columns.size() * 4 + 5;
        log.trace("ctor() - Header length {} byte(s).", (Object)headerLength);
        this.rowBuffer.putInt(headerLength);
        this.rowBuffer.putShort((short)1);
        this.rowBuffer.put((byte)0);
        this.rowBuffer.putShort((short)this.columns.size());
        for (VerticaColumnInfo columnInfo : this.columns) {
            log.trace("ctor() - Setting length for '{}' to {} byte(s).", (Object)columnInfo.name, (Object)columnInfo.size);
            this.rowBuffer.putInt(columnInfo.size);
        }
        this.rowBuffer.flip();
        log.trace("ctor() - Writing {} byte(s) for header.", (Object)this.rowBuffer.remaining());
        this.channel.write(this.rowBuffer);
    }

    @Override
    public void close() throws IOException {
    }

    byte[] nullMarkers(Object[] row) {
        byte[] buffer = new byte[this.nullMarkerBufferSize];
        for (int i = 0; i < row.length; ++i) {
            boolean isNull = null == row[i];
            int index = (int)Math.floor((double)i / 8.0);
            int bitIdx = i - index * 8;
            if (!isNull) continue;
            int n = index;
            buffer[n] = (byte)(buffer[n] | 1 << bitIdx);
            log.trace("nullMarkers() - Setting bit {} to {}. index={}", new Object[]{i, isNull, index});
        }
        return buffer;
    }

    @Override
    public void write(Object[] row) throws IOException {
        Preconditions.checkNotNull((Object)row, (Object)"row cannot be null.");
        Preconditions.checkState((this.columns.size() == row.length ? 1 : 0) != 0, (Object)"The length of the row array must be equal to the number of columns");
        this.rowBuffer.clear();
        this.rowHeaderBuffer.clear();
        for (int i = 0; i < row.length; ++i) {
            VerticaColumnInfo columnInfo = this.columns.get(i);
            log.trace("write() - Writing value for {} - {}", (Object)i, (Object)columnInfo.name);
            columnInfo.encode(this.rowBuffer, row[i]);
        }
        log.trace("write() - wrote {} byte(s)", (Object)this.rowBuffer.position());
        byte[] nullMarker = this.nullMarkers(row);
        this.rowBuffer.flip();
        this.rowHeaderBuffer.putInt(this.rowBuffer.remaining());
        this.rowHeaderBuffer.put(nullMarker);
        this.rowHeaderBuffer.flip();
        log.trace("write() - writing {} byte(s) for row header.", (Object)this.rowHeaderBuffer.remaining());
        this.channel.write(this.rowHeaderBuffer);
        log.trace("write() - writing {} byte(s) for row.", (Object)this.rowBuffer.remaining());
        this.channel.write(this.rowBuffer);
    }
}

