/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NumericBigDecimalEncoder
extends Encoder<BigDecimal> {
    private static final Logger log = LoggerFactory.getLogger(NumericBigDecimalEncoder.class);

    NumericBigDecimalEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.NUMERIC;
    }

    @Override
    public Class<BigDecimal> inputType() {
        return BigDecimal.class;
    }

    @Override
    public void encode(ByteBuffer buffer, BigDecimal input, String name, int size, int scale) {
        int i;
        log.trace("input = {}", (Object)input);
        Preconditions.checkState((scale == input.scale() ? 1 : 0) != 0, (String)"Scale for '%s' is mismatched. Value(%s) does not match definition of %s.", (Object[])new Object[]{input.scale(), scale});
        BigInteger unscaled = input.unscaledValue();
        byte[] unscaledBuffer = unscaled.toByteArray();
        log.trace("bufferSize:{}", (Object)size);
        ByteBuffer byteBuffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        int bufferMinusScale = size - 5;
        int paddingNeeded = bufferMinusScale - unscaledBuffer.length;
        log.trace("Padding with {} byte(s).", (Object)paddingNeeded);
        for (i = 0; i < paddingNeeded; ++i) {
            byteBuffer.put((byte)0);
        }
        for (i = unscaledBuffer.length - 1; i >= 0; --i) {
            byteBuffer.put(unscaledBuffer[i]);
        }
        byteBuffer.put((byte)0);
        byteBuffer.putInt(scale);
        byteBuffer.flip();
        buffer.put(byteBuffer);
    }
}

