/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeTZOffsetTimeEncoder
extends Encoder<OffsetTime> {
    private static final Logger log = LoggerFactory.getLogger(TimeTZOffsetTimeEncoder.class);

    TimeTZOffsetTimeEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.TIMETZ;
    }

    @Override
    public Class<OffsetTime> inputType() {
        return OffsetTime.class;
    }

    @Override
    public void encode(ByteBuffer buffer, OffsetTime input, String name, int size, int scale) {
        OffsetTime midnight = OffsetTime.of(LocalTime.MIDNIGHT, ZoneOffset.UTC);
        OffsetTime utcAdjust = input.withOffsetSameInstant(ZoneOffset.UTC);
        Duration duration = Duration.between(midnight, utcAdjust);
        log.trace("duration= {}", (Object)duration.getSeconds());
        log.trace("input = {}", (Object)input);
        long microseconds = TimeUnit.HOURS.toMicros(utcAdjust.getHour()) + TimeUnit.MINUTES.toMicros(utcAdjust.getMinute()) + TimeUnit.SECONDS.toMicros(utcAdjust.getSecond()) + TimeUnit.NANOSECONDS.toMicros(utcAdjust.getNano());
        long offset = TimeUnit.HOURS.toSeconds(24L) + (long)input.getOffset().getTotalSeconds();
        log.trace("microseconds = {} offset = {}", (Object)microseconds, (Object)offset);
        long storage = (microseconds << 24) + offset;
        log.trace("storage = {}", (Object)storage);
        buffer.putLong(storage);
    }
}

