/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UTCTimestampTZEncoder<T>
extends Encoder<T> {
    private static final Logger log = LoggerFactory.getLogger(UTCTimestampTZEncoder.class);
    static final TimeZone TIME_ZONE_UTC = TimeZone.getTimeZone("UTC");
    static final ZoneId TIME_ZONE_UTC_ZONEID = TimeZone.getTimeZone("UTC").toZoneId();

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.TIMESTAMPTZ;
    }

    protected abstract long utcTime(T var1);

    @Override
    public void encode(ByteBuffer buffer, T input, String name, int size, int scale) {
        log.trace("input = {}", input);
        long utcTime = this.utcTime(input);
        long storage = utcTime * 1000L - 946684800000000L;
        log.trace("storage = {}", (Object)storage);
        buffer.putLong(storage);
    }
}

