/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica;

import com.github.jcustenborder.vertica.VerticaBinaryStreamWriter;
import com.github.jcustenborder.vertica.VerticaColumnInfo;
import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.VerticaCompressionType;
import com.github.jcustenborder.vertica.VerticaStreamWriter;
import com.github.jcustenborder.vertica.VerticaStreamWriterType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class VerticaStreamWriterBuilder {
    String schema;
    String database;
    String table;
    int rowBufferSize = 0x100000;
    VerticaStreamWriterType streamWriterType = VerticaStreamWriterType.BINARY;
    VerticaCompressionType compressionType = VerticaCompressionType.NONE;
    List<VerticaColumnInfo> columnInfos = new ArrayList<VerticaColumnInfo>();

    public int rowBufferSize() {
        return this.rowBufferSize;
    }

    public VerticaStreamWriterBuilder rowBufferSize(int rowBufferSize) {
        this.rowBufferSize = rowBufferSize;
        return this;
    }

    public VerticaStreamWriter build(OutputStream outputStream) throws IOException {
        VerticaBinaryStreamWriter writer;
        switch (this.streamWriterType) {
            case BINARY: {
                writer = new VerticaBinaryStreamWriter(this, outputStream);
                break;
            }
            default: {
                throw new UnsupportedEncodingException(String.format("Unsupported stream writer type of %s", new Object[]{this.streamWriterType}));
            }
        }
        return writer;
    }

    public VerticaStreamWriterBuilder column(String name, VerticaColumnType type, int size) {
        VerticaColumnInfo columnInfo = new VerticaColumnInfo(name, type, size);
        this.columnInfos.add(columnInfo);
        return this;
    }

    public VerticaStreamWriterBuilder column(String name, VerticaColumnType type) {
        VerticaColumnInfo columnInfo = new VerticaColumnInfo(name, type);
        this.columnInfos.add(columnInfo);
        return this;
    }

    public VerticaStreamWriterBuilder column(String name, VerticaColumnType type, int precision, int scale) {
        VerticaColumnInfo columnInfo = new VerticaColumnInfo(name, type, -1, precision, scale);
        this.columnInfos.add(columnInfo);
        return this;
    }

    public String schema() {
        return this.schema;
    }

    public VerticaStreamWriterBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public String database() {
        return this.database;
    }

    public VerticaStreamWriterBuilder database(String database) {
        this.database = database;
        return this;
    }

    public String table() {
        return this.table;
    }

    public VerticaStreamWriterType streamWriterType() {
        return this.streamWriterType;
    }

    public VerticaStreamWriterBuilder streamWriterType(VerticaStreamWriterType streamWriterType) {
        this.streamWriterType = streamWriterType;
        return this;
    }

    public VerticaCompressionType compressionType() {
        return this.compressionType;
    }

    public VerticaStreamWriterBuilder compressionType(VerticaCompressionType compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    public VerticaStreamWriterBuilder table(String table) {
        this.table = table;
        return this;
    }
}

