/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegerByteEncoder
extends Encoder<Byte> {
    private static final Logger log = LoggerFactory.getLogger(IntegerByteEncoder.class);

    IntegerByteEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.INTEGER;
    }

    @Override
    public Class<Byte> inputType() {
        return Byte.class;
    }

    @Override
    public void encode(ByteBuffer buffer, Byte input, String name, int size, int scale) {
        Preconditions.checkState((size == 1 ? 1 : 0) != 0, (Object)"Expected size should be 1.");
        log.trace("input = {}", (Object)input);
        buffer.put(input);
    }
}

