/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import java.nio.ByteBuffer;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntervalDurationEncoder
extends Encoder<Duration> {
    private static final Logger log = LoggerFactory.getLogger(IntervalDurationEncoder.class);

    IntervalDurationEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.INTERVAL;
    }

    @Override
    public Class<Duration> inputType() {
        return Duration.class;
    }

    @Override
    public void encode(ByteBuffer buffer, Duration input, String name, int size, int scale) {
        log.trace("input = {}", (Object)input);
        long micros = 1000L * input.toMillis();
        buffer.putLong(micros);
    }
}

