/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.Constants;
import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import java.nio.ByteBuffer;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UTCTimeEncoder<T>
extends Encoder<T> {
    private static final Logger log = LoggerFactory.getLogger(UTCTimeEncoder.class);
    final Calendar calendar = Calendar.getInstance(Constants.UTC_TIMEZONE);

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.TIME;
    }

    protected abstract long utcTime(T var1);

    @Override
    public void encode(ByteBuffer buffer, T input, String name, int size, int scale) {
        log.trace("input = {}", input);
        long utcTime = this.utcTime(input);
        this.calendar.setTimeInMillis(utcTime);
        this.calendar.set(2000, 0, 1);
        long storage = this.calendar.getTimeInMillis() * 1000L - 946684800000000L;
        log.trace("storage = {}", (Object)storage);
        buffer.putLong(storage);
    }
}

