/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica;

import com.github.jcustenborder.vertica.Constants;
import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.github.jcustenborder.vertica.binary.Encoders;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticaColumnInfo {
    private static final Logger log = LoggerFactory.getLogger(VerticaColumnInfo.class);
    final String name;
    final VerticaColumnType type;
    final int size;
    final int precision;
    final int scale;
    final Calendar calendar;
    final Encoders encoders = new Encoders();

    public String name() {
        return this.name;
    }

    public VerticaColumnType type() {
        return this.type;
    }

    public int size() {
        return this.size;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    VerticaColumnInfo(String name, VerticaColumnType type, int size, int precision, int scale) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null.");
        this.name = name;
        this.type = type;
        if (VerticaColumnType.NUMERIC == type) {
            Preconditions.checkState((precision > 0 ? 1 : 0) != 0, (Object)"precision must be greater than zero.");
            Preconditions.checkState((scale > -1 ? 1 : 0) != 0, (Object)"scale must be greater than -1.");
            this.size = VerticaColumnInfo.numericSize(precision);
        } else {
            this.size = size;
        }
        this.precision = precision;
        this.scale = scale;
        this.calendar = Calendar.getInstance(Constants.UTC_TIMEZONE);
    }

    VerticaColumnInfo(String name, VerticaColumnType type) {
        this(name, type, VerticaColumnInfo.sizeForType(type), -1, -1);
    }

    VerticaColumnInfo(String name, VerticaColumnType type, int size) {
        this(name, type, size, -1, -1);
    }

    VerticaColumnInfo(String name, VerticaColumnType type, int precision, int scale) {
        this(name, type, VerticaColumnInfo.numericSize(precision), precision, scale);
    }

    static final int sizeForType(VerticaColumnType type) {
        int size;
        switch (type) {
            case BOOLEAN: {
                size = 1;
                break;
            }
            case FLOAT: {
                size = 8;
                break;
            }
            case DATE: {
                size = 8;
                break;
            }
            case TIME: {
                size = 8;
                break;
            }
            case TIMETZ: {
                size = 8;
                break;
            }
            case TIMESTAMP: {
                size = 8;
                break;
            }
            case TIMESTAMPTZ: {
                size = 8;
                break;
            }
            case INTERVAL: {
                size = 8;
                break;
            }
            case VARBINARY: 
            case VARCHAR: {
                size = -1;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Size must be specified for type '%s'", new Object[]{type}));
            }
        }
        return size;
    }

    static int numericSize(int precision) {
        return (int)Math.ceil(((double)precision / 19.0 + 1.0) * 8.0);
    }

    void encode(ByteBuffer buffer, Object value) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null.");
        Preconditions.checkState((ByteOrder.LITTLE_ENDIAN == buffer.order() ? 1 : 0) != 0, (Object)"buffer.order() must be LITTLE_ENDIAN.");
        if (null == value) {
            log.trace("encode() - Skipping due to null value.");
            return;
        }
        Encoder encoder = this.encoders.get(this.type, value);
        if (null == encoder) {
            throw new UnsupportedOperationException(String.format("Encoder for %s:%s was found", new Object[]{this.type, value.getClass().getName()}));
        }
        encoder.encode(buffer, value, this.name, this.size, this.scale);
    }
}

