/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BinaryByteArrayEncoder
extends Encoder<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(BinaryByteArrayEncoder.class);

    BinaryByteArrayEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.BINARY;
    }

    @Override
    public Class<byte[]> inputType() {
        return byte[].class;
    }

    @Override
    public void encode(ByteBuffer buffer, byte[] input, String name, int size, int scale) {
        log.trace("input = {}", (Object)input);
        byte[] valueBuffer = input;
        Preconditions.checkState((size >= valueBuffer.length ? 1 : 0) != 0, (String)"Encoded input for '%s' is %s byte(s) but the column is only %s byte(s).", (Object[])new Object[]{name, valueBuffer.length, size});
        buffer.put(valueBuffer);
        int padding = size - valueBuffer.length;
        log.trace("padding input by {} byte(s).");
        for (int i = 0; i < padding; ++i) {
            buffer.put((byte)0);
        }
    }
}

