/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import java.util.Objects;

class EncoderKey
implements Comparable<EncoderKey> {
    final Class inputType;
    final VerticaColumnType columnType;

    EncoderKey(Class inputType, VerticaColumnType columnType) {
        this.inputType = inputType;
        this.columnType = columnType;
    }

    public static EncoderKey of(Class inputType, VerticaColumnType columnType) {
        return new EncoderKey(inputType, columnType);
    }

    public static EncoderKey of(Encoder encoder) {
        return EncoderKey.of(encoder.inputType(), encoder.columnType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnType, this.inputType});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnType", (Object)this.columnType).add("inputType", (Object)this.inputType.getName()).toString();
    }

    @Override
    public int compareTo(EncoderKey that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.columnType), (Comparable)((Object)that.columnType)).compare(this.inputType.hashCode(), that.inputType.hashCode()).result();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncoderKey) {
            return 0 == this.compareTo((EncoderKey)obj);
        }
        return false;
    }
}

