/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.BinaryByteArrayEncoder;
import com.github.jcustenborder.vertica.binary.BooleanBooleanEncoder;
import com.github.jcustenborder.vertica.binary.CharStringEncoder;
import com.github.jcustenborder.vertica.binary.DateSQLDateEncoder;
import com.github.jcustenborder.vertica.binary.DateUtilDateEncoder;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.github.jcustenborder.vertica.binary.EncoderKey;
import com.github.jcustenborder.vertica.binary.FloatDoubleEncoder;
import com.github.jcustenborder.vertica.binary.FloatFloatEncoder;
import com.github.jcustenborder.vertica.binary.IntegerByteEncoder;
import com.github.jcustenborder.vertica.binary.IntegerIntegerEncoder;
import com.github.jcustenborder.vertica.binary.IntegerLongEncoder;
import com.github.jcustenborder.vertica.binary.IntegerShortEncoder;
import com.github.jcustenborder.vertica.binary.IntervalDurationEncoder;
import com.github.jcustenborder.vertica.binary.IntervalLongEncoder;
import com.github.jcustenborder.vertica.binary.NumericBigDecimalEncoder;
import com.github.jcustenborder.vertica.binary.TimeSQLTimeEncoder;
import com.github.jcustenborder.vertica.binary.TimeTZOffsetTimeEncoder;
import com.github.jcustenborder.vertica.binary.TimeUtilDateEncoder;
import com.github.jcustenborder.vertica.binary.TimestampLocalDateTimeEncoder;
import com.github.jcustenborder.vertica.binary.TimestampSQLDateEncoder;
import com.github.jcustenborder.vertica.binary.TimestampSQLTimestampEncoder;
import com.github.jcustenborder.vertica.binary.TimestampTZSQLDateEncoder;
import com.github.jcustenborder.vertica.binary.TimestampTZUtilDateEncoder;
import com.github.jcustenborder.vertica.binary.TimestampTZZonedDateTimeEncoder;
import com.github.jcustenborder.vertica.binary.TimestampUtilDateEncoder;
import com.github.jcustenborder.vertica.binary.VarBinaryByteArrayEncoder;
import com.github.jcustenborder.vertica.binary.VarBinaryByteBufferEncoder;
import com.github.jcustenborder.vertica.binary.VarCharStringEncoder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encoders {
    private static final Logger log = LoggerFactory.getLogger(Encoders.class);
    final Map<EncoderKey, Encoder> encoders;

    public Encoders() {
        List<Encoder> encoders = Arrays.asList(new VarCharStringEncoder(), new VarBinaryByteArrayEncoder(), new VarBinaryByteBufferEncoder(), new IntegerByteEncoder(), new IntegerShortEncoder(), new IntegerIntegerEncoder(), new IntegerLongEncoder(), new FloatDoubleEncoder(), new FloatFloatEncoder(), new DateUtilDateEncoder(), new DateSQLDateEncoder(), new CharStringEncoder(), new BooleanBooleanEncoder(), new BinaryByteArrayEncoder(), new IntervalDurationEncoder(), new IntervalLongEncoder(), new NumericBigDecimalEncoder(), new TimestampSQLTimestampEncoder(), new TimestampUtilDateEncoder(), new TimestampLocalDateTimeEncoder(), new TimestampSQLDateEncoder(), new TimeSQLTimeEncoder(), new TimeUtilDateEncoder(), new TimestampTZZonedDateTimeEncoder(), new TimestampTZSQLDateEncoder(), new TimestampTZUtilDateEncoder(), new TimeTZOffsetTimeEncoder());
        this.encoders = ImmutableMap.copyOf((Map)Maps.uniqueIndex(encoders, EncoderKey::of));
        this.encoders.entrySet().stream().forEach(entry -> log.trace("ctor() - Mapping {} to {}", entry.getKey(), entry.getValue()));
    }

    public Encoder get(VerticaColumnType columnType, Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"value cannot be null.");
        EncoderKey key = EncoderKey.of(value.getClass(), columnType);
        return this.encoders.get(key);
    }
}

