/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegerIntegerEncoder
extends Encoder<Integer> {
    private static final Logger log = LoggerFactory.getLogger(IntegerIntegerEncoder.class);

    IntegerIntegerEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.INTEGER;
    }

    @Override
    public Class<Integer> inputType() {
        return Integer.class;
    }

    @Override
    public void encode(ByteBuffer buffer, Integer input, String name, int size, int scale) {
        Preconditions.checkState((size == 4 ? 1 : 0) != 0, (Object)"Expected size should be 4.");
        log.trace("input = {}", (Object)input);
        buffer.putInt(input);
    }
}

