/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegerShortEncoder
extends Encoder<Short> {
    private static final Logger log = LoggerFactory.getLogger(IntegerShortEncoder.class);

    IntegerShortEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.INTEGER;
    }

    @Override
    public Class<Short> inputType() {
        return Short.class;
    }

    @Override
    public void encode(ByteBuffer buffer, Short input, String name, int size, int scale) {
        Preconditions.checkState((size == 2 ? 1 : 0) != 0, (Object)"Expected size should be 2.");
        log.trace("input = {}", (Object)input);
        buffer.putShort(input);
    }
}

