/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntervalLongEncoder
extends Encoder<Long> {
    private static final Logger log = LoggerFactory.getLogger(IntervalLongEncoder.class);

    IntervalLongEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.INTERVAL;
    }

    @Override
    public Class<Long> inputType() {
        return Long.class;
    }

    @Override
    public void encode(ByteBuffer buffer, Long input, String name, int size, int scale) {
        Preconditions.checkState((size == 8 ? 1 : 0) != 0, (Object)"Expected size should be 8.");
        log.trace("input = {}", (Object)input);
        buffer.putLong(input);
    }
}

