/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica;

import com.github.jcustenborder.vertica.VerticaColumnInfo;
import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.VerticaCompressionType;
import com.github.jcustenborder.vertica.VerticaLoadMethod;
import com.github.jcustenborder.vertica.VerticaNativeStreamWriter;
import com.github.jcustenborder.vertica.VerticaStreamWriter;
import com.github.jcustenborder.vertica.VerticaStreamWriterType;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.anarres.lzo.LzoOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticaStreamWriterBuilder {
    private static final int MIN_ROW_BUFFER = 100;
    private static final Logger log = LoggerFactory.getLogger(VerticaStreamWriterBuilder.class);
    String schema;
    String table;
    int rowBufferSize = 0x100000;
    VerticaLoadMethod loadMethod;
    Integer compressionLevel;
    VerticaStreamWriterType streamWriterType = VerticaStreamWriterType.NATIVE;
    VerticaCompressionType compressionType = VerticaCompressionType.UNCOMPRESSED;
    List<VerticaColumnInfo> columnInfos = new ArrayList<VerticaColumnInfo>();

    public VerticaLoadMethod loadMethod() {
        return this.loadMethod;
    }

    public VerticaStreamWriterBuilder loadMethod(VerticaLoadMethod loadMethod) {
        this.loadMethod = loadMethod;
        return this;
    }

    public Integer compressionLevel() {
        return this.compressionLevel;
    }

    public VerticaStreamWriterBuilder compressionLevel(Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public int rowBufferSize() {
        return this.rowBufferSize;
    }

    public VerticaStreamWriterBuilder rowBufferSize(int rowBufferSize) {
        Preconditions.checkState((rowBufferSize > 100 ? 1 : 0) != 0, (String)"rowBufferSize must be greater than %s bytes.", (Object[])new Object[]{100});
        this.rowBufferSize = rowBufferSize;
        return this;
    }

    public VerticaStreamWriter build(OutputStream outputStream) throws IOException {
        VerticaNativeStreamWriter writer;
        OutputStream stream;
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream cannot be null.");
        Preconditions.checkNotNull((Object)this.table, (Object)"table cannot be null or empty.");
        Preconditions.checkState((!this.table.isEmpty() ? 1 : 0) != 0, (Object)"table cannot be null or empty.");
        switch (this.compressionType) {
            case BZIP: {
                if (null != this.compressionLevel) {
                    Preconditions.checkState((this.compressionLevel >= 1 && this.compressionLevel <= 9 ? 1 : 0) != 0, (String)"compressionLevel must be >= %s and <= %s. %s is invalid.", (Object[])new Object[]{1, 9, this.compressionLevel});
                    log.debug("Creating BZip2CompressorOutputStream with compressionLevel {}.", (Object)this.compressionLevel);
                    stream = new BZip2CompressorOutputStream(outputStream, this.compressionLevel.intValue());
                    break;
                }
                log.debug("Creating BZip2CompressorOutputStream with default compressionLevel.");
                stream = new BZip2CompressorOutputStream(outputStream);
                break;
            }
            case GZIP: {
                if (null != this.compressionLevel) {
                    Preconditions.checkState((this.compressionLevel >= 0 && this.compressionLevel <= 9 ? 1 : 0) != 0, (String)"compressionLevel must be >= %s and <= %s. %s is invalid.", (Object[])new Object[]{0, 9, this.compressionLevel});
                    GzipParameters parameters = new GzipParameters();
                    parameters.setCompressionLevel(this.compressionLevel.intValue());
                    log.debug("Creating GzipCompressorOutputStream with compressionLevel {}.", (Object)this.compressionLevel);
                    stream = new GzipCompressorOutputStream(outputStream, parameters);
                    break;
                }
                log.debug("Creating GzipCompressorOutputStream with default compressionLevel.");
                stream = new GzipCompressorOutputStream(outputStream);
                break;
            }
            case UNCOMPRESSED: {
                stream = outputStream;
                break;
            }
            case LZO: {
                log.debug("Creating LzoOutputStream with default compressionLevel.");
                stream = new LzoOutputStream(outputStream);
                break;
            }
            default: {
                throw new UnsupportedEncodingException(String.format("Unsupported compression type of %s", new Object[]{this.streamWriterType}));
            }
        }
        switch (this.streamWriterType) {
            case NATIVE: {
                writer = new VerticaNativeStreamWriter(this, stream);
                break;
            }
            default: {
                throw new UnsupportedEncodingException(String.format("Unsupported stream writer type of %s", new Object[]{this.streamWriterType}));
            }
        }
        return writer;
    }

    public VerticaStreamWriterBuilder column(String name, VerticaColumnType type, int size) {
        VerticaColumnInfo columnInfo = new VerticaColumnInfo(name, type, size);
        this.columnInfos.add(columnInfo);
        return this;
    }

    public VerticaStreamWriterBuilder column(String name, VerticaColumnType type) {
        VerticaColumnInfo columnInfo = new VerticaColumnInfo(name, type);
        this.columnInfos.add(columnInfo);
        return this;
    }

    public VerticaStreamWriterBuilder column(String name, VerticaColumnType type, int precision, int scale) {
        VerticaColumnInfo columnInfo = new VerticaColumnInfo(name, type, -1, precision, scale);
        this.columnInfos.add(columnInfo);
        return this;
    }

    public String schema() {
        return this.schema;
    }

    public VerticaStreamWriterBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public String table() {
        return this.table;
    }

    public VerticaStreamWriterType streamWriterType() {
        return this.streamWriterType;
    }

    public VerticaStreamWriterBuilder streamWriterType(VerticaStreamWriterType streamWriterType) {
        this.streamWriterType = streamWriterType;
        return this;
    }

    public VerticaCompressionType compressionType() {
        return this.compressionType;
    }

    public VerticaStreamWriterBuilder compressionType(VerticaCompressionType compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    public VerticaStreamWriterBuilder table(String table) {
        this.table = table;
        return this;
    }
}

